/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.function;

import com.google.common.base.Preconditions;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.function.RegionFunction;
import com.sk89q.worldedit.function.mask.Mask;

public class RegionMaskTestFunction
implements RegionFunction {
    private final RegionFunction pass;
    private final RegionFunction fail;
    private Mask mask;

    public RegionMaskTestFunction(Mask mask, RegionFunction success, RegionFunction failure) {
        Preconditions.checkNotNull((Object)success);
        Preconditions.checkNotNull((Object)failure);
        Preconditions.checkNotNull((Object)mask);
        this.pass = success;
        this.fail = failure;
        this.mask = mask;
    }

    @Override
    public boolean apply(Vector position) throws WorldEditException {
        if (this.mask.test(position)) {
            return this.pass.apply(position);
        }
        return this.fail.apply(position);
    }
}

