/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.extent;

import com.google.common.base.Preconditions;
import com.sk89q.worldedit.MutableBlockVector;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.Vector2D;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.extent.AbstractDelegateExtent;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.function.mask.Mask;
import com.sk89q.worldedit.world.biome.BaseBiome;
import com.sk89q.worldedit.world.block.BlockStateHolder;

public class MaskingExtent
extends AbstractDelegateExtent {
    private Mask mask;
    private MutableBlockVector mutable = new MutableBlockVector();

    public MaskingExtent(Extent extent, Mask mask) {
        super(extent);
        Preconditions.checkNotNull((Object)mask);
        this.mask = mask;
    }

    public Mask getMask() {
        return this.mask;
    }

    public void setMask(Mask mask) {
        Preconditions.checkNotNull((Object)mask);
        this.mask = mask;
    }

    @Override
    public boolean setBlock(Vector location, BlockStateHolder block) throws WorldEditException {
        return this.mask.test(location) && super.setBlock(location, block);
    }

    @Override
    public boolean setBiome(Vector2D position, BaseBiome biome) {
        return this.mask.test(this.mutable.setComponents(position.getBlockX(), 0, position.getBlockZ())) && super.setBiome(position, biome);
    }

    @Override
    public boolean setBiome(int x, int y, int z, BaseBiome biome) {
        return this.mask.test(this.mutable.setComponents(x, y, z)) && super.setBiome(x, y, z, biome);
    }
}

