/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.command;

import com.boydti.fawe.config.Commands;
import com.google.common.base.Preconditions;
import com.sk89q.minecraft.util.commands.Command;
import com.sk89q.minecraft.util.commands.CommandContext;
import com.sk89q.minecraft.util.commands.CommandLocals;
import com.sk89q.minecraft.util.commands.CommandPermissions;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.util.command.CommandCallable;
import com.sk89q.worldedit.util.command.Dispatcher;
import java.lang.reflect.Method;
import java.util.concurrent.ConcurrentHashMap;

public class MethodCommands {
    public final WorldEdit worldEdit;
    private ConcurrentHashMap<Method, CommandCallable> callables;
    private Dispatcher dispatcher;

    public MethodCommands(WorldEdit worldEdit) {
        Preconditions.checkNotNull((Object)worldEdit);
        this.worldEdit = worldEdit;
        this.callables = new ConcurrentHashMap();
    }

    @Deprecated
    public MethodCommands() {
        this(WorldEdit.getInstance());
    }

    public void register(Method method, CommandCallable callable, Dispatcher dispatcher) {
        this.dispatcher = dispatcher;
        this.callables.put(method, callable);
    }

    public CommandCallable getCallable() {
        try {
            StackTraceElement[] stack;
            for (StackTraceElement elem : stack = new Exception().getStackTrace()) {
                Class<?> clazz = Class.forName(elem.getClassName());
                for (Method method : clazz.getMethods()) {
                    Command command;
                    if (!method.getName().equals(elem.getMethodName()) || (command = method.getAnnotation(Command.class)) == null) continue;
                    return this.callables.get(method);
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return this.dispatcher;
    }

    public Command getCommand() {
        try {
            StackTraceElement[] stack;
            for (StackTraceElement elem : stack = new Exception().getStackTrace()) {
                Class<?> clazz = Class.forName(elem.getClassName());
                for (Method method : clazz.getMethods()) {
                    Command command;
                    if (!method.getName().equals(elem.getMethodName()) || (command = method.getAnnotation(Command.class)) == null) continue;
                    return Commands.translate(clazz, command);
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return null;
    }

    public String getArguments(CommandContext context) {
        if (context == null) {
            return null;
        }
        CommandLocals locals = context.getLocals();
        if (locals != null) {
            return (String)locals.get("arguments");
        }
        return null;
    }

    public String[] getPermissions() {
        try {
            StackTraceElement[] stack;
            for (StackTraceElement elem : stack = new Exception().getStackTrace()) {
                Class<?> clazz = Class.forName(elem.getClassName());
                for (Method method : clazz.getMethods()) {
                    CommandPermissions perm;
                    if (!method.getName().equals(elem.getMethodName()) || (perm = method.getAnnotation(CommandPermissions.class)) == null) continue;
                    return perm.value();
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return new String[0];
    }
}

