/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.command;

import com.boydti.fawe.config.BBC;
import com.boydti.fawe.util.StringMan;
import com.google.common.base.Joiner;
import com.sk89q.minecraft.util.commands.Command;
import com.sk89q.minecraft.util.commands.CommandContext;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.command.UtilityCommands;
import com.sk89q.worldedit.extension.platform.CommandManager;
import com.sk89q.worldedit.util.command.CommandCallable;
import com.sk89q.worldedit.util.command.CommandMapping;
import com.sk89q.worldedit.util.command.DelegateCallable;
import com.sk89q.worldedit.util.command.Dispatcher;
import com.sk89q.worldedit.util.command.PrimaryAliasComparator;
import com.sk89q.worldedit.util.command.parametric.AParametricCallable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public abstract class HelpBuilder
implements Runnable {
    private final CommandCallable callable;
    private final CommandContext args;
    private final String prefix;
    private final int perPage;

    public HelpBuilder(CommandCallable callable, CommandContext args, String prefix, int perPage) {
        if (callable == null) {
            callable = WorldEdit.getInstance().getPlatformManager().getCommandManager().getDispatcher();
        }
        this.callable = callable;
        this.args = args;
        this.prefix = prefix;
        this.perPage = perPage;
    }

    @Override
    public void run() {
        block35: {
            try {
                CommandCallable callable = this.callable;
                int page = -1;
                Object category = null;
                int effectiveLength = this.args.argsLength();
                try {
                    if (effectiveLength > 0) {
                        page = this.args.getInteger(this.args.argsLength() - 1);
                        page = page <= 0 ? 1 : --page;
                        --effectiveLength;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                boolean isRootLevel = true;
                ArrayList<String> visited = new ArrayList<String>();
                if (callable instanceof Dispatcher) {
                    Dispatcher dispatcher = (Dispatcher)callable;
                    ArrayList<CommandMapping> aliases = new ArrayList<CommandMapping>(dispatcher.getCommands());
                    List<String> prefixes = Collections.nCopies(aliases.size(), "");
                    if (page == -1 || effectiveLength > 0) {
                        TreeMap<String, Map<CommandMapping, String>> grouped = new TreeMap<String, Map<CommandMapping, String>>(String.CASE_INSENSITIVE_ORDER);
                        for (CommandMapping mapping : aliases) {
                            Command command;
                            CommandCallable c = mapping.getCallable();
                            if (c instanceof DelegateCallable) {
                                c = ((DelegateCallable)c).getParent();
                            }
                            String group = c instanceof AParametricCallable ? ((command = ((AParametricCallable)c).getCommand()) != null && command.aliases().length != 0 ? command.aliases()[0] : ((AParametricCallable)c).getGroup()) : (c instanceof Dispatcher ? mapping.getPrimaryAlias() : "Unsorted");
                            group = group.replace("/", "");
                            group = StringMan.toProperCase(group);
                            LinkedHashMap<CommandMapping, String> queue = (LinkedHashMap<CommandMapping, String>)grouped.get(group);
                            if (queue == null) {
                                queue = new LinkedHashMap<CommandMapping, String>();
                                grouped.put(group, queue);
                            }
                            if (c instanceof Dispatcher) {
                                for (CommandMapping m : ((Dispatcher)c).getCommands()) {
                                    queue.put(m, mapping.getPrimaryAlias() + " ");
                                }
                                continue;
                            }
                            queue.putIfAbsent(mapping, "");
                        }
                        if (effectiveLength > 0) {
                            Map mappings;
                            String cat = this.args.getString(0);
                            Map map = mappings = effectiveLength == 1 ? (Map)grouped.get(cat) : null;
                            if (mappings == null) {
                                for (int i = 0; i < effectiveLength; ++i) {
                                    String command = this.args.getString(i);
                                    if (callable instanceof Dispatcher) {
                                        CommandMapping mapping;
                                        if (isRootLevel && command.length() > 1 && command.charAt(0) == '/') {
                                            command = command.substring(1);
                                        }
                                        if ((mapping = UtilityCommands.detectCommand((Dispatcher)callable, command, isRootLevel)) == null) {
                                            if (isRootLevel) {
                                                HashSet<String> found = new HashSet<String>();
                                                String arg = this.args.getString(i).toLowerCase();
                                                String closest = null;
                                                int distance = Integer.MAX_VALUE;
                                                for (CommandMapping map2 : aliases) {
                                                    String desc = map2.getDescription().getDescription();
                                                    if (desc == null) {
                                                        desc = map2.getDescription().getHelp();
                                                    }
                                                    if (desc == null) {
                                                        desc = "";
                                                    }
                                                    String[] descSplit = desc.replaceAll("[^A-Za-z0-9]", "").toLowerCase().split(" ");
                                                    for (String alias : map2.getAllAliases()) {
                                                        if (alias.equals(arg)) {
                                                            closest = map2.getPrimaryAlias();
                                                            distance = 0;
                                                            found.add(map2.getPrimaryAlias());
                                                            continue;
                                                        }
                                                        if (alias.contains(arg)) {
                                                            closest = map2.getPrimaryAlias();
                                                            distance = 1;
                                                            found.add(map2.getPrimaryAlias());
                                                            continue;
                                                        }
                                                        if (StringMan.isEqualIgnoreCaseToAny(arg, descSplit)) {
                                                            closest = map2.getPrimaryAlias();
                                                            distance = 1;
                                                            found.add(map2.getPrimaryAlias());
                                                            continue;
                                                        }
                                                        int currentDist = StringMan.getLevenshteinDistance(alias, arg);
                                                        if (currentDist >= distance) continue;
                                                        distance = currentDist;
                                                        closest = map2.getPrimaryAlias();
                                                    }
                                                }
                                                found.add(closest);
                                                this.displayFailure(BBC.HELP_SUGGEST.f(arg, StringMan.join(found, ", ")));
                                                return;
                                            }
                                            String msg = String.format("The sub-command '%s' under '%s' could not be found.", command, Joiner.on((String)" ").join(visited));
                                            this.displayFailure(msg);
                                            return;
                                        }
                                        callable = mapping.getCallable();
                                    } else {
                                        String msg = String.format("'%s' has no sub-commands. (Maybe '%s' is for a parameter?)", Joiner.on((String)" ").join(visited), command);
                                        this.displayFailure(msg);
                                        return;
                                    }
                                    visited.add(this.args.getString(i));
                                    isRootLevel = false;
                                }
                                if (!(callable instanceof Dispatcher)) {
                                    String cmd = (WorldEdit.getInstance().getConfiguration().noDoubleSlash ? "" : "/") + Joiner.on((String)" ").join(visited);
                                    this.displayUsage(callable, cmd);
                                    return;
                                }
                                dispatcher = (Dispatcher)callable;
                                aliases = new ArrayList<CommandMapping>(dispatcher.getCommands());
                                prefixes = Collections.nCopies(aliases.size(), "");
                            } else {
                                aliases = new ArrayList();
                                prefixes = new ArrayList<String>();
                                for (Map.Entry entry : mappings.entrySet()) {
                                    aliases.add((CommandMapping)entry.getKey());
                                    prefixes.add((String)entry.getValue());
                                }
                            }
                            page = Math.max(0, page);
                        } else if (grouped.size() > 1) {
                            this.displayCategories(grouped);
                            return;
                        }
                    }
                    Collections.sort(aliases, new PrimaryAliasComparator(CommandManager.COMMAND_CLEAN_PATTERN));
                    int offset = this.perPage * Math.max(0, page);
                    int pageTotal = (int)Math.ceil((double)aliases.size() / (double)this.perPage);
                    if (offset >= aliases.size()) {
                        this.displayFailure(String.format("There is no page %d (total number of pages is %d).", page + 1, pageTotal));
                    } else {
                        int end = Math.min(offset + this.perPage, aliases.size());
                        List subAliases = aliases.subList(offset, end);
                        List<String> subPrefixes = prefixes.subList(offset, end);
                        LinkedHashMap<CommandMapping, String> commandMap = new LinkedHashMap<CommandMapping, String>();
                        for (int i = 0; i < subAliases.size(); ++i) {
                            commandMap.put((CommandMapping)subAliases.get(i), subPrefixes.get(i));
                        }
                        String visitedString = Joiner.on((String)" ").join(visited);
                        this.displayCommands(commandMap, visitedString, page, pageTotal, effectiveLength);
                    }
                    break block35;
                }
                String cmd = (WorldEdit.getInstance().getConfiguration().noDoubleSlash ? "" : "/") + Joiner.on((String)" ").join(visited);
                this.displayUsage(callable, cmd);
            }
            catch (Throwable e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }
    }

    public abstract void displayFailure(String var1);

    public abstract void displayUsage(CommandCallable var1, String var2);

    public abstract void displayCategories(Map<String, Map<CommandMapping, String>> var1);

    public abstract void displayCommands(Map<CommandMapping, String> var1, String var2, int var3, int var4, int var5);
}

