/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.wrappers;

import com.boydti.fawe.object.RunnableVal;
import com.boydti.fawe.util.TaskManager;
import com.sk89q.worldedit.BlockVector2D;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.MaxChangedBlocksException;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.Vector2D;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.blocks.BaseItem;
import com.sk89q.worldedit.blocks.BaseItemStack;
import com.sk89q.worldedit.entity.BaseEntity;
import com.sk89q.worldedit.entity.Entity;
import com.sk89q.worldedit.extension.platform.Platform;
import com.sk89q.worldedit.function.mask.Mask;
import com.sk89q.worldedit.function.operation.Operation;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.util.Direction;
import com.sk89q.worldedit.util.Location;
import com.sk89q.worldedit.util.TreeGenerator;
import com.sk89q.worldedit.world.AbstractWorld;
import com.sk89q.worldedit.world.World;
import com.sk89q.worldedit.world.biome.BaseBiome;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import com.sk89q.worldedit.world.block.BlockType;
import com.sk89q.worldedit.world.weather.WeatherType;
import java.util.List;
import javax.annotation.Nullable;

public class WorldWrapper
extends AbstractWorld {
    private final World parent;

    public static WorldWrapper wrap(World world) {
        if (world == null) {
            return null;
        }
        if (world instanceof WorldWrapper) {
            return (WorldWrapper)world;
        }
        return new WorldWrapper(world);
    }

    public static World unwrap(World world) {
        if (world instanceof WorldWrapper) {
            return WorldWrapper.unwrap(((WorldWrapper)world).getParent());
        }
        if (world instanceof EditSession) {
            return WorldWrapper.unwrap(((EditSession)world).getWorld());
        }
        return world;
    }

    private WorldWrapper(World parent) {
        this.parent = parent;
    }

    public World getParent() {
        return this.parent instanceof WorldWrapper ? ((WorldWrapper)this.parent).getParent() : this.parent;
    }

    @Override
    public boolean useItem(Vector position, BaseItem item, Direction face) {
        return this.parent.useItem(position, item, face);
    }

    @Override
    public boolean setBlock(Vector position, BlockStateHolder block, boolean notifyAndLight) throws WorldEditException {
        return this.parent.setBlock(position, block, notifyAndLight);
    }

    @Override
    public int getMaxY() {
        return this.parent.getMaxY();
    }

    @Override
    public Mask createLiquidMask() {
        return this.parent.createLiquidMask();
    }

    @Override
    public void dropItem(Vector pt, BaseItemStack item, int times) {
        this.parent.dropItem(pt, item, times);
    }

    @Override
    public void simulateBlockMine(final Vector pt) {
        TaskManager.IMP.sync(new RunnableVal<Object>(){

            @Override
            public void run(Object value) {
                WorldWrapper.this.parent.simulateBlockMine(pt);
            }
        });
    }

    @Override
    public boolean generateTree(TreeGenerator.TreeType type, EditSession editSession, Vector position) throws MaxChangedBlocksException {
        return TaskManager.IMP.sync(() -> {
            try {
                return this.parent.generateTree(type, editSession, position);
            }
            catch (MaxChangedBlocksException e) {
                throw new RuntimeException(e);
            }
        });
    }

    @Override
    public void checkLoadedChunk(Vector pt) {
        this.parent.checkLoadedChunk(pt);
    }

    @Override
    public void fixAfterFastMode(Iterable<BlockVector2D> chunks) {
        this.parent.fixAfterFastMode(chunks);
    }

    @Override
    public void fixLighting(Iterable<BlockVector2D> chunks) {
        this.parent.fixLighting(chunks);
    }

    @Override
    public boolean playEffect(Vector position, int type, int data) {
        return this.parent.playEffect(position, type, data);
    }

    @Override
    public boolean queueBlockBreakEffect(Platform server, Vector position, BlockType blockType, double priority) {
        return this.parent.queueBlockBreakEffect(server, position, blockType, priority);
    }

    @Override
    public WeatherType getWeather() {
        return null;
    }

    @Override
    public long getRemainingWeatherDuration() {
        return this.parent.getRemainingWeatherDuration();
    }

    @Override
    public void setWeather(WeatherType weatherType) {
        this.parent.setWeather(weatherType);
    }

    @Override
    public void setWeather(WeatherType weatherType, long duration) {
        this.parent.setWeather(weatherType, duration);
    }

    @Override
    public Vector getMinimumPoint() {
        return this.parent.getMinimumPoint();
    }

    @Override
    public Vector getMaximumPoint() {
        return this.parent.getMaximumPoint();
    }

    @Override
    @Nullable
    public Operation commit() {
        return this.parent.commit();
    }

    @Override
    public String getName() {
        return this.parent.getName();
    }

    @Override
    public int getBlockLightLevel(Vector position) {
        return this.parent.getBlockLightLevel(position);
    }

    @Override
    public boolean clearContainerBlockContents(Vector position) {
        return this.parent.clearContainerBlockContents(position);
    }

    @Override
    public void dropItem(Vector position, BaseItemStack item) {
        this.parent.dropItem(position, item);
    }

    @Override
    public boolean regenerate(Region region, EditSession session) {
        return session.regenerate(region);
    }

    @Override
    public boolean equals(Object other) {
        return this.parent.equals(other);
    }

    @Override
    public int hashCode() {
        return this.parent.hashCode();
    }

    @Override
    public List<? extends Entity> getEntities(final Region region) {
        return TaskManager.IMP.sync(new RunnableVal<List<? extends Entity>>(){

            @Override
            public void run(List<? extends Entity> value) {
                this.value = WorldWrapper.this.parent.getEntities(region);
            }
        });
    }

    @Override
    public List<? extends Entity> getEntities() {
        return TaskManager.IMP.sync(new RunnableVal<List<? extends Entity>>(){

            @Override
            public void run(List<? extends Entity> value) {
                this.value = WorldWrapper.this.parent.getEntities();
            }
        });
    }

    @Override
    @Nullable
    public Entity createEntity(Location location, BaseEntity entity) {
        return this.parent.createEntity(location, entity);
    }

    @Override
    public BlockState getBlock(Vector position) {
        return this.parent.getBlock(position);
    }

    @Override
    public BlockState getLazyBlock(Vector position) {
        return this.parent.getLazyBlock(position);
    }

    @Override
    public BlockState getFullBlock(Vector position) {
        return this.parent.getFullBlock(position);
    }

    @Override
    public BaseBiome getBiome(Vector2D position) {
        return this.parent.getBiome(position);
    }

    @Override
    public boolean setBiome(Vector2D position, BaseBiome biome) {
        return this.parent.setBiome(position, biome);
    }
}

