/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.util.metrics;

import com.boydti.fawe.Fawe;
import com.boydti.fawe.FaweVersion;
import com.boydti.fawe.configuration.file.YamlConfiguration;
import com.boydti.fawe.object.RunnableVal;
import com.boydti.fawe.object.io.PGZIPOutputStream;
import com.boydti.fawe.util.TaskManager;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.net.ssl.HttpsURLConnection;

public class BStats
implements Closeable {
    public static final int B_STATS_VERSION = 1;
    private final String url;
    private final String plugin;
    private final String platform;
    private final boolean online;
    private final String serverVersion;
    private final String pluginVersion;
    private Timer timer;
    private Gson gson;
    private volatile boolean enabled;
    private UUID serverUUID;
    private boolean logFailedRequests;
    private static Class<?> usedMetricsClass;
    private static final ConcurrentLinkedQueue<Object> knownMetricsInstances;

    public BStats() {
        this("FastAsyncWorldEdit", Fawe.get().getVersion(), Fawe.imp().getPlatformVersion(), Fawe.imp().getPlatform(), Fawe.imp().isOnlineMode());
    }

    public int getPlayerCount() {
        return Fawe.imp() == null ? 1 : Fawe.imp().getPlayerCount();
    }

    private BStats(String plugin, FaweVersion faweVersion, String serverVersion, String platform, boolean online) {
        block15: {
            YamlConfiguration config;
            this.gson = new Gson();
            this.logFailedRequests = false;
            this.url = "https://bStats.org/submitData/" + platform;
            this.plugin = plugin;
            this.pluginVersion = "" + faweVersion;
            this.serverVersion = serverVersion;
            this.platform = platform;
            this.online = online;
            File configFile = new File(this.getJarFile().getParentFile(), "bStats" + File.separator + "config.yml");
            if (!configFile.exists()) {
                configFile.getParentFile().mkdirs();
                try {
                    configFile.createNewFile();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if ((config = YamlConfiguration.loadConfiguration(configFile)).isSet("serverUuid")) {
                try {
                    this.serverUUID = UUID.fromString(config.getString("serverUuid"));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            if (this.serverUUID == null) {
                config.addDefault("enabled", true);
                this.serverUUID = UUID.randomUUID();
                config.addDefault("serverUuid", this.serverUUID.toString());
                config.addDefault("logFailedRequests", false);
                config.options().header("bStats collects some data for plugin authors like how many servers are using their plugins.\nTo honor their work, you should not disable it.\nThis has nearly no effect on the server performance!\nCheck out https://bStats.org/ to learn more :)").copyDefaults(true);
                try {
                    config.save(configFile);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (usedMetricsClass != null) {
                BStats.linkMetrics(this);
                return;
            }
            usedMetricsClass = this.getFirstBStatsClass();
            if (usedMetricsClass == null) {
                return;
            }
            if (usedMetricsClass == this.getClass()) {
                BStats.linkMetrics(this);
                this.enabled = true;
            } else {
                try {
                    usedMetricsClass.getMethod("linkMetrics", Object.class).invoke(null, this);
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                    if (!this.logFailedRequests) break block15;
                    System.out.println("Failed to link to first metrics class " + usedMetricsClass.getName() + "!");
                }
            }
        }
    }

    public void start() {
        if (this.enabled) {
            this.startSubmitting();
        }
    }

    public static void linkMetrics(Object metrics) {
        if (!knownMetricsInstances.contains(metrics)) {
            knownMetricsInstances.add(metrics);
        }
    }

    public JsonObject getPluginData() {
        JsonObject data = new JsonObject();
        data.addProperty("pluginName", this.plugin);
        data.addProperty("pluginVersion", this.pluginVersion);
        JsonArray customCharts = new JsonArray();
        data.add("customCharts", (JsonElement)customCharts);
        return data;
    }

    private void startSubmitting() {
        this.timer = new Timer(true);
        this.timer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                if (!BStats.this.enabled) {
                    BStats.this.timer.cancel();
                    return;
                }
                BStats.this.submitData();
            }
        }, 0L, 1800000L);
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    @Override
    public void close() {
        this.enabled = false;
        if (this.timer != null) {
            this.timer.cancel();
        }
    }

    private JsonObject getServerData() {
        int playerAmount = this.getPlayerCount();
        int onlineMode = this.online ? 1 : 0;
        int managedServers = 1;
        String javaVersion = System.getProperty("java.version");
        String osName = System.getProperty("os.name");
        String osArch = System.getProperty("os.arch");
        String osVersion = System.getProperty("os.version");
        int coreCount = Runtime.getRuntime().availableProcessors();
        JsonObject data = new JsonObject();
        data.addProperty("serverUUID", this.serverUUID.toString());
        data.addProperty("playerAmount", (Number)playerAmount);
        data.addProperty("managedServers", (Number)managedServers);
        data.addProperty("onlineMode", (Number)onlineMode);
        data.addProperty(this.platform + "Version", this.serverVersion);
        data.addProperty("javaVersion", javaVersion);
        data.addProperty("osName", osName);
        data.addProperty("osArch", osArch);
        data.addProperty("osVersion", osVersion);
        data.addProperty("coreCount", (Number)coreCount);
        return data;
    }

    private void submitData() {
        block4: {
            JsonObject data = this.getServerData();
            JsonArray pluginData = new JsonArray();
            for (final Object metrics : knownMetricsInstances) {
                Object plugin = TaskManager.IMP.sync(new RunnableVal<Object>(){

                    @Override
                    public void run(Object value) {
                        try {
                            this.value = metrics.getClass().getMethod("getPluginData", new Class[0]).invoke(metrics, new Object[0]);
                        }
                        catch (JsonSyntaxException | IllegalAccessException | NoSuchMethodException | NullPointerException | InvocationTargetException throwable) {
                            // empty catch block
                        }
                    }
                });
                if (plugin == null) continue;
                if (plugin instanceof JsonObject) {
                    pluginData.add((JsonElement)((JsonObject)plugin));
                    continue;
                }
                pluginData.add((JsonElement)this.gson.fromJson(plugin.toString(), JsonObject.class));
            }
            data.add("plugins", (JsonElement)pluginData);
            try {
                this.sendData(data);
            }
            catch (Exception e) {
                if (!this.logFailedRequests) break block4;
                System.err.println("Could not submit plugin stats!");
            }
        }
    }

    private Class<?> getFirstBStatsClass() {
        Path configPath = this.getJarFile().toPath().getParent().resolve("bStats");
        configPath.toFile().mkdirs();
        File tempFile = new File(configPath.toFile(), "temp.txt");
        try {
            String className = this.readFile(tempFile);
            if (className != null) {
                try {
                    return Class.forName(className);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            this.writeFile(tempFile, this.getClass().getName());
            return this.getClass();
        }
        catch (IOException e) {
            if (this.logFailedRequests) {
                System.err.println("Failed to get first bStats class!");
            }
            return null;
        }
    }

    private File getJarFile() {
        try {
            URL url = BStats.class.getProtectionDomain().getCodeSource().getLocation();
            return new File(new URL(url.toURI().toString().split("\\!")[0].replaceAll("jar:file", "file")).toURI().getPath());
        }
        catch (SecurityException | MalformedURLException | URISyntaxException e) {
            return new File(".", "plugins");
        }
    }

    /*
     * Exception decompiling
     */
    private String readFile(File file) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void writeFile(File file, String ... lines) throws IOException {
        if (!file.exists()) {
            file.createNewFile();
        }
        try (FileWriter fileWriter = new FileWriter(file);
             BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);){
            for (String line : lines) {
                bufferedWriter.write(line);
                bufferedWriter.newLine();
            }
        }
    }

    private void sendData(JsonObject data) throws Exception {
        if (data == null) {
            throw new IllegalArgumentException("Data cannot be null");
        }
        HttpsURLConnection connection = (HttpsURLConnection)new URL(this.url).openConnection();
        byte[] compressedData = this.compress(data.toString());
        connection.setRequestMethod("POST");
        connection.addRequestProperty("Accept", "application/json");
        connection.addRequestProperty("Connection", "close");
        connection.addRequestProperty("Content-Encoding", "gzip");
        connection.addRequestProperty("Content-Length", String.valueOf(compressedData.length));
        connection.setRequestProperty("Content-Type", "application/json");
        connection.setRequestProperty("User-Agent", "MC-Server/1");
        connection.setDoOutput(true);
        DataOutputStream outputStream = new DataOutputStream(connection.getOutputStream());
        outputStream.write(compressedData);
        outputStream.flush();
        outputStream.close();
        connection.getInputStream().close();
    }

    private byte[] compress(String str) throws IOException {
        if (str == null) {
            return null;
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        PGZIPOutputStream gzip = new PGZIPOutputStream(outputStream);
        gzip.write(str.getBytes("UTF-8"));
        gzip.close();
        return outputStream.toByteArray();
    }

    static {
        knownMetricsInstances = new ConcurrentLinkedQueue();
    }
}

