/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.util;

import com.boydti.fawe.Fawe;
import com.boydti.fawe.config.Settings;
import com.boydti.fawe.object.FaweQueue;
import com.boydti.fawe.util.MainUtil;
import com.boydti.fawe.util.MemUtil;
import com.boydti.fawe.util.TaskManager;
import com.boydti.fawe.wrappers.WorldWrapper;
import com.sk89q.worldedit.world.World;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.TimeUnit;

public class SetQueue {
    public static final SetQueue IMP = new SetQueue();
    private double targetTPS = 18.0;
    private final ConcurrentLinkedDeque<FaweQueue> activeQueues;
    private final ConcurrentLinkedDeque<FaweQueue> inactiveQueues;
    private final ConcurrentLinkedDeque<Runnable> tasks;
    private long last;
    private long allocate = 50L;
    private long lastSuccess;
    private final ConcurrentLinkedDeque<Runnable> emptyTasks = new ConcurrentLinkedDeque();
    private ForkJoinPool pool = new ForkJoinPool();
    private ExecutorCompletionService completer = new ExecutorCompletionService(this.pool);

    @Deprecated
    public ExecutorCompletionService getCompleterService() {
        return this.completer;
    }

    @Deprecated
    public ForkJoinPool getForkJoinPool() {
        return this.pool;
    }

    public void runMiscTasks() {
        Runnable task;
        while (Fawe.get().getTimer().isAbove(this.targetTPS) && (task = this.tasks.poll()) != null) {
            task.run();
        }
    }

    public SetQueue() {
        this.tasks = new ConcurrentLinkedDeque();
        this.activeQueues = new ConcurrentLinkedDeque();
        this.inactiveQueues = new ConcurrentLinkedDeque();
        if (TaskManager.IMP == null) {
            return;
        }
        TaskManager.IMP.repeat(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    int mem;
                    long now = System.currentTimeMillis();
                    boolean empty = SetQueue.this.inactiveQueues.isEmpty() && SetQueue.this.activeQueues.isEmpty();
                    boolean emptyTasks = SetQueue.this.tasks.isEmpty();
                    if (emptyTasks && empty) {
                        SetQueue.this.last = now;
                        SetQueue.this.runEmptyTasks();
                        return;
                    }
                    SetQueue.this.targetTPS = 18.0 - Math.max((double)Settings.IMP.QUEUE.EXTRA_TIME_MS * 0.05, 0.0);
                    long diff = 50L + SetQueue.this.last - (SetQueue.this.last = now);
                    long absDiff = Math.abs(diff);
                    if (diff == 0L) {
                        SetQueue.this.allocate = Math.min(50L, SetQueue.this.allocate + 1L);
                    } else if (diff < 0L) {
                        SetQueue.this.allocate = Math.max(5L, SetQueue.this.allocate + diff);
                    } else if (!Fawe.get().getTimer().isAbove(SetQueue.this.targetTPS)) {
                        SetQueue.this.allocate = Math.max(5L, SetQueue.this.allocate - 1L);
                    }
                    long currentAllocate = SetQueue.this.allocate - absDiff;
                    if (!emptyTasks) {
                        long taskAllocate = SetQueue.this.activeQueues.isEmpty() ? currentAllocate : 1L + (currentAllocate >> 1);
                        long used = 0L;
                        boolean wait = false;
                        do {
                            Runnable task;
                            if ((task = (Runnable)SetQueue.this.tasks.poll()) == null) {
                                if (!wait) break;
                                ConcurrentLinkedDeque concurrentLinkedDeque = SetQueue.this.tasks;
                                synchronized (concurrentLinkedDeque) {
                                    SetQueue.this.tasks.wait(1L);
                                }
                                task = (Runnable)SetQueue.this.tasks.poll();
                                wait = false;
                            }
                            if (task == null) continue;
                            task.run();
                            wait = true;
                        } while ((used = System.currentTimeMillis() - now) < taskAllocate);
                        currentAllocate -= used;
                    }
                    if (empty) {
                        SetQueue.this.runEmptyTasks();
                        return;
                    }
                    if (!MemUtil.isMemoryFree() && (mem = MemUtil.calculateMemory()) != Integer.MAX_VALUE) {
                        SetQueue.this.allocate = Math.max(5L, SetQueue.this.allocate - 1L);
                        if (mem <= 1 && Settings.IMP.PREVENT_CRASHES) {
                            for (FaweQueue queue : SetQueue.this.getAllQueues()) {
                                queue.saveMemory();
                            }
                            return;
                        }
                        if (SetQueue.this.forceChunkSet()) {
                            System.gc();
                        } else {
                            SetQueue.this.runEmptyTasks();
                        }
                        return;
                    }
                    FaweQueue queue = SetQueue.this.getNextQueue();
                    if (queue == null) {
                        return;
                    }
                    long time = (long)Settings.IMP.QUEUE.EXTRA_TIME_MS + currentAllocate - System.currentTimeMillis() + now;
                    boolean parallel = Settings.IMP.QUEUE.PARALLEL_THREADS > 1;
                    queue.startSet(parallel);
                    try {
                        if (!queue.next(Settings.IMP.QUEUE.PARALLEL_THREADS, time) && queue.getStage() == QueueStage.ACTIVE) {
                            queue.setStage(QueueStage.NONE);
                            queue.runTasks();
                        }
                    }
                    catch (Throwable e) {
                        SetQueue.this.pool.awaitQuiescence(Settings.IMP.QUEUE.DISCARD_AFTER_MS, TimeUnit.MILLISECONDS);
                        SetQueue.this.completer = new ExecutorCompletionService(SetQueue.this.pool);
                        e.printStackTrace();
                    }
                    if (SetQueue.this.pool.getQueuedSubmissionCount() != 0 || SetQueue.this.pool.getRunningThreadCount() != 0 || SetQueue.this.pool.getQueuedTaskCount() != 0L) {
                        SetQueue.this.pool.awaitQuiescence(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
                    }
                    queue.endSet(parallel);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        }, 1);
    }

    public QueueStage getStage(FaweQueue queue) {
        return queue.getStage();
    }

    public boolean isStage(FaweQueue queue, QueueStage stage) {
        switch (stage) {
            case ACTIVE: {
                return this.activeQueues.contains(queue);
            }
            case INACTIVE: {
                return this.inactiveQueues.contains(queue);
            }
            case NONE: {
                return !this.activeQueues.contains(queue) && !this.inactiveQueues.contains(queue);
            }
        }
        return false;
    }

    public boolean enqueue(FaweQueue queue) {
        queue.setStage(QueueStage.ACTIVE);
        this.inactiveQueues.remove(queue);
        if (queue.size() > 0) {
            if (!this.activeQueues.contains(queue)) {
                queue.optimize();
                this.activeQueues.add(queue);
            }
            return true;
        }
        return false;
    }

    public void dequeue(FaweQueue queue) {
        queue.setStage(QueueStage.NONE);
        this.inactiveQueues.remove(queue);
        this.activeQueues.remove(queue);
        queue.runTasks();
    }

    public Collection<FaweQueue> getAllQueues() {
        ArrayList<FaweQueue> list = new ArrayList<FaweQueue>(this.activeQueues.size() + this.inactiveQueues.size());
        list.addAll(this.inactiveQueues);
        list.addAll(this.activeQueues);
        return list;
    }

    public Collection<FaweQueue> getActiveQueues() {
        return Collections.unmodifiableCollection(this.activeQueues);
    }

    public Collection<FaweQueue> getInactiveQueues() {
        return Collections.unmodifiableCollection(this.inactiveQueues);
    }

    public FaweQueue getNewQueue(World world, boolean fast, boolean autoqueue) {
        if ((world = WorldWrapper.unwrap(world)) instanceof FaweQueue) {
            return (FaweQueue)((Object)world);
        }
        FaweQueue queue = Fawe.imp().getNewQueue(world, fast);
        if (autoqueue) {
            queue.setStage(QueueStage.INACTIVE);
            this.inactiveQueues.add(queue);
        }
        return queue;
    }

    public FaweQueue getNewQueue(String world, boolean fast, boolean autoqueue) {
        FaweQueue queue = Fawe.imp().getNewQueue(world, fast);
        if (autoqueue) {
            queue.setStage(QueueStage.INACTIVE);
            this.inactiveQueues.add(queue);
        }
        return queue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush(FaweQueue queue) {
        int parallelThreads;
        Fawe.get();
        if (Fawe.isMainThread()) {
            parallelThreads = Settings.IMP.QUEUE.PARALLEL_THREADS;
            Settings.IMP.QUEUE.PARALLEL_THREADS = 1;
        } else {
            parallelThreads = 0;
        }
        try {
            queue.startSet(Settings.IMP.QUEUE.PARALLEL_THREADS > 1);
            queue.next(Settings.IMP.QUEUE.PARALLEL_THREADS, Long.MAX_VALUE);
            queue.endSet(Settings.IMP.QUEUE.PARALLEL_THREADS > 1);
            queue.setStage(QueueStage.NONE);
            queue.runTasks();
            if (parallelThreads != 0) {
                Settings.IMP.QUEUE.PARALLEL_THREADS = parallelThreads;
            }
        }
        catch (Throwable e) {
            try {
                this.pool.awaitQuiescence(Settings.IMP.QUEUE.DISCARD_AFTER_MS, TimeUnit.MILLISECONDS);
                this.completer = new ExecutorCompletionService(this.pool);
                MainUtil.handleError(e);
                queue.endSet(Settings.IMP.QUEUE.PARALLEL_THREADS > 1);
                queue.setStage(QueueStage.NONE);
                queue.runTasks();
                if (parallelThreads != 0) {
                    Settings.IMP.QUEUE.PARALLEL_THREADS = parallelThreads;
                }
            }
            catch (Throwable throwable) {
                queue.endSet(Settings.IMP.QUEUE.PARALLEL_THREADS > 1);
                queue.setStage(QueueStage.NONE);
                queue.runTasks();
                if (parallelThreads != 0) {
                    Settings.IMP.QUEUE.PARALLEL_THREADS = parallelThreads;
                }
                throw throwable;
            }
        }
    }

    public FaweQueue getNextQueue() {
        long now = System.currentTimeMillis();
        while (!this.activeQueues.isEmpty()) {
            FaweQueue queue = this.activeQueues.peek();
            if (queue != null && queue.size() > 0) {
                queue.setModified(now);
                return queue;
            }
            queue.setStage(QueueStage.NONE);
            queue.runTasks();
            this.activeQueues.poll();
        }
        int size = this.inactiveQueues.size();
        if (size > 0) {
            Iterator<FaweQueue> iter = this.inactiveQueues.iterator();
            try {
                int total = 0;
                FaweQueue firstNonEmpty = null;
                while (iter.hasNext()) {
                    FaweQueue queue = iter.next();
                    long age = now - queue.getModified();
                    total += queue.size();
                    if (queue.size() == 0) {
                        if (age <= (long)Settings.IMP.QUEUE.DISCARD_AFTER_MS) continue;
                        queue.setStage(QueueStage.NONE);
                        queue.runTasks();
                        iter.remove();
                        continue;
                    }
                    if (firstNonEmpty == null) {
                        firstNonEmpty = queue;
                    }
                    if (total > Settings.IMP.QUEUE.TARGET_SIZE) {
                        firstNonEmpty.setModified(now);
                        return firstNonEmpty;
                    }
                    if (age <= (long)Settings.IMP.QUEUE.MAX_WAIT_MS) continue;
                    queue.setModified(now);
                    return queue;
                }
            }
            catch (ConcurrentModificationException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public boolean next() {
        while (this.activeQueues.size() > 0) {
            FaweQueue queue = this.activeQueues.poll();
            if (queue == null) continue;
            boolean set = queue.next();
            if (set) {
                this.activeQueues.add(queue);
                return set;
            }
            queue.setStage(QueueStage.NONE);
            queue.runTasks();
        }
        if (this.inactiveQueues.size() > 0) {
            ArrayList<FaweQueue> tmp = new ArrayList<FaweQueue>(this.inactiveQueues);
            if (Settings.IMP.QUEUE.MAX_WAIT_MS != -1) {
                long diff;
                long now = System.currentTimeMillis();
                if (this.lastSuccess == 0L) {
                    this.lastSuccess = now;
                }
                if ((diff = now - this.lastSuccess) > (long)Settings.IMP.QUEUE.MAX_WAIT_MS) {
                    for (FaweQueue queue : tmp) {
                        boolean result = queue.next();
                        if (!result) continue;
                        return result;
                    }
                    if (diff > (long)Settings.IMP.QUEUE.DISCARD_AFTER_MS) {
                        for (FaweQueue queue : tmp) {
                            queue.setStage(QueueStage.NONE);
                            queue.runTasks();
                        }
                        this.inactiveQueues.clear();
                    }
                    return false;
                }
            }
            if (Settings.IMP.QUEUE.TARGET_SIZE != -1) {
                int total = 0;
                for (FaweQueue queue : tmp) {
                    total += queue.size();
                }
                if (total > Settings.IMP.QUEUE.TARGET_SIZE) {
                    for (FaweQueue queue : tmp) {
                        boolean result = queue.next();
                        if (!result) continue;
                        return result;
                    }
                }
            }
        }
        return false;
    }

    public boolean forceChunkSet() {
        return this.next();
    }

    public boolean isEmpty() {
        return this.activeQueues.size() == 0 && this.inactiveQueues.size() == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTask(Runnable whenFree) {
        this.tasks.add(whenFree);
        ConcurrentLinkedDeque<Runnable> concurrentLinkedDeque = this.tasks;
        synchronized (concurrentLinkedDeque) {
            this.tasks.notifyAll();
        }
    }

    public boolean addEmptyTask(Runnable whenDone) {
        if (this.isEmpty()) {
            this.runEmptyTasks();
            if (whenDone != null) {
                whenDone.run();
            }
            return true;
        }
        if (whenDone != null) {
            this.emptyTasks.add(whenDone);
        }
        return false;
    }

    private synchronized boolean runEmptyTasks() {
        if (this.emptyTasks.isEmpty()) {
            return false;
        }
        ConcurrentLinkedDeque<Runnable> tmp = new ConcurrentLinkedDeque<Runnable>(this.emptyTasks);
        this.emptyTasks.clear();
        for (Runnable runnable : tmp) {
            runnable.run();
        }
        return true;
    }

    public static enum QueueStage {
        INACTIVE,
        ACTIVE,
        NONE;

    }
}

