/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.object.io;

import java.io.File;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;

public class RandomFileOutputStream
extends OutputStream {
    protected RandomAccessFile randomFile;
    protected boolean sync;
    protected boolean closeParent;

    public RandomFileOutputStream(String fnm) throws IOException {
        this(fnm, false);
    }

    public RandomFileOutputStream(String fnm, boolean syn) throws IOException {
        this(new File(fnm), syn);
    }

    public RandomFileOutputStream(File fil) throws IOException {
        this(fil, false);
    }

    public RandomFileOutputStream(File fil, boolean syn) throws IOException {
        fil = fil.getAbsoluteFile();
        File par = fil.getParentFile();
        if (par != null) {
            par.mkdirs();
        }
        this.randomFile = new RandomAccessFile(fil, "rw");
        this.sync = syn;
        this.closeParent = true;
    }

    public RandomFileOutputStream(RandomAccessFile randomFile, boolean syn, boolean closeParent) {
        this.randomFile = randomFile;
        this.sync = syn;
        this.closeParent = closeParent;
    }

    @Override
    public void write(int val) throws IOException {
        this.randomFile.write(val);
        if (this.sync) {
            this.randomFile.getFD().sync();
        }
    }

    @Override
    public void write(byte[] val) throws IOException {
        this.randomFile.write(val);
        if (this.sync) {
            this.randomFile.getFD().sync();
        }
    }

    @Override
    public void write(byte[] val, int off, int len) throws IOException {
        this.randomFile.write(val, off, len);
        if (this.sync) {
            this.randomFile.getFD().sync();
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.sync) {
            this.randomFile.getFD().sync();
        }
    }

    @Override
    public void close() throws IOException {
        if (this.closeParent) {
            this.randomFile.close();
        }
    }

    public long getFilePointer() throws IOException {
        return this.randomFile.getFilePointer();
    }

    public void setFilePointer(long pos) throws IOException {
        this.randomFile.seek(pos);
    }

    public long getFileSize() throws IOException {
        return this.randomFile.length();
    }

    public void setFileSize(long len) throws IOException {
        this.randomFile.setLength(len);
    }

    public FileDescriptor getFD() throws IOException {
        return this.randomFile.getFD();
    }
}

