/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.object.extent;

import com.boydti.fawe.object.extent.ResettableExtent;
import com.sk89q.worldedit.MutableBlockVector;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.Vector2D;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.entity.BaseEntity;
import com.sk89q.worldedit.entity.Entity;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.util.Location;
import com.sk89q.worldedit.world.biome.BaseBiome;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import javax.annotation.Nullable;

public class ScaleTransform
extends ResettableExtent {
    private transient MutableBlockVector mutable = new MutableBlockVector();
    private transient int maxy;
    private transient Vector min;
    private final double dx;
    private final double dy;
    private final double dz;

    public ScaleTransform(Extent parent, double dx, double dy, double dz) {
        super(parent);
        this.dx = dx;
        this.dy = dy;
        this.dz = dz;
        this.maxy = parent.getMaximumPoint().getBlockY();
    }

    @Override
    public ResettableExtent setExtent(Extent extent) {
        this.min = null;
        this.maxy = extent.getMaximumPoint().getBlockY();
        this.mutable = new MutableBlockVector();
        return super.setExtent(extent);
    }

    private Vector getPos(Vector pos) {
        if (this.min == null) {
            this.min = new Vector(pos);
        }
        this.mutable.mutX(this.min.getX() + (pos.getX() - this.min.getX()) * this.dx);
        this.mutable.mutY(this.min.getY() + (pos.getY() - this.min.getY()) * this.dy);
        this.mutable.mutZ(this.min.getZ() + (pos.getZ() - this.min.getZ()) * this.dz);
        return this.mutable;
    }

    private Vector getPos(int x, int y, int z) {
        if (this.min == null) {
            this.min = new Vector(x, y, z);
        }
        this.mutable.mutX(this.min.getX() + ((double)x - this.min.getX()) * this.dx);
        this.mutable.mutY(this.min.getY() + ((double)y - this.min.getY()) * this.dy);
        this.mutable.mutZ(this.min.getZ() + ((double)z - this.min.getZ()) * this.dz);
        return this.mutable;
    }

    @Override
    public boolean setBlock(Vector location, BlockStateHolder block) throws WorldEditException {
        boolean result = false;
        Vector pos = this.getPos(location);
        double sx = pos.getX();
        double sy = pos.getY();
        double sz = pos.getZ();
        double ex = sx + this.dx;
        double ey = Math.min((double)this.maxy, sy + this.dy);
        double ez = sz + this.dz;
        pos.mutY(sy);
        while (pos.getY() < ey) {
            pos.mutZ(sz);
            while (pos.getZ() < ez) {
                pos.mutX(sx);
                while (pos.getX() < ex) {
                    result |= super.setBlock(pos, block);
                    pos.mutX(pos.getX() + 1.0);
                }
                pos.mutZ(pos.getZ() + 1.0);
            }
            pos.mutY(pos.getY() + 1.0);
        }
        return result;
    }

    @Override
    public boolean setBiome(Vector2D position, BaseBiome biome) {
        boolean result = false;
        Vector pos = this.getPos(position.getBlockX(), 0, position.getBlockZ());
        double sx = pos.getX();
        double sz = pos.getZ();
        double ex = pos.getX() + this.dx;
        double ez = pos.getZ() + this.dz;
        pos.mutZ(sz);
        while (pos.getZ() < ez) {
            pos.mutX(sx);
            while (pos.getX() < ex) {
                result |= super.setBiome(pos.toVector2D(), biome);
                pos.mutX(pos.getX() + 1.0);
            }
            pos.mutZ(pos.getZ() + 1.0);
        }
        return result;
    }

    @Override
    public boolean setBlock(int x1, int y1, int z1, BlockStateHolder block) throws WorldEditException {
        boolean result = false;
        Vector pos = this.getPos(x1, y1, z1);
        double sx = pos.getX();
        double sy = pos.getY();
        double sz = pos.getZ();
        double ex = pos.getX() + this.dx;
        double ey = Math.min((double)this.maxy, sy + this.dy);
        double ez = pos.getZ() + this.dz;
        pos.mutY(sy);
        while (pos.getY() < ey) {
            pos.mutZ(sz);
            while (pos.getZ() < ez) {
                pos.mutX(sx);
                while (pos.getX() < ex) {
                    result |= super.setBlock(pos, block);
                    pos.mutX(pos.getX() + 1.0);
                }
                pos.mutZ(pos.getZ() + 1.0);
            }
            pos.mutY(pos.getY() + 1.0);
        }
        return result;
    }

    @Override
    @Nullable
    public Entity createEntity(Location location, BaseEntity entity) {
        Location newLoc = new Location(location.getExtent(), this.getPos(location.getBlockX(), location.getBlockY(), location.getBlockZ()), location.getYaw(), location.getPitch());
        return super.createEntity(newLoc, entity);
    }
}

