/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.object.extent;

import com.sk89q.worldedit.MutableBlockVector;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.Vector2D;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.extent.AbstractDelegateExtent;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.world.biome.BaseBiome;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockStateHolder;

public class BlockTranslateExtent
extends AbstractDelegateExtent {
    private final int dx;
    private final int dy;
    private final int dz;
    private MutableBlockVector mutable = new MutableBlockVector();

    public BlockTranslateExtent(Extent extent, int dx, int dy, int dz) {
        super(extent);
        this.dx = dx;
        this.dy = dy;
        this.dz = dz;
    }

    @Override
    public boolean setBlock(Vector location, BlockStateHolder block) throws WorldEditException {
        this.mutable.mutX(location.getX() + (double)this.dx);
        this.mutable.mutY(location.getY() + (double)this.dy);
        this.mutable.mutZ(location.getZ() + (double)this.dz);
        return this.getExtent().setBlock(this.mutable, block);
    }

    @Override
    public boolean setBlock(int x, int y, int z, BlockStateHolder block) throws WorldEditException {
        this.mutable.mutX(x + this.dx);
        this.mutable.mutY(y + this.dy);
        this.mutable.mutZ(z + this.dz);
        return this.getExtent().setBlock(this.mutable, block);
    }

    @Override
    public boolean setBiome(Vector2D position, BaseBiome biome) {
        return super.setBiome(position.add(this.dx, this.dz), biome);
    }

    @Override
    public boolean setBiome(int x, int y, int z, BaseBiome biome) {
        return super.setBiome(x + this.dx, y + this.dy, z + this.dz, biome);
    }

    @Override
    public BaseBiome getBiome(Vector2D position) {
        return super.getBiome(position.add(this.dx, this.dz));
    }

    @Override
    public BlockState getBlock(Vector location) {
        return this.getLazyBlock(location.getBlockX(), location.getBlockY(), location.getBlockZ());
    }

    @Override
    public BlockState getLazyBlock(Vector location) {
        return this.getLazyBlock(location.getBlockX(), location.getBlockY(), location.getBlockZ());
    }

    @Override
    public BlockState getLazyBlock(int x, int y, int z) {
        return super.getLazyBlock(x + this.dx, y + this.dy, z + this.dz);
    }
}

