/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.object.collection;

import com.boydti.fawe.object.FaweInputStream;
import com.boydti.fawe.object.FaweOutputStream;
import com.boydti.fawe.object.collection.DifferentialCollection;
import java.io.IOException;
import java.lang.reflect.Array;

public final class DifferentialBlockBuffer
implements DifferentialCollection<int[][][][][]> {
    private final int width;
    private final int length;
    private final int t1;
    private final int t2;
    private int[][][][][] data;
    private int[][][][][] changes;

    public DifferentialBlockBuffer(int width, int length) {
        this.width = width;
        this.length = length;
        this.t1 = length + 15 >> 4;
        this.t2 = width + 15 >> 4;
    }

    @Override
    public int[][][][][] get() {
        return this.data;
    }

    @Override
    public void flushChanges(FaweOutputStream out) throws IOException {
        boolean modified = this.isModified();
        out.writeBoolean(modified);
        if (modified) {
            this.writeArray(this.changes, 0, 0, out);
        }
        this.clearChanges();
    }

    private void writeArray(Object arr, int level, int index, FaweOutputStream out) throws IOException {
        if (level == 4) {
            if (arr != null) {
                int[] level4 = (int[])arr;
                out.writeVarInt(level4.length);
                for (int c : level4) {
                    out.writeVarInt(c);
                }
            } else {
                out.writeVarInt(0);
            }
        } else {
            int len = arr == null ? 0 : Array.getLength(arr);
            out.writeVarInt(len);
            for (int i = 0; i < len; ++i) {
                Object elem = Array.get(arr, i);
                this.writeArray(elem, level + 1, i, out);
            }
        }
    }

    @Override
    public void undoChanges(FaweInputStream in) throws IOException {
        if (this.changes != null && this.changes.length != 0) {
            throw new IllegalStateException("There are uncommitted changes, please flush first");
        }
        boolean modified = in.readBoolean();
        if (modified) {
            int len = in.readVarInt();
            if (len == 0) {
                this.data = null;
            } else {
                for (int i = 0; i < len; ++i) {
                    this.readArray(this.data, i, 1, in);
                }
            }
        }
        this.clearChanges();
    }

    @Override
    public void redoChanges(FaweInputStream in) throws IOException {
        this.clearChanges();
        throw new UnsupportedOperationException("Not implemented");
    }

    private void readArray(Object dataElem, int index, int level, FaweInputStream in) throws IOException {
        int len = in.readVarInt();
        if (level == 4) {
            int[][] castedElem = (int[][])dataElem;
            if (len == 0) {
                castedElem[index] = null;
            } else {
                int[] current = castedElem[index];
                for (int i = 0; i < len; ++i) {
                    current[i] = in.readVarInt();
                }
            }
        } else if (len == 0) {
            Array.set(dataElem, index, null);
        } else {
            Object nextElem = Array.get(dataElem, index);
            for (int i = 0; i < len; ++i) {
                this.readArray(nextElem, i, level + 1, in);
            }
        }
    }

    public boolean isModified() {
        return this.changes != null;
    }

    public void clearChanges() {
        this.changes = null;
    }

    public void set(int x, int y, int z, int combined) {
        int[] zMap;
        Object yMap;
        Object arr2;
        Object arr;
        if (combined == 0) {
            combined = 1;
        }
        int localX = x & 0xF;
        int localZ = z & 0xF;
        int chunkX = x >> 4;
        int chunkZ = z >> 4;
        if (this.data == null) {
            this.data = new int[this.t1][][][][];
            this.changes = new int[0][][][][];
        }
        if ((arr = this.data[chunkZ]) == null) {
            int[][][][] nArrayArray = new int[this.t2][][][];
            this.data[chunkZ] = nArrayArray;
            arr = nArrayArray;
        }
        if ((arr2 = arr[chunkX]) == null) {
            int[][][] nArrayArray = new int[256][][];
            arr[chunkX] = nArrayArray;
            arr2 = nArrayArray;
        }
        if ((yMap = arr2[y]) == null) {
            int[][] nArrayArray = new int[16][];
            yMap = nArrayArray;
            arr2[y] = nArrayArray;
        }
        if ((zMap = yMap[localZ]) == null) {
            zMap = new int[16];
            yMap[localZ] = zMap;
            if (this.changes == null) {
                this.changes = new int[this.t1][][][][];
            } else if (this.changes != null && this.changes.length != 0) {
                this.initialChange(this.changes, chunkX, chunkZ, localX, localZ, y, -combined);
            }
        } else {
            if (this.changes == null || this.changes.length == 0) {
                this.changes = new int[this.t1][][][][];
            }
            this.appendChange(this.changes, chunkX, chunkZ, localX, localZ, y, zMap[localX] - combined);
        }
        zMap[localX] = combined;
    }

    private void initialChange(int[][][][][] src, int chunkX, int chunkZ, int localX, int localZ, int y, int combined) {
        int[][][][] arr = src[chunkZ];
        if (arr == null) {
            src[chunkZ] = new int[0][][][];
            return;
        }
        if (arr.length == 0) {
            return;
        }
        int[][][] arr2 = arr[chunkX];
        if (arr2 == null) {
            arr[chunkX] = new int[0][][];
            return;
        }
        if (arr2.length == 0) {
            return;
        }
        int[][] yMap = arr2[y];
        if (yMap == null) {
            arr2[y] = new int[0][];
            return;
        }
        if (yMap.length == 0) {
            return;
        }
        int[] zMap = yMap[localZ];
        if (zMap == null) {
            yMap[localZ] = new int[0];
            return;
        }
        if (zMap.length == 0) {
            return;
        }
        int current = zMap[localX];
        zMap[localX] = combined;
    }

    private void appendChange(int[][][][][] src, int chunkX, int chunkZ, int localX, int localZ, int y, int combined) {
        int[] zMap;
        Object yMap;
        Object arr2;
        Object arr = src[chunkZ];
        if (arr == null || ((int[][][][])arr).length == 0) {
            int[][][][] nArrayArray = new int[this.t2][][][];
            src[chunkZ] = nArrayArray;
            arr = nArrayArray;
        }
        if ((arr2 = arr[chunkX]) == null || ((int[][][])arr2).length == 0) {
            int[][][] nArrayArray = new int[256][][];
            arr[chunkX] = nArrayArray;
            arr2 = nArrayArray;
        }
        if ((yMap = arr2[y]) == null || ((int[][])yMap).length == 0) {
            int[][] nArrayArray = new int[16][];
            yMap = nArrayArray;
            arr2[y] = nArrayArray;
        }
        if ((zMap = yMap[localZ]) == null || zMap.length == 0) {
            zMap = new int[16];
            yMap[localZ] = zMap;
        }
        zMap[localX] = combined;
    }
}

