/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.object;

import com.boydti.fawe.config.BBC;
import com.boydti.fawe.object.FawePlayer;
import com.boydti.fawe.util.MainUtil;
import com.boydti.fawe.util.TaskManager;

public abstract class FaweCommand<T> {
    public final String perm;
    public final boolean safe;

    public FaweCommand(String perm) {
        this(perm, true);
    }

    public FaweCommand(String perm, boolean safe) {
        this.perm = perm;
        this.safe = safe;
    }

    public String getPerm() {
        return this.perm;
    }

    public boolean executeSafe(final FawePlayer<T> player, final String ... args) {
        try {
            if (!this.safe) {
                this.execute(player, args);
                return true;
            }
            if (player == null) {
                TaskManager.IMP.async(new Runnable(){

                    @Override
                    public void run() {
                        FaweCommand.this.execute(player, args);
                    }
                });
            } else if (!player.runAction(new Runnable(){

                @Override
                public void run() {
                    FaweCommand.this.execute(player, args);
                }
            }, true, true)) {
                BBC.WORLDEDIT_COMMAND_LIMIT.send(player, new Object[0]);
                return true;
            }
            return true;
        }
        catch (Throwable e) {
            MainUtil.handleError(e);
            return false;
        }
    }

    public abstract boolean execute(FawePlayer<T> var1, String ... var2);
}

