/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.bukkit.regions;

import com.boydti.fawe.bukkit.FaweBukkit;
import com.boydti.fawe.bukkit.regions.BukkitMask;
import com.boydti.fawe.bukkit.regions.BukkitMaskManager;
import com.boydti.fawe.object.FawePlayer;
import com.boydti.fawe.regions.FaweMaskManager;
import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.object.PlayerCache;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.TownyUniverse;
import com.palmergames.bukkit.towny.object.WorldCoord;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class TownyFeature
extends BukkitMaskManager
implements Listener {
    FaweBukkit plugin;
    Plugin towny;

    public TownyFeature(Plugin townyPlugin, FaweBukkit p3) {
        super(townyPlugin.getName());
        this.towny = townyPlugin;
        this.plugin = p3;
    }

    public boolean isAllowed(Player player, TownBlock block) {
        if (block == null) {
            return false;
        }
        try {
            Resident resident = TownyUniverse.getDataSource().getResident(player.getName());
            try {
                if (block.getResident().equals(resident)) {
                    return true;
                }
            }
            catch (NotRegisteredException notRegisteredException) {
                // empty catch block
            }
            Town town = block.getTown();
            if (town.isMayor(resident)) {
                return true;
            }
            if (!town.hasResident(resident)) {
                return false;
            }
            if (player.hasPermission("fawe.towny.*")) {
                return true;
            }
            for (String rank : resident.getTownRanks()) {
                if (!player.hasPermission("fawe.towny." + rank)) continue;
                return true;
            }
        }
        catch (NotRegisteredException e) {
            return false;
        }
        return false;
    }

    public BukkitMask getMask(FawePlayer<Player> fp) {
        Player player = (Player)fp.parent;
        final Location location = player.getLocation();
        try {
            PlayerCache cache = ((Towny)this.towny).getCache(player);
            WorldCoord mycoord = cache.getLastTownBlock();
            if (mycoord == null) {
                return null;
            }
            final TownBlock myplot = mycoord.getTownBlock();
            if (myplot == null) {
                return null;
            }
            boolean isMember = this.isAllowed(player, myplot);
            if (isMember) {
                Chunk chunk = location.getChunk();
                Location pos1 = new Location(location.getWorld(), (double)(chunk.getX() * 16), 0.0, (double)(chunk.getZ() * 16));
                Location pos2 = new Location(location.getWorld(), (double)(chunk.getX() * 16 + 15), 156.0, (double)(chunk.getZ() * 16 + 15));
                return new BukkitMask(pos1, pos2){

                    @Override
                    public String getName() {
                        return "PLOT:" + location.getChunk().getX() + "," + location.getChunk().getZ();
                    }

                    @Override
                    public boolean isValid(FawePlayer player, FaweMaskManager.MaskType type) {
                        return TownyFeature.this.isAllowed((Player)player.parent, myplot);
                    }
                };
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }
}

