/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.bukkit.regions;

import com.boydti.fawe.bukkit.FaweBukkit;
import com.boydti.fawe.bukkit.regions.BukkitMask;
import com.boydti.fawe.bukkit.regions.BukkitMaskManager;
import com.boydti.fawe.object.FawePlayer;
import com.boydti.fawe.object.RegionWrapper;
import com.boydti.fawe.regions.FaweMaskManager;
import com.boydti.fawe.util.MainUtil;
import com.boydti.fawe.util.Perm;
import com.massivecraft.factions.FLocation;
import java.lang.reflect.Method;
import java.util.List;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class FactionsOneFeature
extends BukkitMaskManager
implements Listener {
    private final Class clazzBoard = Class.forName("com.massivecraft.factions.Board");
    private final Method methodGetFactionAt = this.clazzBoard.getDeclaredMethod("getFactionAt", FLocation.class);

    public FactionsOneFeature(Plugin factionsPlugin, FaweBukkit p3) throws Throwable {
        super(factionsPlugin.getName());
    }

    public BukkitMask getMask(FawePlayer<Player> fp, FaweMaskManager.MaskType type) {
        Player player = (Player)fp.parent;
        Chunk chunk = player.getLocation().getChunk();
        boolean perm = Perm.hasPermission(FawePlayer.wrap(player), "fawe.factions.wilderness");
        World world = player.getWorld();
        RegionWrapper locs = new RegionWrapper(chunk.getX(), chunk.getX(), chunk.getZ(), chunk.getZ());
        int count = 32;
        if (this.isAdded(locs, world, player, perm, type)) {
            boolean hasPerm = true;
            while (hasPerm && count > 0) {
                --count;
                hasPerm = false;
                RegionWrapper chunkSelection = new RegionWrapper(locs.maxX + 1, locs.maxX + 1, locs.minZ, locs.maxZ);
                if (this.isAdded(chunkSelection, world, player, perm, type)) {
                    locs = new RegionWrapper(locs.minX, locs.maxX + 1, locs.minZ, locs.maxZ);
                    hasPerm = true;
                }
                if (this.isAdded(chunkSelection = new RegionWrapper(locs.minX - 1, locs.minX - 1, locs.minZ, locs.maxZ), world, player, perm, type)) {
                    locs = new RegionWrapper(locs.minX - 1, locs.maxX, locs.minZ, locs.maxZ);
                    hasPerm = true;
                }
                if (this.isAdded(chunkSelection = new RegionWrapper(locs.minX, locs.maxX, locs.maxZ + 1, locs.maxZ + 1), world, player, perm, type)) {
                    locs = new RegionWrapper(locs.minX, locs.maxX, locs.minZ, locs.maxZ + 1);
                    hasPerm = true;
                }
                if (!this.isAdded(chunkSelection = new RegionWrapper(locs.minX, locs.maxX, locs.minZ - 1, locs.minZ - 1), world, player, perm, type)) continue;
                locs = new RegionWrapper(locs.minX, locs.maxX, locs.minZ - 1, locs.maxZ);
                hasPerm = true;
            }
            final Location pos1 = new Location(world, (double)(locs.minX << 4), 1.0, (double)(locs.minZ << 4));
            Location pos2 = new Location(world, (double)(15 + (locs.maxX << 4)), 256.0, (double)(15 + (locs.maxZ << 4)));
            return new BukkitMask(pos1, pos2){

                @Override
                public String getName() {
                    return "CHUNK:" + pos1.getChunk().getX() + "," + pos1.getChunk().getZ();
                }
            };
        }
        return null;
    }

    public boolean isAdded(RegionWrapper locs, World world, Player player, boolean perm, FaweMaskManager.MaskType type) {
        try {
            for (int x = locs.minX; x <= locs.maxX; ++x) {
                for (int z = locs.minZ; z <= locs.maxZ; ++z) {
                    Object fac = this.methodGetFactionAt.invoke(null, new FLocation(world.getName(), x, z));
                    if (fac == null) {
                        return false;
                    }
                    if (type == FaweMaskManager.MaskType.OWNER) {
                        Object leader = fac.getClass().getDeclaredMethod("getFPlayerLeader", new Class[0]).invoke(fac, new Object[0]);
                        return player.getName().equals(leader.getClass().getDeclaredMethod("getName", new Class[0]).invoke(leader, new Object[0]));
                    }
                    Method methodGetOnlinePlayers = fac.getClass().getDeclaredMethod("getOnlinePlayers", new Class[0]);
                    List players = (List)methodGetOnlinePlayers.invoke(fac, new Object[0]);
                    if (!players.contains(player)) {
                        return false;
                    }
                    Method isNone = fac.getClass().getDeclaredMethod("isNone", new Class[0]);
                    if (!((Boolean)isNone.invoke(fac, new Object[0])).booleanValue()) continue;
                    return false;
                }
            }
            return true;
        }
        catch (Throwable e) {
            MainUtil.handleError(e);
            return false;
        }
    }
}

