/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.session;

import com.boydti.fawe.util.MaskTraverser;
import com.google.common.base.Preconditions;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.extent.clipboard.BlockArrayClipboard;
import com.sk89q.worldedit.extent.clipboard.Clipboard;
import com.sk89q.worldedit.extent.transform.BlockTransformExtent;
import com.sk89q.worldedit.function.RegionFunction;
import com.sk89q.worldedit.function.mask.ExistingBlockMask;
import com.sk89q.worldedit.function.mask.Mask;
import com.sk89q.worldedit.function.operation.ForwardExtentCopy;
import com.sk89q.worldedit.function.operation.Operation;
import com.sk89q.worldedit.math.transform.Transform;
import com.sk89q.worldedit.session.ClipboardHolder;

public class PasteBuilder {
    private final Clipboard clipboard;
    private final Transform transform;
    private final Extent targetExtent;
    private Vector to = new Vector();
    private boolean ignoreAirBlocks;
    private boolean ignoreBiomes;
    private boolean ignoreEntities;
    private RegionFunction canApply;

    public PasteBuilder(ClipboardHolder holder, Extent targetExtent) {
        Preconditions.checkNotNull((Object)holder);
        Preconditions.checkNotNull((Object)targetExtent);
        this.clipboard = holder.getClipboard();
        this.transform = holder.getTransform();
        this.targetExtent = targetExtent;
    }

    public PasteBuilder to(Vector to) {
        this.to = to;
        return this;
    }

    public PasteBuilder ignoreAirBlocks(boolean ignoreAirBlocks) {
        this.ignoreAirBlocks = ignoreAirBlocks;
        return this;
    }

    public PasteBuilder ignoreBiomes(boolean ignoreBiomes) {
        this.ignoreBiomes = ignoreBiomes;
        return this;
    }

    public PasteBuilder ignoreEntities(boolean ignoreEntities) {
        this.ignoreEntities = ignoreEntities;
        return this;
    }

    public PasteBuilder filter(RegionFunction function) {
        this.canApply = function;
        return this;
    }

    public Operation build() {
        Mask sourceMask;
        Extent extent = this.clipboard;
        if (!this.transform.isIdentity()) {
            extent = new BlockTransformExtent(extent, this.transform);
        }
        ForwardExtentCopy copy = new ForwardExtentCopy(extent, this.clipboard.getRegion(), this.clipboard.getOrigin(), this.targetExtent, this.to);
        copy.setTransform(this.transform);
        copy.setCopyingEntities(!this.ignoreEntities);
        copy.setCopyBiomes(!this.ignoreBiomes && (!(this.clipboard instanceof BlockArrayClipboard) || ((BlockArrayClipboard)this.clipboard).IMP.hasBiomes()));
        if (this.canApply != null) {
            copy.setFilterFunction(this.canApply);
        }
        if (this.targetExtent instanceof EditSession && (sourceMask = ((EditSession)this.targetExtent).getSourceMask()) != null) {
            new MaskTraverser(sourceMask).reset(extent);
            copy.setSourceMask(sourceMask);
            ((EditSession)this.targetExtent).setSourceMask(null);
        }
        if (this.ignoreAirBlocks) {
            copy.setSourceMask(new ExistingBlockMask(this.clipboard));
        }
        return copy;
    }
}

