/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.regions;

import com.boydti.fawe.config.Settings;
import com.boydti.fawe.object.collection.LocalBlockVectorSet;
import com.google.common.base.Preconditions;
import com.sk89q.worldedit.BlockVector;
import com.sk89q.worldedit.MutableBlockVector;
import com.sk89q.worldedit.MutableBlockVector2D;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.Vector2D;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.regions.AbstractRegion;
import com.sk89q.worldedit.regions.FlatRegion;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.regions.RegionIntersection;
import com.sk89q.worldedit.regions.RegionOperationException;
import com.sk89q.worldedit.util.Location;
import com.sk89q.worldedit.world.World;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;

public class CuboidRegion
extends AbstractRegion
implements FlatRegion {
    private Vector pos1;
    private Vector pos2;
    private boolean useOldIterator;
    private int minX;
    private int minY;
    private int minZ;
    private int maxX;
    private int maxY;
    private int maxZ;

    public CuboidRegion(Vector pos1, Vector pos2) {
        this(null, pos1, pos2);
    }

    public CuboidRegion(World world, Vector pos1, Vector pos2) {
        super(world);
        Extent extent;
        Preconditions.checkNotNull((Object)pos1);
        Preconditions.checkNotNull((Object)pos2);
        this.pos1 = pos1;
        this.pos2 = pos2;
        if (pos1 instanceof Location) {
            Extent extent2 = ((Location)pos1).getExtent();
            if (extent2 instanceof World) {
                this.setWorld((World)extent2);
            }
        } else if (pos2 instanceof Location && (extent = ((Location)pos2).getExtent()) instanceof World) {
            this.setWorld((World)extent);
        }
        this.recalculate();
    }

    public void setUseOldIterator(boolean useOldIterator) {
        this.useOldIterator = useOldIterator;
    }

    public Vector getPos1() {
        return this.pos1;
    }

    public void setPos1(Vector pos1) {
        this.pos1 = pos1;
        this.recalculate();
    }

    public Vector getPos2() {
        return this.pos2;
    }

    public void setPos2(Vector pos2) {
        this.pos2 = pos2;
        this.recalculate();
    }

    protected void recalculate() {
        if (this.pos1 == null || this.pos2 == null) {
            return;
        }
        this.pos1 = this.pos1.clampY(this.world == null ? Integer.MIN_VALUE : 0, this.world == null ? Integer.MAX_VALUE : this.world.getMaxY());
        this.pos2 = this.pos2.clampY(this.world == null ? Integer.MIN_VALUE : 0, this.world == null ? Integer.MAX_VALUE : this.world.getMaxY());
        Vector min = this.getMinimumPoint();
        Vector max = this.getMaximumPoint();
        this.minX = min.getBlockX();
        this.minY = min.getBlockY();
        this.minZ = min.getBlockZ();
        this.maxX = max.getBlockX();
        this.maxY = max.getBlockY();
        this.maxZ = max.getBlockZ();
    }

    public Region getFaces() {
        Vector min = this.getMinimumPoint();
        Vector max = this.getMaximumPoint();
        return new RegionIntersection(new CuboidRegion(new Vector(min.getX(), this.pos1.getY(), this.pos1.getZ()), new Vector(min.getX(), this.pos2.getY(), this.pos2.getZ())), new CuboidRegion(new Vector(max.getX(), this.pos1.getY(), this.pos1.getZ()), new Vector(max.getX(), this.pos2.getY(), this.pos2.getZ())), new CuboidRegion(new Vector(this.pos1.getX(), this.pos1.getY(), min.getZ()), new Vector(this.pos2.getX(), this.pos2.getY(), min.getZ())), new CuboidRegion(new Vector(this.pos1.getX(), this.pos1.getY(), max.getZ()), new Vector(this.pos2.getX(), this.pos2.getY(), max.getZ())), new CuboidRegion(new Vector(this.pos1.getX(), min.getY(), this.pos1.getZ()), new Vector(this.pos2.getX(), min.getY(), this.pos2.getZ())), new CuboidRegion(new Vector(this.pos1.getX(), max.getY(), this.pos1.getZ()), new Vector(this.pos2.getX(), max.getY(), this.pos2.getZ())));
    }

    public Region getWalls() {
        Vector min = this.getMinimumPoint();
        Vector max = this.getMaximumPoint();
        return new RegionIntersection(new CuboidRegion(new Vector(min.getX(), this.pos1.getY(), this.pos1.getZ()), new Vector(min.getX(), this.pos2.getY(), this.pos2.getZ())), new CuboidRegion(new Vector(max.getX(), this.pos1.getY(), this.pos1.getZ()), new Vector(max.getX(), this.pos2.getY(), this.pos2.getZ())), new CuboidRegion(new Vector(this.pos1.getX(), this.pos1.getY(), min.getZ()), new Vector(this.pos2.getX(), this.pos2.getY(), min.getZ())), new CuboidRegion(new Vector(this.pos1.getX(), this.pos1.getY(), max.getZ()), new Vector(this.pos2.getX(), this.pos2.getY(), max.getZ())));
    }

    @Override
    public Vector getMinimumPoint() {
        return new Vector(Math.min(this.pos1.getX(), this.pos2.getX()), Math.min(this.pos1.getY(), this.pos2.getY()), Math.min(this.pos1.getZ(), this.pos2.getZ()));
    }

    @Override
    public Vector getMaximumPoint() {
        return new Vector(Math.max(this.pos1.getX(), this.pos2.getX()), Math.max(this.pos1.getY(), this.pos2.getY()), Math.max(this.pos1.getZ(), this.pos2.getZ()));
    }

    @Override
    public int getMinimumY() {
        return Math.min(this.pos1.getBlockY(), this.pos2.getBlockY());
    }

    @Override
    public int getMaximumY() {
        return Math.max(this.pos1.getBlockY(), this.pos2.getBlockY());
    }

    @Override
    public void expand(Vector ... changes) {
        Preconditions.checkNotNull((Object)changes);
        for (Vector change : changes) {
            if (change.getX() > 0.0) {
                if (Math.max(this.pos1.getX(), this.pos2.getX()) == this.pos1.getX()) {
                    this.pos1 = this.pos1.add(new Vector(change.getX(), 0.0, 0.0));
                } else {
                    this.pos2 = this.pos2.add(new Vector(change.getX(), 0.0, 0.0));
                }
            } else if (Math.min(this.pos1.getX(), this.pos2.getX()) == this.pos1.getX()) {
                this.pos1 = this.pos1.add(new Vector(change.getX(), 0.0, 0.0));
            } else {
                this.pos2 = this.pos2.add(new Vector(change.getX(), 0.0, 0.0));
            }
            if (change.getY() > 0.0) {
                if (Math.max(this.pos1.getY(), this.pos2.getY()) == this.pos1.getY()) {
                    this.pos1 = this.pos1.add(new Vector(0.0, change.getY(), 0.0));
                } else {
                    this.pos2 = this.pos2.add(new Vector(0.0, change.getY(), 0.0));
                }
            } else if (Math.min(this.pos1.getY(), this.pos2.getY()) == this.pos1.getY()) {
                this.pos1 = this.pos1.add(new Vector(0.0, change.getY(), 0.0));
            } else {
                this.pos2 = this.pos2.add(new Vector(0.0, change.getY(), 0.0));
            }
            if (change.getZ() > 0.0) {
                if (Math.max(this.pos1.getZ(), this.pos2.getZ()) == this.pos1.getZ()) {
                    this.pos1 = this.pos1.add(new Vector(0.0, 0.0, change.getZ()));
                    continue;
                }
                this.pos2 = this.pos2.add(new Vector(0.0, 0.0, change.getZ()));
                continue;
            }
            if (Math.min(this.pos1.getZ(), this.pos2.getZ()) == this.pos1.getZ()) {
                this.pos1 = this.pos1.add(new Vector(0.0, 0.0, change.getZ()));
                continue;
            }
            this.pos2 = this.pos2.add(new Vector(0.0, 0.0, change.getZ()));
        }
        this.recalculate();
    }

    @Override
    public void contract(Vector ... changes) {
        Preconditions.checkNotNull((Object)changes);
        for (Vector change : changes) {
            if (change.getX() < 0.0) {
                if (Math.max(this.pos1.getX(), this.pos2.getX()) == this.pos1.getX()) {
                    this.pos1 = this.pos1.add(new Vector(change.getX(), 0.0, 0.0));
                } else {
                    this.pos2 = this.pos2.add(new Vector(change.getX(), 0.0, 0.0));
                }
            } else if (Math.min(this.pos1.getX(), this.pos2.getX()) == this.pos1.getX()) {
                this.pos1 = this.pos1.add(new Vector(change.getX(), 0.0, 0.0));
            } else {
                this.pos2 = this.pos2.add(new Vector(change.getX(), 0.0, 0.0));
            }
            if (change.getY() < 0.0) {
                if (Math.max(this.pos1.getY(), this.pos2.getY()) == this.pos1.getY()) {
                    this.pos1 = this.pos1.add(new Vector(0.0, change.getY(), 0.0));
                } else {
                    this.pos2 = this.pos2.add(new Vector(0.0, change.getY(), 0.0));
                }
            } else if (Math.min(this.pos1.getY(), this.pos2.getY()) == this.pos1.getY()) {
                this.pos1 = this.pos1.add(new Vector(0.0, change.getY(), 0.0));
            } else {
                this.pos2 = this.pos2.add(new Vector(0.0, change.getY(), 0.0));
            }
            if (change.getZ() < 0.0) {
                if (Math.max(this.pos1.getZ(), this.pos2.getZ()) == this.pos1.getZ()) {
                    this.pos1 = this.pos1.add(new Vector(0.0, 0.0, change.getZ()));
                    continue;
                }
                this.pos2 = this.pos2.add(new Vector(0.0, 0.0, change.getZ()));
                continue;
            }
            if (Math.min(this.pos1.getZ(), this.pos2.getZ()) == this.pos1.getZ()) {
                this.pos1 = this.pos1.add(new Vector(0.0, 0.0, change.getZ()));
                continue;
            }
            this.pos2 = this.pos2.add(new Vector(0.0, 0.0, change.getZ()));
        }
        this.recalculate();
    }

    @Override
    public Set<Vector2D> getChunks() {
        Vector min = this.getMinimumPoint();
        Vector max = this.getMaximumPoint();
        final int maxX = max.getBlockX() >> 4;
        final int minX = min.getBlockX() >> 4;
        final int maxZ = max.getBlockZ() >> 4;
        final int minZ = min.getBlockZ() >> 4;
        final int size = (maxX - minX + 1) * (maxZ - minZ + 1);
        return new AbstractSet<Vector2D>(){

            @Override
            public Iterator<Vector2D> iterator() {
                return new Iterator<Vector2D>(){
                    private MutableBlockVector2D pos;
                    {
                        this.pos = new MutableBlockVector2D().setComponents(maxX + 1, maxZ);
                    }

                    @Override
                    public boolean hasNext() {
                        return this.pos != null;
                    }

                    @Override
                    public Vector2D next() {
                        MutableBlockVector2D result = this.pos;
                        this.pos.setComponents(this.pos.getX() - 1.0, this.pos.getZ());
                        if (this.pos.getX() <= (double)minX) {
                            if (this.pos.getZ() == (double)minZ) {
                                this.pos = null;
                            } else if (this.pos.getX() < (double)minX) {
                                this.pos.setComponents((double)maxX, this.pos.getZ() - 1.0);
                            }
                        }
                        return result;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException("This set is immutable.");
                    }
                };
            }

            @Override
            public int size() {
                return size;
            }

            @Override
            public boolean contains(Object o) {
                if (o instanceof Vector2D) {
                    Vector2D cv = (Vector2D)o;
                    return cv.getX() >= (double)minX && cv.getX() <= (double)maxX && cv.getZ() >= (double)minZ && cv.getZ() <= (double)maxZ;
                }
                return false;
            }
        };
    }

    @Override
    public void shift(Vector change) throws RegionOperationException {
        this.pos1 = this.pos1.add(change);
        this.pos2 = this.pos2.add(change);
        this.recalculate();
    }

    @Override
    public Set<Vector> getChunkCubes() {
        LocalBlockVectorSet chunks = new LocalBlockVectorSet();
        Vector min = this.getMinimumPoint();
        Vector max = this.getMaximumPoint();
        for (int x = max.getBlockX() >> 4; x >= min.getBlockX() >> 4; --x) {
            for (int z = max.getBlockZ() >> 4; z >= min.getBlockZ() >> 4; --z) {
                for (int y = max.getBlockY() >> 4; y >= min.getBlockY() >> 4; --y) {
                    chunks.add(new Vector(x, y, z));
                }
            }
        }
        return chunks;
    }

    @Override
    public boolean contains(Vector position) {
        return this.contains(position.getBlockX(), position.getBlockY(), position.getBlockZ());
    }

    @Override
    public boolean contains(int x, int y, int z) {
        return x >= this.minX && x <= this.maxX && z >= this.minZ && z <= this.maxZ && y >= this.minY && y <= this.maxY;
    }

    @Override
    public boolean contains(int x, int z) {
        return x >= this.minX && x <= this.maxX && z >= this.minZ && z <= this.maxZ;
    }

    @Override
    public Iterator<BlockVector> iterator() {
        if (Settings.IMP.HISTORY.COMPRESSION_LEVEL >= 9 || this.useOldIterator) {
            return this.iterator_old();
        }
        return new Iterator<BlockVector>(){
            final MutableBlockVector mutable = new MutableBlockVector(0, 0, 0);
            private Vector min = CuboidRegion.this.getMinimumPoint();
            private Vector max = CuboidRegion.this.getMaximumPoint();
            int bx = this.min.getBlockX();
            int by = this.min.getBlockY();
            int bz = this.min.getBlockZ();
            int tx = this.max.getBlockX();
            int ty = this.max.getBlockY();
            int tz = this.max.getBlockZ();
            private int x = this.min.getBlockX();
            private int y = this.min.getBlockY();
            private int z = this.min.getBlockZ();
            int cx = this.x >> 4;
            int cz = this.z >> 4;
            int cbx = Math.max(this.bx, this.cx << 4);
            int cbz = Math.max(this.bz, this.cz << 4);
            int ctx = Math.min(this.tx, 15 + (this.cx << 4));
            int ctz = Math.min(this.tz, 15 + (this.cz << 4));
            public boolean hasNext = true;

            @Override
            public boolean hasNext() {
                return this.hasNext;
            }

            @Override
            public BlockVector next() {
                this.mutable.mutX(this.x);
                this.mutable.mutY(this.y);
                this.mutable.mutZ(this.z);
                if (++this.x > this.ctx) {
                    if (++this.z > this.ctz) {
                        if (++this.y > this.ty) {
                            this.y = this.by;
                            if (this.x > this.tx) {
                                this.x = this.bx;
                                if (this.z > this.tz) {
                                    if (!this.hasNext) {
                                        throw new NoSuchElementException("End of iterator"){

                                            @Override
                                            public Throwable fillInStackTrace() {
                                                return this;
                                            }
                                        };
                                    }
                                    this.x = this.tx;
                                    this.y = this.ty;
                                    this.hasNext = false;
                                    return this.mutable;
                                }
                            } else {
                                this.z = this.cbz;
                            }
                            this.cx = this.x >> 4;
                            this.cz = this.z >> 4;
                            this.cbx = Math.max(this.bx, this.cx << 4);
                            this.cbz = Math.max(this.bz, this.cz << 4);
                            this.ctx = Math.min(this.tx, 15 + (this.cx << 4));
                            this.ctz = Math.min(this.tz, 15 + (this.cz << 4));
                        } else {
                            this.x = this.cbx;
                            this.z = this.cbz;
                        }
                    } else {
                        this.x = this.cbx;
                    }
                }
                return this.mutable;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public Iterator<BlockVector> iterator_old() {
        final MutableBlockVector mutable = new MutableBlockVector(0, 0, 0);
        return new Iterator<BlockVector>(){
            private Vector min;
            private Vector max;
            private int nextX;
            private int nextY;
            private int nextZ;
            private boolean hasNext;
            {
                this.min = CuboidRegion.this.getMinimumPoint();
                this.max = CuboidRegion.this.getMaximumPoint();
                this.nextX = this.min.getBlockX();
                this.nextY = this.min.getBlockY();
                this.nextZ = this.min.getBlockZ();
                this.hasNext = true;
            }

            @Override
            public boolean hasNext() {
                return this.hasNext;
            }

            @Override
            public BlockVector next() {
                mutable.mutX(this.nextX);
                mutable.mutY(this.nextY);
                mutable.mutZ(this.nextZ);
                if (++this.nextX > this.max.getBlockX()) {
                    this.nextX = this.min.getBlockX();
                    if (++this.nextZ > this.max.getBlockZ()) {
                        this.nextZ = this.min.getBlockZ();
                        if (++this.nextY > this.max.getBlockY()) {
                            if (!this.hasNext) {
                                throw new NoSuchElementException("End of iterator"){

                                    @Override
                                    public Throwable fillInStackTrace() {
                                        return this;
                                    }
                                };
                            }
                            this.nextX = this.max.getBlockX();
                            this.nextZ = this.max.getBlockZ();
                            this.nextY = this.max.getBlockY();
                            this.hasNext = false;
                        }
                    }
                }
                return mutable;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public Iterable<Vector2D> asFlatRegion() {
        return new Iterable<Vector2D>(){

            @Override
            public Iterator<Vector2D> iterator() {
                final MutableBlockVector2D mutable = new MutableBlockVector2D();
                return new Iterator<Vector2D>(){
                    private Vector min;
                    private Vector max;
                    private int nextX;
                    private int nextZ;
                    {
                        this.min = CuboidRegion.this.getMinimumPoint();
                        this.max = CuboidRegion.this.getMaximumPoint();
                        this.nextX = this.min.getBlockX();
                        this.nextZ = this.min.getBlockZ();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.nextZ != Integer.MAX_VALUE;
                    }

                    @Override
                    public Vector2D next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        MutableBlockVector2D answer = mutable.setComponents(this.nextX, this.nextZ);
                        if (++this.nextX > this.max.getBlockX()) {
                            this.nextX = this.min.getBlockX();
                            if (++this.nextZ > this.max.getBlockZ()) {
                                if (this.nextZ == Integer.MIN_VALUE) {
                                    throw new NoSuchElementException("End of iterator"){

                                        @Override
                                        public Throwable fillInStackTrace() {
                                            return this;
                                        }
                                    };
                                }
                                this.nextZ = Integer.MAX_VALUE;
                                this.nextX = Integer.MAX_VALUE;
                            }
                        }
                        return answer;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public String toString() {
        return this.getMinimumPoint() + " - " + this.getMaximumPoint();
    }

    @Override
    public CuboidRegion clone() {
        return (CuboidRegion)super.clone();
    }

    public static CuboidRegion makeCuboid(Region region) {
        Preconditions.checkNotNull((Object)region);
        return new CuboidRegion(region.getMinimumPoint(), region.getMaximumPoint());
    }

    public static boolean contains(CuboidRegion region) {
        Vector min = region.getMinimumPoint();
        Vector max = region.getMaximumPoint();
        return region.contains(min.getBlockX(), min.getBlockY(), min.getBlockZ()) && region.contains(max.getBlockX(), max.getBlockY(), max.getBlockZ());
    }

    public static CuboidRegion fromCenter(Vector origin, int apothem) {
        Preconditions.checkNotNull((Object)origin);
        Preconditions.checkArgument((apothem >= 0 ? 1 : 0) != 0, (Object)"apothem => 0 required");
        Vector size = new Vector(1, 1, 1).multiply(apothem);
        return new CuboidRegion(origin.subtract(size), origin.add(size));
    }
}

