/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.function.operation;

import com.boydti.fawe.example.MappedFaweQueue;
import com.boydti.fawe.object.FaweQueue;
import com.boydti.fawe.object.extent.BlockTranslateExtent;
import com.boydti.fawe.object.extent.PositionTransformExtent;
import com.boydti.fawe.object.function.block.BiomeCopy;
import com.boydti.fawe.object.function.block.CombinedBlockCopy;
import com.boydti.fawe.object.function.block.SimpleBlockCopy;
import com.boydti.fawe.util.MaskTraverser;
import com.google.common.base.Preconditions;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.MutableBlockVector;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.extent.clipboard.BlockArrayClipboard;
import com.sk89q.worldedit.function.CombinedRegionFunction;
import com.sk89q.worldedit.function.RegionFunction;
import com.sk89q.worldedit.function.RegionMaskTestFunction;
import com.sk89q.worldedit.function.RegionMaskingFilter;
import com.sk89q.worldedit.function.entity.ExtentEntityCopy;
import com.sk89q.worldedit.function.mask.Mask;
import com.sk89q.worldedit.function.mask.Masks;
import com.sk89q.worldedit.function.operation.BackwardsExtentBlockCopy;
import com.sk89q.worldedit.function.operation.Operation;
import com.sk89q.worldedit.function.operation.Operations;
import com.sk89q.worldedit.function.operation.RunContext;
import com.sk89q.worldedit.function.visitor.EntityVisitor;
import com.sk89q.worldedit.function.visitor.IntersectRegionFunction;
import com.sk89q.worldedit.function.visitor.RegionVisitor;
import com.sk89q.worldedit.math.transform.AffineTransform;
import com.sk89q.worldedit.math.transform.Identity;
import com.sk89q.worldedit.math.transform.Transform;
import com.sk89q.worldedit.regions.Region;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class ForwardExtentCopy
implements Operation {
    private final Extent source;
    private final Extent destination;
    private final Region region;
    private final Vector from;
    private final Vector to;
    private int repetitions = 1;
    private Mask sourceMask = Masks.alwaysTrue();
    private boolean removingEntities;
    private RegionFunction sourceFunction = null;
    private Transform transform = new Identity();
    private Transform currentTransform = null;
    private int affected;
    private boolean copyEntities = true;
    private boolean copyBiomes = false;
    private RegionFunction filterFunction;

    public ForwardExtentCopy(Extent source, Region region, Extent destination, Vector to) {
        this(source, region, region.getMinimumPoint(), destination, to);
    }

    public ForwardExtentCopy(Extent source, Region region, Vector from, Extent destination, Vector to) {
        Preconditions.checkNotNull((Object)source);
        Preconditions.checkNotNull((Object)region);
        Preconditions.checkNotNull((Object)from);
        Preconditions.checkNotNull((Object)destination);
        Preconditions.checkNotNull((Object)to);
        this.source = source;
        this.destination = destination;
        this.region = region;
        this.from = from;
        this.to = to;
    }

    public Transform getTransform() {
        return this.transform;
    }

    public void setTransform(Transform transform) {
        Preconditions.checkNotNull((Object)transform);
        this.transform = transform;
    }

    public Mask getSourceMask() {
        return this.sourceMask;
    }

    public void setCopyingEntities(boolean copyEntities) {
        this.copyEntities = copyEntities;
    }

    public boolean isCopyingEntities() {
        return this.copyEntities;
    }

    public void setCopyBiomes(boolean copyBiomes) {
        this.copyBiomes = copyBiomes;
    }

    public boolean isCopyBiomes() {
        return this.copyBiomes;
    }

    public void setSourceMask(Mask sourceMask) {
        Preconditions.checkNotNull((Object)sourceMask);
        this.sourceMask = sourceMask;
    }

    public void setFilterFunction(RegionFunction filterFunction) {
        this.filterFunction = filterFunction;
    }

    public RegionFunction getSourceFunction() {
        return this.sourceFunction;
    }

    @Deprecated
    public void setSourceFunction(RegionFunction function) {
        this.sourceFunction = function;
    }

    public int getRepetitions() {
        return this.repetitions;
    }

    public void setRepetitions(int repetitions) {
        Preconditions.checkArgument((repetitions >= 0 ? 1 : 0) != 0, (Object)"number of repetitions must be non-negative");
        this.repetitions = repetitions;
    }

    public boolean isRemovingEntities() {
        return this.removingEntities;
    }

    public void setRemovingEntities(boolean removingEntities) {
        this.removingEntities = removingEntities;
    }

    public int getAffected() {
        return this.affected;
    }

    @Override
    public Operation resume(RunContext run) throws WorldEditException {
        RegionFunction copy;
        if (this.currentTransform == null) {
            this.currentTransform = this.transform;
        }
        FaweQueue queue = this.source instanceof EditSession ? ((EditSession)this.source).getQueue() : (this.destination instanceof EditSession ? ((EditSession)this.destination).getQueue() : null);
        Extent finalDest = this.destination;
        Vector translation = this.to.subtract(this.from);
        if (!translation.equals(Vector.ZERO)) {
            finalDest = new BlockTranslateExtent(finalDest, translation.getBlockX(), translation.getBlockY(), translation.getBlockZ());
        }
        Operation blockCopy = null;
        PositionTransformExtent transExt = null;
        if (!this.currentTransform.isIdentity()) {
            if (!(this.currentTransform instanceof AffineTransform) || ((AffineTransform)this.currentTransform).isOffAxis()) {
                transExt = new PositionTransformExtent(this.source, this.currentTransform.inverse());
                transExt.setOrigin(this.from);
                copy = new SimpleBlockCopy(transExt, finalDest);
                if (this.filterFunction != null) {
                    copy = new IntersectRegionFunction(this.filterFunction, copy);
                }
                if (this.sourceFunction != null) {
                    copy = CombinedRegionFunction.combine(copy, this.sourceFunction);
                }
                if (this.sourceMask != Masks.alwaysTrue()) {
                    new MaskTraverser(this.sourceMask).reset(transExt);
                    copy = new RegionMaskingFilter(this.sourceMask, copy);
                }
                if (this.copyBiomes && (!(this.source instanceof BlockArrayClipboard) || ((BlockArrayClipboard)this.source).IMP.hasBiomes())) {
                    copy = CombinedRegionFunction.combine(copy, new BiomeCopy(this.source, finalDest));
                }
                blockCopy = new BackwardsExtentBlockCopy(transExt, this.region, finalDest, this.from, this.transform, copy);
            } else {
                transExt = new PositionTransformExtent(finalDest, this.currentTransform);
                transExt.setOrigin(this.from);
                finalDest = transExt;
            }
        }
        if (blockCopy == null) {
            RegionFunction maskFunc = null;
            if (this.sourceFunction != null) {
                Vector disAbs = translation.positive();
                Vector size = this.region.getMaximumPoint().subtract(this.region.getMinimumPoint()).add(1, 1, 1);
                boolean overlap = disAbs.getBlockX() < size.getBlockX() && disAbs.getBlockY() < size.getBlockY() && disAbs.getBlockZ() < size.getBlockZ();
                RegionFunction copySrcFunc = this.sourceFunction;
                if (overlap && translation.length() != 0.0) {
                    MutableBlockVector mutable = new MutableBlockVector();
                    int x = translation.getBlockX();
                    int y = translation.getBlockY();
                    int z = translation.getBlockZ();
                    maskFunc = position -> {
                        mutable.setComponents(position.getBlockX() + x, position.getBlockY() + y, position.getBlockZ() + z);
                        if (this.region.contains(mutable)) {
                            return this.sourceFunction.apply(mutable);
                        }
                        return false;
                    };
                    copySrcFunc = position -> {
                        mutable.setComponents(position.getBlockX() - x, position.getBlockY() - y, position.getBlockZ() - z);
                        if (!this.region.contains(mutable)) {
                            return this.sourceFunction.apply(position);
                        }
                        return false;
                    };
                }
                copy = new CombinedBlockCopy(this.source, finalDest, copySrcFunc);
            } else {
                copy = new SimpleBlockCopy(this.source, finalDest);
            }
            if (this.filterFunction != null) {
                copy = new IntersectRegionFunction(this.filterFunction, copy);
            }
            if (this.sourceMask != Masks.alwaysTrue()) {
                copy = maskFunc != null ? new RegionMaskTestFunction(this.sourceMask, copy, maskFunc) : new RegionMaskingFilter(this.sourceMask, copy);
            }
            if (this.copyBiomes && (!(this.source instanceof BlockArrayClipboard) || ((BlockArrayClipboard)this.source).IMP.hasBiomes())) {
                copy = CombinedRegionFunction.combine(copy, new BiomeCopy(this.source, finalDest));
            }
            blockCopy = new RegionVisitor(this.region, copy, queue instanceof MappedFaweQueue ? (MappedFaweQueue)queue : null);
        }
        List<Object> entities = this.isCopyingEntities() ? this.source.getEntities().stream().filter(entity -> entity.getState() != null && entity.getState().getType().getId().equals("minecraft:player")).collect(Collectors.toList()) : new ArrayList();
        for (int i = 0; i < this.repetitions; ++i) {
            Operations.completeBlindly(blockCopy);
            if (!entities.isEmpty()) {
                ExtentEntityCopy entityCopy = new ExtentEntityCopy(this.from, this.destination, this.to, this.currentTransform);
                entityCopy.setRemoving(this.removingEntities);
                EntityVisitor entityVisitor = new EntityVisitor(entities.iterator(), entityCopy);
                Operations.completeBlindly(entityVisitor);
            }
            if (transExt == null) continue;
            this.currentTransform = this.currentTransform.combine(this.transform);
            transExt.setTransform(this.currentTransform);
        }
        this.affected = this.region.getArea();
        return null;
    }

    @Override
    public void cancel() {
    }

    @Override
    public void addStatusMessages(List<String> messages) {
    }
}

