/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.function.mask;

import com.google.common.base.Preconditions;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.function.mask.AbstractExtentMask;
import com.sk89q.worldedit.world.block.BlockType;
import com.sk89q.worldedit.world.block.BlockTypes;
import java.util.Collection;
import java.util.HashSet;

public class BlockTypeMask
extends AbstractExtentMask {
    private final boolean[] types;

    protected BlockTypeMask(Extent extent, boolean[] types) {
        super(extent);
        this.types = types;
    }

    public BlockTypeMask(Extent extent, BlockType ... types) {
        super(extent);
        this.types = new boolean[BlockTypes.size()];
        for (BlockType type : types) {
            this.types[type.getInternalId()] = true;
        }
    }

    public BlockTypeMask(Extent extent, Collection<BlockType> blocks) {
        this(extent, blocks.toArray(new BlockType[blocks.size()]));
    }

    public void add(Collection<BlockType> blocks) {
        Preconditions.checkNotNull(blocks);
        for (BlockType type : blocks) {
            this.add(type);
        }
        for (BlockType type : blocks) {
            this.types[type.getInternalId()] = true;
        }
    }

    public void add(BlockType ... blocks) {
        for (BlockType type : blocks) {
            this.types[type.getInternalId()] = true;
        }
    }

    public Collection<BlockType> getBlocks() {
        HashSet<BlockType> blocks = new HashSet<BlockType>();
        for (int i = 0; i < this.types.length; ++i) {
            if (!this.types[i]) continue;
            blocks.add(BlockTypes.get(i));
        }
        return blocks;
    }

    @Override
    public boolean test(Vector vector) {
        return this.types[this.getExtent().getBlockType(vector).getInternalId()];
    }
}

