/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.function.mask;

import com.boydti.fawe.command.SuggestInputParseException;
import com.boydti.fawe.object.collection.FastBitSet;
import com.boydti.fawe.object.string.MutableCharSequence;
import com.boydti.fawe.util.StringMan;
import com.sk89q.worldedit.extension.input.InputParseException;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.function.mask.BlockMask;
import com.sk89q.worldedit.registry.state.AbstractProperty;
import com.sk89q.worldedit.registry.state.Property;
import com.sk89q.worldedit.registry.state.PropertyKey;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import com.sk89q.worldedit.world.block.BlockType;
import com.sk89q.worldedit.world.block.BlockTypes;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class BlockMaskBuilder {
    private static final Operator GREATER = (a, b) -> a > b;
    private static final Operator LESS = (a, b) -> a < b;
    private static final Operator EQUAL = (a, b) -> a == b;
    private static final Operator EQUAL_OR_NULL = (a, b) -> a == b;
    private static final Operator GREATER_EQUAL = (a, b) -> a >= b;
    private static final Operator LESS_EQUAL = (a, b) -> a <= b;
    private static final Operator NOT = (a, b) -> a != b;
    private long[][] bitSets;
    private boolean optimizedStates = true;

    private boolean filterRegex(BlockType blockType, PropertyKey key, String regex) {
        Property property = blockType.getProperty(key);
        if (property == null) {
            return false;
        }
        List values = property.getValues();
        boolean result = false;
        for (int i = 0; i < values.size(); ++i) {
            Object value = values.get(i);
            if (value.toString().matches(regex) || !this.has(blockType, property, i)) continue;
            this.filter(blockType, property, i);
            result = true;
        }
        return result;
    }

    private boolean filterOperator(BlockType blockType, PropertyKey key, Operator operator, CharSequence value) {
        Property property = blockType.getProperty(key);
        if (property == null) {
            return false;
        }
        int index = property.getIndexFor(value);
        List values = property.getValues();
        boolean result = false;
        for (int i = 0; i < values.size(); ++i) {
            if (operator.test(index, i) || !this.has(blockType, property, i)) continue;
            this.filter(blockType, property, i);
            result = true;
        }
        return result;
    }

    private boolean filterRegexOrOperator(BlockType type, PropertyKey key, Operator operator, CharSequence value) {
        boolean result = false;
        if (!type.hasProperty(key)) {
            if (operator == EQUAL) {
                result = this.bitSets[type.getInternalId()] != null;
                this.remove(type);
            }
        } else if (value.length() != 0) {
            result = (operator == EQUAL || operator == EQUAL_OR_NULL) && !StringMan.isAlphanumericUnd(value) ? this.filterRegex(type, key, value.toString()) : this.filterOperator(type, key, operator, value);
        }
        return result;
    }

    public BlockMaskBuilder addRegex(String input) throws InputParseException {
        if (input.charAt(input.length() - 1) == ']') {
            int propStart = StringMan.findMatchingBracket(input, input.length() - 1);
            if (propStart == -1) {
                return this;
            }
            MutableCharSequence charSequence = MutableCharSequence.getTemporal();
            charSequence.setString(input);
            charSequence.setSubstring(0, propStart);
            BlockTypes type = null;
            ArrayList<BlockTypes> blockTypeList = null;
            if (StringMan.isAlphanumericUnd(charSequence)) {
                type = BlockTypes.parse(charSequence.toString());
                this.add(type);
            } else {
                String regex = charSequence.toString();
                blockTypeList = new ArrayList<BlockTypes>();
                for (BlockTypes myType : BlockTypes.values) {
                    if (!myType.getId().matches(regex)) continue;
                    blockTypeList.add(myType);
                    this.add(myType);
                }
                if (blockTypeList.isEmpty()) {
                    throw new InputParseException("No block found for " + input);
                }
                if (blockTypeList.size() == 1) {
                    type = (BlockTypes)blockTypeList.get(0);
                }
            }
            charSequence.setSubstring(0, 0);
            PropertyKey key = null;
            int length = input.length();
            int last = propStart + 1;
            Operator operator = null;
            block13: for (int i = last; i < length; ++i) {
                char c = input.charAt(i);
                switch (c) {
                    case '(': 
                    case '[': 
                    case '{': {
                        int next = StringMan.findMatchingBracket(input, i);
                        if (next == -1) continue block13;
                        i = next;
                        continue block13;
                    }
                    case ',': 
                    case ']': {
                        charSequence.setSubstring(last, i);
                        if (key == null && PropertyKey.get(charSequence) == null) {
                            this.suggest(input, charSequence.toString(), type != null ? Collections.singleton(type) : blockTypeList);
                        }
                        if (operator == null) {
                            throw new SuggestInputParseException("No operator for " + input, "", () -> Arrays.asList("=", "~", "!", "<", ">", "<=", ">="));
                        }
                        boolean filtered = false;
                        if (type != null) {
                            filtered = this.filterRegexOrOperator(type, key, operator, charSequence);
                        } else {
                            for (BlockTypes myType : blockTypeList) {
                                filtered |= this.filterRegexOrOperator(myType, key, operator, charSequence);
                            }
                        }
                        if (!filtered) {
                            String value = charSequence.toString();
                            PropertyKey fKey = key;
                            Collection<BlockTypes> types = type != null ? Collections.singleton(type) : blockTypeList;
                            throw new SuggestInputParseException("No value for " + input, input, () -> {
                                HashSet values = new HashSet();
                                types.forEach(t -> {
                                    if (t.hasProperty(fKey)) {
                                        Property p = t.getProperty(fKey);
                                        for (int j = 0; j < p.getValues().size(); ++j) {
                                            String o;
                                            if (!this.has((BlockType)t, p, j) || !(o = p.getValues().get(j).toString()).startsWith(value)) continue;
                                            values.add(o);
                                        }
                                    }
                                });
                                return new ArrayList(values);
                            });
                        }
                        key = null;
                        operator = null;
                        last = i + 1;
                        continue block13;
                    }
                    case '!': 
                    case '<': 
                    case '=': 
                    case '>': 
                    case '~': {
                        boolean extra;
                        charSequence.setSubstring(last, i);
                        boolean bl = extra = input.charAt(i + 1) == '=';
                        if (extra) {
                            ++i;
                        }
                        switch (c) {
                            case '~': {
                                operator = EQUAL_OR_NULL;
                                break;
                            }
                            case '!': {
                                operator = NOT;
                                break;
                            }
                            case '=': {
                                operator = EQUAL;
                                break;
                            }
                            case '<': {
                                operator = extra ? LESS_EQUAL : LESS;
                                break;
                            }
                            case '>': {
                                Operator operator2 = operator = extra ? GREATER_EQUAL : GREATER;
                            }
                        }
                        if ((charSequence.length() > 0 || key == null) && (key = PropertyKey.get(charSequence)) == null) {
                            this.suggest(input, charSequence.toString(), type != null ? Collections.singleton(type) : blockTypeList);
                        }
                        last = i + 1;
                        continue block13;
                    }
                }
            }
        } else if (StringMan.isAlphanumericUnd(input)) {
            this.add(BlockTypes.parse(input));
        } else {
            for (BlockTypes myType : BlockTypes.values) {
                if (!myType.getId().matches(input)) continue;
                this.add(myType);
            }
        }
        return this;
    }

    private boolean has(BlockType type, Property property, int index) {
        AbstractProperty prop = (AbstractProperty)property;
        long[] states = this.bitSets[type.getInternalId()];
        if (states == null) {
            return false;
        }
        List values = prop.getValues();
        int localI = index << prop.getBitOffset() >> BlockTypes.BIT_OFFSET;
        return states == BlockMask.ALL || FastBitSet.get(states, localI);
    }

    private void suggest(String input, String property, Collection<BlockTypes> finalTypes) throws InputParseException {
        throw new SuggestInputParseException(input + " does not have: " + property, input, () -> {
            HashSet keys = new HashSet();
            finalTypes.forEach(t -> t.getProperties().stream().forEach(p -> keys.add(p.getKey())));
            return keys.stream().map(p -> p.getId()).filter((? super T p) -> p.startsWith(property)).collect(Collectors.toList());
        });
    }

    public boolean isEmpty() {
        for (int i = 0; i < this.bitSets.length; ++i) {
            if (this.bitSets[i] == null) continue;
            return false;
        }
        return true;
    }

    public BlockMaskBuilder() {
        this(new long[BlockTypes.size()][]);
    }

    protected BlockMaskBuilder(long[][] bitSets) {
        this.bitSets = bitSets;
    }

    public BlockMaskBuilder parse(String input) {
        return this;
    }

    public BlockMaskBuilder addAll() {
        for (int i = 0; i < this.bitSets.length; ++i) {
            this.bitSets[i] = BlockMask.ALL;
        }
        this.optimizedStates = true;
        return this;
    }

    public BlockMaskBuilder clear() {
        for (int i = 0; i < this.bitSets.length; ++i) {
            this.bitSets[i] = null;
        }
        this.optimizedStates = true;
        return this;
    }

    public BlockMaskBuilder remove(BlockType type) {
        this.bitSets[type.getInternalId()] = null;
        return this;
    }

    public BlockMaskBuilder remove(BlockStateHolder state) {
        BlockTypes type = state.getBlockType();
        int i = type.getInternalId();
        long[] states = this.bitSets[i];
        if (states != null) {
            if (states == BlockMask.ALL) {
                states = FastBitSet.create(type.getMaxStateId() + 1);
                this.bitSets[i] = states;
                Arrays.fill(states, -1L);
            }
            int stateId = state.getInternalPropertiesId();
            FastBitSet.clear(states, stateId);
            this.optimizedStates = false;
        }
        return this;
    }

    public BlockMaskBuilder filter(BlockType type) {
        for (int i = 0; i < this.bitSets.length; ++i) {
            if (i == type.getInternalId()) continue;
            this.bitSets[i] = null;
        }
        return this;
    }

    public BlockMaskBuilder filter(BlockStateHolder state) {
        this.filter(state.getBlockType());
        BlockTypes type = state.getBlockType();
        int i = type.getInternalId();
        long[] states = this.bitSets[i];
        if (states != null) {
            int stateId = state.getInternalPropertiesId();
            boolean set = true;
            if (states == BlockMask.ALL) {
                states = FastBitSet.create(type.getMaxStateId() + 1);
                this.bitSets[i] = states;
            } else {
                set = FastBitSet.get(states, stateId);
                Arrays.fill(states, 0L);
            }
            if (set) {
                FastBitSet.set(states, stateId);
            } else {
                this.bitSets[i] = null;
            }
            this.optimizedStates = true;
        }
        return this;
    }

    public BlockMaskBuilder filter(Predicate<BlockType> allow) {
        for (int i = 0; i < this.bitSets.length; ++i) {
            BlockTypes type = BlockTypes.get(i);
            if (allow.test(type)) continue;
            this.bitSets[i] = null;
        }
        return this;
    }

    public <T> BlockMaskBuilder filter(Predicate<BlockType> typePredicate, BiPredicate<BlockType, Map.Entry<Property<T>, T>> allowed) {
        for (int i = 0; i < this.bitSets.length; ++i) {
            long[] states = this.bitSets[i];
            if (states == null) continue;
            BlockTypes type = BlockTypes.get(i);
            if (!typePredicate.test(type)) {
                this.bitSets[i] = null;
                continue;
            }
            List<? extends Property> properties = type.getProperties();
            for (AbstractProperty abstractProperty : properties) {
                List values = abstractProperty.getValues();
                for (int j = 0; j < values.size(); ++j) {
                    int localI = j << abstractProperty.getBitOffset() >> BlockTypes.BIT_OFFSET;
                    if (states != BlockMask.ALL && !FastBitSet.get(states, localI) || allowed.test(type, new AbstractMap.SimpleEntry(abstractProperty, values.get(j)))) continue;
                    if (states == BlockMask.ALL) {
                        states = FastBitSet.create(type.getMaxStateId() + 1);
                        this.bitSets[i] = states;
                        FastBitSet.setAll(states);
                    }
                    FastBitSet.clear(states, localI);
                    this.optimizedStates = false;
                }
            }
        }
        return this;
    }

    public BlockMaskBuilder add(BlockType type) {
        this.bitSets[type.getInternalId()] = BlockMask.ALL;
        return this;
    }

    public BlockMaskBuilder add(BlockStateHolder state) {
        BlockTypes type = state.getBlockType();
        int i = type.getInternalId();
        long[] states = this.bitSets[i];
        if (states != BlockMask.ALL) {
            if (states == null) {
                states = FastBitSet.create(type.getMaxStateId() + 1);
                this.bitSets[i] = states;
            }
            int stateId = state.getInternalPropertiesId();
            FastBitSet.set(states, stateId);
            this.optimizedStates = false;
        }
        return this;
    }

    public BlockMaskBuilder addBlocks(Collection<BlockStateHolder> blocks) {
        for (BlockStateHolder block : blocks) {
            this.add(block);
        }
        return this;
    }

    public BlockMaskBuilder addTypes(Collection<BlockType> blocks) {
        for (BlockType block : blocks) {
            this.add(block);
        }
        return this;
    }

    public BlockMaskBuilder addBlocks(BlockStateHolder ... blocks) {
        for (BlockStateHolder block : blocks) {
            this.add(block);
        }
        return this;
    }

    public BlockMaskBuilder addTypes(BlockType ... blocks) {
        for (BlockType block : blocks) {
            this.add(block);
        }
        return this;
    }

    public BlockMaskBuilder addAll(Predicate<BlockType> allow) {
        for (int i = 0; i < this.bitSets.length; ++i) {
            BlockTypes type = BlockTypes.get(i);
            if (!allow.test(type)) continue;
            this.bitSets[i] = BlockMask.ALL;
        }
        return this;
    }

    public BlockMaskBuilder addAll(Predicate<BlockType> typePredicate, BiPredicate<BlockType, Map.Entry<Property<?>, ?>> propPredicate) {
        for (int i = 0; i < this.bitSets.length; ++i) {
            BlockTypes type;
            long[] states = this.bitSets[i];
            if (states == BlockMask.ALL || !typePredicate.test(type = BlockTypes.get(i))) continue;
            for (AbstractProperty abstractProperty : type.getProperties()) {
                List values = abstractProperty.getValues();
                for (int j = 0; j < values.size(); ++j) {
                    int localI = j << abstractProperty.getBitOffset() >> BlockTypes.BIT_OFFSET;
                    if (states != null && FastBitSet.get(states, localI) || !propPredicate.test(type, new AbstractMap.SimpleEntry(abstractProperty, values.get(j)))) continue;
                    if (states == null) {
                        states = FastBitSet.create(type.getMaxStateId() + 1);
                        this.bitSets[i] = states;
                    }
                    FastBitSet.set(states, localI);
                    this.optimizedStates = false;
                }
            }
        }
        return this;
    }

    public BlockMaskBuilder add(BlockType type, Property property, int index) {
        AbstractProperty prop = (AbstractProperty)property;
        long[] states = this.bitSets[type.getInternalId()];
        if (states == BlockMask.ALL) {
            return this;
        }
        List values = property.getValues();
        int localI = index << prop.getBitOffset() >> BlockTypes.BIT_OFFSET;
        if (states == null || !FastBitSet.get(states, localI)) {
            if (states == null) {
                states = FastBitSet.create(type.getMaxStateId() + 1);
                this.bitSets[type.getInternalId()] = states;
            }
            this.set(type, states, property, index);
            this.optimizedStates = false;
        }
        return this;
    }

    public BlockMaskBuilder filter(BlockType type, Property property, int index) {
        AbstractProperty prop = (AbstractProperty)property;
        long[] states = this.bitSets[type.getInternalId()];
        if (states == null) {
            return this;
        }
        List values = property.getValues();
        int localI = index << prop.getBitOffset() >> BlockTypes.BIT_OFFSET;
        if (states == BlockMask.ALL || FastBitSet.get(states, localI)) {
            if (states == BlockMask.ALL) {
                states = FastBitSet.create(type.getMaxStateId() + 1);
                this.bitSets[type.getInternalId()] = states;
                FastBitSet.setAll(states);
            }
            this.clear(type, states, property, index);
            this.optimizedStates = false;
        }
        return this;
    }

    private void applyRecursive(List<Property> properties, int propertiesIndex, int state, long[] states, boolean set) {
        AbstractProperty current = (AbstractProperty)properties.get(propertiesIndex);
        List values = current.getValues();
        if (propertiesIndex + 1 < properties.size()) {
            for (int i = 0; i < values.size(); ++i) {
                int newState = current.modifyIndex(state, i);
                this.applyRecursive(properties, propertiesIndex + 1, newState, states, set);
            }
        } else {
            for (int i = 0; i < values.size(); ++i) {
                int index = current.modifyIndex(state, i) >> BlockTypes.BIT_OFFSET;
                if (set) {
                    FastBitSet.set(states, index);
                    continue;
                }
                FastBitSet.clear(states, index);
            }
        }
    }

    private void set(BlockType type, long[] bitSet, Property property, int index) {
        FastBitSet.set(bitSet, index);
        if (type.getProperties().size() > 1) {
            ArrayList<Property> properties = new ArrayList<Property>(type.getProperties());
            properties.remove(property);
            int state = ((AbstractProperty)property).modifyIndex(type.getInternalId(), index);
            this.applyRecursive(properties, 0, state, bitSet, true);
        }
    }

    private void clear(BlockType type, long[] bitSet, Property property, int index) {
        FastBitSet.clear(bitSet, index);
        if (type.getProperties().size() > 1) {
            ArrayList<Property> properties = new ArrayList<Property>(type.getProperties());
            properties.remove(property);
            int state = ((AbstractProperty)property).modifyIndex(type.getInternalId(), index);
            this.applyRecursive(properties, 0, state, bitSet, false);
        }
    }

    public BlockMaskBuilder optimize() {
        if (!this.optimizedStates) {
            for (int i = 0; i < this.bitSets.length; ++i) {
                long[] bitSet = this.bitSets[i];
                if (bitSet == null || bitSet == BlockMask.ALL) continue;
                BlockTypes type = BlockTypes.get(i);
                int maxStateId = type.getMaxStateId();
                if (maxStateId == 0) {
                    if (bitSet[0] == 0L) {
                        this.bitSets[i] = null;
                        continue;
                    }
                    this.bitSets[i] = BlockMask.ALL;
                    continue;
                }
                int set = 0;
                int clear = 0;
                for (AbstractProperty abstractProperty : type.getProperties()) {
                    List values = abstractProperty.getValues();
                    for (int j = 0; j < values.size(); ++j) {
                        int localI = j << abstractProperty.getBitOffset() >> BlockTypes.BIT_OFFSET;
                        if (FastBitSet.get(bitSet, localI)) {
                            ++set;
                            continue;
                        }
                        ++clear;
                    }
                }
                if (set == 0) {
                    this.bitSets[i] = null;
                    continue;
                }
                if (clear != 0) continue;
                this.bitSets[i] = BlockMask.ALL;
            }
            this.optimizedStates = true;
        }
        return this;
    }

    protected long[][] getBits() {
        return this.bitSets;
    }

    public BlockMask build(Extent extent) {
        this.optimize();
        return new BlockMask(extent, this.bitSets);
    }

    private static interface Operator {
        public boolean test(int var1, int var2);
    }
}

