/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.function.block;

import com.boydti.fawe.util.ReflectionUtils;
import com.google.common.base.Preconditions;
import com.sk89q.jnbt.ByteTag;
import com.sk89q.jnbt.CompoundTag;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.function.RegionFunction;
import com.sk89q.worldedit.internal.helper.MCDirections;
import com.sk89q.worldedit.math.transform.Transform;
import com.sk89q.worldedit.util.Direction;
import com.sk89q.worldedit.world.block.BlockState;
import java.util.Map;

public class ExtentBlockCopy
implements RegionFunction {
    private final Extent source;
    private final Extent destination;
    private final Vector from;
    private final Vector to;
    private final Transform transform;

    public ExtentBlockCopy(Extent source, Vector from, Extent destination, Vector to, Transform transform) {
        Preconditions.checkNotNull((Object)source);
        Preconditions.checkNotNull((Object)from);
        Preconditions.checkNotNull((Object)destination);
        Preconditions.checkNotNull((Object)to);
        Preconditions.checkNotNull((Object)transform);
        this.source = source;
        this.from = from;
        this.destination = destination;
        this.to = to;
        this.transform = transform;
    }

    @Override
    public boolean apply(Vector position) throws WorldEditException {
        Vector orig = position.subtract(this.from);
        Vector transformed = this.transform.apply(orig);
        BlockState block = this.transformNbtData(this.source.getBlock(position));
        return this.destination.setBlock(transformed.add(this.to), block);
    }

    private BlockState transformNbtData(BlockState state) {
        int rot;
        Direction direction;
        CompoundTag tag = state.getNbtData();
        if (tag != null && tag.containsKey("Rot") && (direction = MCDirections.fromRotation(rot = tag.asInt("Rot"))) != null) {
            Vector applyAbsolute = this.transform.apply(direction.toVector());
            Vector applyOrigin = this.transform.apply(Vector.ZERO);
            applyAbsolute.mutX(applyAbsolute.getX() - applyOrigin.getX());
            applyAbsolute.mutY(applyAbsolute.getY() - applyOrigin.getY());
            applyAbsolute.mutZ(applyAbsolute.getZ() - applyOrigin.getZ());
            Direction newDirection = Direction.findClosest(applyAbsolute, Direction.Flag.CARDINAL | Direction.Flag.ORDINAL | Direction.Flag.SECONDARY_ORDINAL);
            if (newDirection != null) {
                Map values = ReflectionUtils.getMap(tag.getValue());
                values.put("Rot", new ByteTag((byte)MCDirections.toRotation(newDirection)));
            }
        }
        return state;
    }
}

