/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.extent.clipboard.io.legacycompat;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import com.sk89q.jnbt.StringTag;
import com.sk89q.jnbt.Tag;
import com.sk89q.worldedit.extent.clipboard.io.legacycompat.NBTCompatibilityHandler;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import com.sk89q.worldedit.world.block.BlockTypes;
import java.util.Map;

public class SignCompatibilityHandler
implements NBTCompatibilityHandler {
    @Override
    public boolean isAffectedBlock(BlockStateHolder block) {
        return block.getBlockType() == BlockTypes.SIGN || block.getBlockType() == BlockTypes.WALL_SIGN;
    }

    @Override
    public void updateNBT(BlockStateHolder block, Map<String, Tag> values) {
        for (int i = 0; i < 4; ++i) {
            String key = "Text" + (i + 1);
            Tag value = values.get(key);
            if (!(value instanceof StringTag)) continue;
            String storedString = ((StringTag)value).getValue();
            JsonPrimitive jsonElement = null;
            if (storedString != null && storedString.startsWith("{")) {
                try {
                    jsonElement = new JsonParser().parse(storedString);
                }
                catch (JsonSyntaxException jsonSyntaxException) {
                    // empty catch block
                }
            }
            if (jsonElement == null) {
                jsonElement = new JsonPrimitive(storedString == null ? "" : storedString);
            }
            if (jsonElement.isJsonObject()) continue;
            if (jsonElement.isJsonNull()) {
                jsonElement = new JsonPrimitive("");
            }
            JsonObject jsonTextObject = new JsonObject();
            jsonTextObject.add("text", (JsonElement)jsonElement);
            values.put("Text" + (i + 1), new StringTag(jsonTextObject.toString()));
        }
    }
}

