/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.extent.clipboard.io;

import com.boydti.fawe.Fawe;
import com.boydti.fawe.object.collection.SoftHashMap;
import com.sk89q.worldedit.extent.clipboard.Clipboard;
import com.sk89q.worldedit.extent.clipboard.io.ClipboardReader;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import javax.imageio.ImageIO;

public class WavefrontReader
implements ClipboardReader {
    private final InputStream inputStream;
    private final File root;
    private final Map<String, BufferedImage> textures = new SoftHashMap<String, BufferedImage>();
    private final Map<String, Map<String, Material>> materialFiles = new HashMap<String, Map<String, Material>>();
    private final Map<String, Material> materials = new HashMap<String, Material>();

    public WavefrontReader(File file) throws FileNotFoundException {
        this.inputStream = new BufferedInputStream(new FileInputStream(file));
        File parent = file.getParentFile();
        this.root = parent == null ? new File(".") : parent;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static final double parse(String s) {
        int index;
        double neg;
        int len = s.length();
        boolean numIndex = true;
        if (s.charAt(0) == '-') {
            neg = -1.0;
            index = 1;
        } else {
            index = 0;
            neg = 1.0;
        }
        double val = 0.0;
        while (index < len) {
            char c = s.charAt(index);
            switch (c) {
                case ' ': {
                    return val * neg;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    val = val * 10.0 + (double)(c - 48);
                    break;
                }
                case '.': {
                    double factor = 0.1;
                    while (index < len) {
                        c = s.charAt(index);
                        switch (c) {
                            case ' ': {
                                return val * neg;
                            }
                            case '0': 
                            case '1': 
                            case '2': 
                            case '3': 
                            case '4': 
                            case '5': 
                            case '6': 
                            case '7': 
                            case '8': 
                            case '9': {
                                val += (double)(c - 48) * factor;
                                factor *= 0.1;
                                break;
                            }
                        }
                        ++index;
                    }
                    break block0;
                }
            }
            ++index;
        }
        return val * neg;
    }

    @Override
    public Clipboard read() throws IOException {
        try (InputStream finalStream = this.inputStream;){
            this.load(finalStream);
        }
        return null;
    }

    private final BufferedImage getTexture(String file) throws IOException {
        BufferedImage texture = this.textures.get(file);
        if (texture == null) {
            texture = ImageIO.read(new File(this.root, file));
            this.textures.put(file, texture);
        }
        return texture;
    }

    private void readLines(InputStream stream, Consumer<String> onEachLine, boolean nullTerminate) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(stream));){
            String line = reader.readLine();
            while (line != null) {
                if (!line.isEmpty() && line.charAt(0) != '#') {
                    onEachLine.accept(line);
                }
                line = reader.readLine();
            }
            if (nullTerminate) {
                onEachLine.accept(null);
            }
        }
    }

    private final int toIntColor(float color) {
        return (int)((double)(color * 256.0f) + 0.5);
    }

    private String getFileName(String arg) {
        String[] pathSplit = arg.split("[/|\\\\]");
        return pathSplit[pathSplit.length - 1];
    }

    @Override
    public void close() throws IOException {
    }

    private final void loadMaterials(String fileName) throws IOException {
        File file = new File(this.root, fileName);
        if (!file.exists()) {
            Fawe.debug(".mtl not found: " + fileName);
            return;
        }
        Map<String, Material> mtl = this.materialFiles.get(fileName);
        if (mtl == null) {
            mtl = new HashMap<String, Material>();
            final HashMap<String, Material> tmp = mtl;
            this.materialFiles.put(fileName, tmp);
            this.readLines(new FileInputStream(file), new Consumer<String>(){
                private String name;
                private Material material;
                private int index;

                private void add() {
                    if (this.material != null) {
                        if (this.material.color == Integer.MIN_VALUE) {
                            this.material.color = -1;
                        }
                        tmp.put(this.name, this.material);
                        this.material = null;
                        this.name = null;
                    }
                }

                @Override
                public void accept(String s) {
                    if (s == null) {
                        this.add();
                        return;
                    }
                    String[] args = s.split("[ ]+");
                    switch (args[0]) {
                        case "newmtl": {
                            this.add();
                            this.material = new Material();
                            this.name = args[1];
                            break;
                        }
                        case "Ka": {
                            if (this.material.color != Integer.MIN_VALUE) break;
                        }
                        case "Kd": {
                            float r = Float.parseFloat(args[1]);
                            float g = Float.parseFloat(args[2]);
                            float b = Float.parseFloat(args[3]);
                            this.material.color = (WavefrontReader.this.toIntColor(r) << 16) + (WavefrontReader.this.toIntColor(g) << 8) + WavefrontReader.this.toIntColor(b);
                            break;
                        }
                        case "d": {
                            this.material.dissolve = Double.parseDouble(args[1]);
                            break;
                        }
                        case "Tr": {
                            this.material.dissolve = 1.0 - Double.parseDouble(args[1]);
                            break;
                        }
                        case "map_Ka": {
                            if (this.material.texture != null) break;
                        }
                        case "map_Kd": {
                            this.material.texture = WavefrontReader.this.getFileName(args[1]);
                        }
                    }
                }
            }, true);
        }
        this.materials.putAll(mtl);
    }

    private final Material getMaterial(String name) {
        Material mtl = this.materials.get(name);
        return mtl != null ? mtl : new Material();
    }

    private void load(InputStream in) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(in));){
            String line = reader.readLine();
            while (line != null) {
                if (!line.isEmpty()) {
                    char char0 = line.charAt(0);
                    block4 : switch (char0) {
                        case '#': {
                            break;
                        }
                        case 'v': {
                            switch (line.charAt(1)) {
                                case ' ': 
                                case 'n': {
                                    Double.parseDouble("");
                                    break block4;
                                }
                            }
                            break;
                        }
                        case 'f': {
                            break;
                        }
                        case 'g': 
                        case 'l': 
                        case 'o': 
                        case 's': {
                            break;
                        }
                        default: {
                            String[] args = line.split(" ");
                            switch (args[0]) {
                                case "mtllib": {
                                    String[] pathSplit = args[1].split("[/|\\\\]");
                                    String fileName = pathSplit[pathSplit.length - 1];
                                    this.loadMaterials(fileName);
                                    break block4;
                                }
                            }
                        }
                    }
                }
                line = reader.readLine();
            }
        }
    }

    private class Material {
        private double dissolve = 1.0;
        private int color = Integer.MIN_VALUE;
        private String texture;

        private Material() {
        }
    }
}

