/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.command;

import com.boydti.fawe.config.BBC;
import com.boydti.fawe.config.Commands;
import com.boydti.fawe.object.FawePlayer;
import com.boydti.fawe.object.visitor.Fast2DIterator;
import com.boydti.fawe.util.chat.Message;
import com.sk89q.minecraft.util.commands.Command;
import com.sk89q.minecraft.util.commands.CommandContext;
import com.sk89q.minecraft.util.commands.CommandPermissions;
import com.sk89q.minecraft.util.commands.Logging;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.Vector2D;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.command.MethodCommands;
import com.sk89q.worldedit.entity.Player;
import com.sk89q.worldedit.extension.platform.Capability;
import com.sk89q.worldedit.function.FlatRegionFunction;
import com.sk89q.worldedit.function.FlatRegionMaskingFilter;
import com.sk89q.worldedit.function.RegionFunction;
import com.sk89q.worldedit.function.biome.BiomeReplace;
import com.sk89q.worldedit.function.mask.Mask;
import com.sk89q.worldedit.function.mask.Mask2D;
import com.sk89q.worldedit.function.operation.Operations;
import com.sk89q.worldedit.function.visitor.FlatRegionVisitor;
import com.sk89q.worldedit.function.visitor.RegionVisitor;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.regions.FlatRegion;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.regions.Regions;
import com.sk89q.worldedit.util.Countable;
import com.sk89q.worldedit.util.Location;
import com.sk89q.worldedit.util.command.binding.Switch;
import com.sk89q.worldedit.world.World;
import com.sk89q.worldedit.world.biome.BaseBiome;
import com.sk89q.worldedit.world.biome.BiomeData;
import com.sk89q.worldedit.world.registry.BiomeRegistry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@Command(aliases={}, desc="Change, list and inspect biomes")
public class BiomeCommands
extends MethodCommands {
    public BiomeCommands(WorldEdit worldEdit) {
        super(worldEdit);
    }

    private BiomeRegistry getBiomeRegistry() {
        return this.worldEdit.getPlatformManager().queryCapability(Capability.GAME_HOOKS).getRegistries().getBiomeRegistry();
    }

    @Command(aliases={"biomelist", "biomels"}, usage="[page]", desc="Gets all biomes available.", max=1)
    @CommandPermissions(value={"worldedit.biome.list"})
    public void biomeList(Player player, CommandContext args) throws WorldEditException {
        int offset;
        int page;
        int count = 0;
        if (args.argsLength() == 0 || (page = args.getInteger(0)) < 2) {
            page = 1;
            offset = 0;
        } else {
            offset = (page - 1) * 19;
        }
        BiomeRegistry biomeRegistry = this.getBiomeRegistry();
        List<BaseBiome> biomes = biomeRegistry.getBiomes();
        int totalPages = biomes.size() / 19 + 1;
        Message msg = BBC.BIOME_LIST_HEADER.m(page, totalPages);
        String setBiome = Commands.getAlias(BiomeCommands.class, "/setbiome");
        for (BaseBiome biome : biomes) {
            if (offset > 0) {
                --offset;
                continue;
            }
            BiomeData data = biomeRegistry.getData(biome);
            if (data != null) {
                msg.newline().text(data.getName()).cmdTip(setBiome + " " + data.getName());
            } else {
                msg.newline().text("<? #" + biome.getId() + ">").cmdTip(setBiome + " " + biome.getId());
            }
            if (++count != 18) continue;
            break;
        }
        msg.newline().paginate(this.getCommand().aliases()[0], page, totalPages);
        msg.send(player);
    }

    @Command(aliases={"biomeinfo"}, flags="pt", desc="Get the biome of the targeted block.", help="Get the biome of the block.\nBy default use all the blocks contained in your selection.\n-t use the block you are looking at.\n-p use the block you are currently in", max=0)
    @CommandPermissions(value={"worldedit.biome.info"})
    public void biomeInfo(Player player, LocalSession session, final EditSession editSession, CommandContext args) throws WorldEditException {
        BiomeRegistry biomeRegistry = this.getBiomeRegistry();
        final int[] biomes = new int[256];
        int size = 0;
        if (args.hasFlag('t')) {
            Location blockPosition = player.getBlockTrace(300);
            if (blockPosition == null) {
                BBC.NO_BLOCK.send(player, new Object[0]);
                return;
            }
            BaseBiome biome = player.getWorld().getBiome(blockPosition.toVector().toVector2D());
            int n = biome.getId();
            biomes[n] = biomes[n] + 1;
            size = 1;
        } else if (args.hasFlag('p')) {
            BaseBiome biome = player.getWorld().getBiome(player.getLocation().toVector().toVector2D());
            int n = biome.getId();
            biomes[n] = biomes[n] + 1;
            size = 1;
        } else {
            World world = player.getWorld();
            Region region = session.getSelection(world);
            if (region instanceof FlatRegion) {
                for (Vector2D pt : new Fast2DIterator(((FlatRegion)region).asFlatRegion(), editSession)) {
                    int n = editSession.getBiome(pt).getId();
                    biomes[n] = biomes[n] + 1;
                    ++size;
                }
            } else {
                RegionVisitor regionVisitor = new RegionVisitor(region, new RegionFunction(){

                    @Override
                    public boolean apply(Vector position) throws WorldEditException {
                        int n = editSession.getBiome(position.toVector2D()).getId();
                        biomes[n] = biomes[n] + 1;
                        return true;
                    }
                }, editSession);
                Operations.completeBlindly(regionVisitor);
                size += regionVisitor.getAffected();
            }
        }
        BBC.BIOME_LIST_HEADER.send(player, 1, 1);
        ArrayList<Countable<BaseBiome>> distribution = new ArrayList<Countable<BaseBiome>>();
        for (int i = 0; i < biomes.length; ++i) {
            int n = biomes[i];
            if (n == 0) continue;
            distribution.add(new Countable<BaseBiome>(new BaseBiome(i), n));
        }
        Collections.sort(distribution);
        for (Countable countable : distribution) {
            BiomeData data = biomeRegistry.getData((BaseBiome)countable.getID());
            String str = String.format("%-7s (%.3f%%) %s #%d", String.valueOf(countable.getAmount()), (double)countable.getAmount() / (double)size * 100.0, data == null ? "Unknown" : data.getName(), ((BaseBiome)countable.getID()).getId());
            player.print(BBC.getPrefix() + str);
        }
    }

    @Command(aliases={"/setbiome"}, usage="<biome>", flags="p", desc="Sets the biome of the player's current block or region.", help="Set the biome of the region.\nBy default use all the blocks contained in your selection.\n-p use the block you are currently in")
    @Logging(value=Logging.LogMode.REGION)
    @CommandPermissions(value={"worldedit.biome.set"})
    public void setBiome(Player player, LocalSession session, EditSession editSession, BaseBiome target, @Switch(value=112) boolean atPosition) throws WorldEditException {
        World world = player.getWorld();
        Mask mask = editSession.getMask();
        Mask2D mask2d = mask != null ? mask.toMask2D() : null;
        Region region = atPosition ? new CuboidRegion(player.getLocation().toVector(), player.getLocation().toVector()) : session.getSelection(world);
        FlatRegionFunction replace = new BiomeReplace(editSession, target);
        if (mask2d != null) {
            replace = new FlatRegionMaskingFilter(mask2d, replace);
        }
        FlatRegionVisitor visitor = new FlatRegionVisitor(Regions.asFlatRegion(region), replace);
        Operations.completeLegacy(visitor);
        BBC.BIOME_CHANGED.send(player, visitor.getAffected());
        if (!FawePlayer.wrap(player).hasPermission("fawe.tips")) {
            BBC.TIP_BIOME_PATTERN.or(BBC.TIP_BIOME_MASK).send(player, new Object[0]);
        }
    }
}

