/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.bukkit;

import com.sk89q.worldedit.blocks.BlockMaterial;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.bukkit.WorldEditPlugin;
import com.sk89q.worldedit.bukkit.adapter.BukkitImplAdapter;
import com.sk89q.worldedit.registry.state.Property;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockType;
import com.sk89q.worldedit.world.block.BlockTypes;
import com.sk89q.worldedit.world.registry.BundledBlockRegistry;
import com.sk89q.worldedit.world.registry.PassthroughBlockMaterial;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Nullable;
import org.bukkit.Material;
import org.bukkit.block.data.BlockData;

public class BukkitBlockRegistry
extends BundledBlockRegistry {
    private BukkitBlockMaterial[] materialMap;

    @Override
    @Nullable
    public BlockMaterial getMaterial(BlockType blockType) {
        BukkitBlockMaterial result;
        BlockMaterial result2;
        BukkitImplAdapter adapter = WorldEditPlugin.getInstance().getBukkitImplAdapter();
        if (adapter != null && (result2 = adapter.getMaterial(blockType)) != null) {
            return result2;
        }
        Material type = BukkitAdapter.adapt(blockType);
        if (type == null) {
            if (blockType == BlockTypes.__RESERVED__) {
                return new PassthroughBlockMaterial(super.getMaterial(BlockTypes.AIR));
            }
            return new PassthroughBlockMaterial(null);
        }
        if (this.materialMap == null) {
            this.materialMap = new BukkitBlockMaterial[Material.values().length];
        }
        if ((result = this.materialMap[type.ordinal()]) == null) {
            this.materialMap[type.ordinal()] = result = new BukkitBlockMaterial(BukkitBlockRegistry.super.getMaterial(blockType), type);
        }
        return result;
    }

    @Override
    @Nullable
    public BlockMaterial getMaterial(BlockState state) {
        BlockMaterial result;
        BukkitImplAdapter adapter = WorldEditPlugin.getInstance().getBukkitImplAdapter();
        if (adapter != null && (result = adapter.getMaterial(state)) != null) {
            return result;
        }
        return super.getMaterial(state);
    }

    @Override
    @Nullable
    public Map<String, ? extends Property> getProperties(BlockType blockType) {
        BukkitImplAdapter adapter = WorldEditPlugin.getInstance().getBukkitImplAdapter();
        if (adapter != null) {
            return adapter.getProperties(blockType);
        }
        return super.getProperties(blockType);
    }

    @Override
    public Collection<String> registerBlocks() {
        ArrayList<String> blocks = new ArrayList<String>();
        for (Material m : Material.values()) {
            if (m.isLegacy() || !m.isBlock()) continue;
            BlockData blockData = m.createBlockData();
            blocks.add(blockData.getAsString());
        }
        return blocks;
    }

    public static class BukkitBlockMaterial
    extends PassthroughBlockMaterial {
        private final Material material;

        public BukkitBlockMaterial(@Nullable BlockMaterial material, Material bukkitMaterial) {
            super(material);
            this.material = bukkitMaterial;
        }

        @Override
        public boolean isAir() {
            switch (this.material) {
                case AIR: 
                case CAVE_AIR: 
                case VOID_AIR: {
                    return true;
                }
            }
            return false;
        }

        @Override
        public boolean isSolid() {
            return this.material.isSolid();
        }

        @Override
        public boolean isBurnable() {
            return this.material.isBurnable();
        }

        @Override
        public boolean isTranslucent() {
            return this.material.isTransparent();
        }
    }
}

