/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.blocks;

import com.sk89q.jnbt.CompoundTag;
import com.sk89q.jnbt.StringTag;
import com.sk89q.jnbt.Tag;
import com.sk89q.worldedit.blocks.BaseBlock;
import com.sk89q.worldedit.world.block.BlockState;
import java.util.HashMap;

public class SkullBlock
extends BaseBlock {
    private String owner = "";

    public SkullBlock(BlockState state) {
        super(state);
        this.owner = "";
    }

    public SkullBlock(BlockState blockState, String owner) {
        super(blockState);
        this.setOwner(owner);
    }

    public void setOwner(String owner) {
        this.owner = owner == null ? "" : (owner.length() > 16 || owner.isEmpty() ? "" : owner);
    }

    public String getOwner() {
        return this.owner;
    }

    @Override
    public boolean hasNbtData() {
        return true;
    }

    @Override
    public String getNbtId() {
        return "Skull";
    }

    @Override
    public CompoundTag getNbtData() {
        HashMap<String, Tag> values = new HashMap<String, Tag>();
        if (this.owner == null) {
            this.owner = "";
        }
        values.put("ExtraType", new StringTag(this.owner));
        return new CompoundTag(values);
    }

    @Override
    public void setNbtData(CompoundTag rootTag) {
        if (rootTag == null) {
            return;
        }
        Object values = rootTag.getValue();
        Tag t = (Tag)values.get("id");
        if (!(t instanceof StringTag) || !((StringTag)t).getValue().equals("Skull")) {
            throw new RuntimeException("'Skull' tile entity expected");
        }
        t = (Tag)values.get("ExtraType");
        if (t instanceof StringTag) {
            this.owner = ((StringTag)t).getValue();
        }
    }
}

