/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit;

import com.boydti.fawe.Fawe;
import com.boydti.fawe.FaweAPI;
import com.boydti.fawe.config.BBC;
import com.boydti.fawe.config.Settings;
import com.boydti.fawe.example.MappedFaweQueue;
import com.boydti.fawe.jnbt.anvil.MCAQueue;
import com.boydti.fawe.jnbt.anvil.MCAWorld;
import com.boydti.fawe.logging.LoggingChangeSet;
import com.boydti.fawe.logging.rollback.RollbackOptimizedHistory;
import com.boydti.fawe.object.FaweLimit;
import com.boydti.fawe.object.FawePlayer;
import com.boydti.fawe.object.FaweQueue;
import com.boydti.fawe.object.HasFaweQueue;
import com.boydti.fawe.object.HistoryExtent;
import com.boydti.fawe.object.NullChangeSet;
import com.boydti.fawe.object.RegionWrapper;
import com.boydti.fawe.object.RunnableVal;
import com.boydti.fawe.object.brush.visualization.VirtualWorld;
import com.boydti.fawe.object.changeset.BlockBagChangeSet;
import com.boydti.fawe.object.changeset.CPUOptimizedChangeSet;
import com.boydti.fawe.object.changeset.DiskStorageHistory;
import com.boydti.fawe.object.changeset.FaweChangeSet;
import com.boydti.fawe.object.changeset.MemoryOptimizedHistory;
import com.boydti.fawe.object.collection.LocalBlockVectorSet;
import com.boydti.fawe.object.exception.FaweException;
import com.boydti.fawe.object.extent.FastWorldEditExtent;
import com.boydti.fawe.object.extent.FaweRegionExtent;
import com.boydti.fawe.object.extent.HeightBoundExtent;
import com.boydti.fawe.object.extent.MultiRegionExtent;
import com.boydti.fawe.object.extent.NullExtent;
import com.boydti.fawe.object.extent.ProcessedWEExtent;
import com.boydti.fawe.object.extent.ResettableExtent;
import com.boydti.fawe.object.extent.SingleRegionExtent;
import com.boydti.fawe.object.extent.SlowExtent;
import com.boydti.fawe.object.extent.SourceMaskExtent;
import com.boydti.fawe.object.extent.StripNBTExtent;
import com.boydti.fawe.object.function.SurfaceRegionFunction;
import com.boydti.fawe.object.mask.ResettableMask;
import com.boydti.fawe.object.pattern.ExistingPattern;
import com.boydti.fawe.object.progress.ChatProgressTracker;
import com.boydti.fawe.object.progress.DefaultProgressTracker;
import com.boydti.fawe.util.ExtentTraverser;
import com.boydti.fawe.util.MaskTraverser;
import com.boydti.fawe.util.MathMan;
import com.boydti.fawe.util.MemUtil;
import com.boydti.fawe.util.Perm;
import com.boydti.fawe.util.SetQueue;
import com.boydti.fawe.util.TaskManager;
import com.boydti.fawe.wrappers.WorldWrapper;
import com.google.common.base.Preconditions;
import com.sk89q.jnbt.CompoundTag;
import com.sk89q.worldedit.BlockVector;
import com.sk89q.worldedit.MaxChangedBlocksException;
import com.sk89q.worldedit.MutableBlockVector;
import com.sk89q.worldedit.MutableBlockVector2D;
import com.sk89q.worldedit.PlayerDirection;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.Vector2D;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.blocks.BaseBlock;
import com.sk89q.worldedit.blocks.BaseItemStack;
import com.sk89q.worldedit.entity.BaseEntity;
import com.sk89q.worldedit.entity.Entity;
import com.sk89q.worldedit.event.extent.EditSessionEvent;
import com.sk89q.worldedit.extent.AbstractDelegateExtent;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.extent.MaskingExtent;
import com.sk89q.worldedit.extent.inventory.BlockBag;
import com.sk89q.worldedit.extent.inventory.BlockBagExtent;
import com.sk89q.worldedit.extent.world.SurvivalModeExtent;
import com.sk89q.worldedit.function.GroundFunction;
import com.sk89q.worldedit.function.RegionFunction;
import com.sk89q.worldedit.function.RegionMaskingFilter;
import com.sk89q.worldedit.function.block.BlockReplace;
import com.sk89q.worldedit.function.block.Naturalizer;
import com.sk89q.worldedit.function.generator.GardenPatchGenerator;
import com.sk89q.worldedit.function.mask.BlockMask;
import com.sk89q.worldedit.function.mask.BlockMaskBuilder;
import com.sk89q.worldedit.function.mask.BlockTypeMask;
import com.sk89q.worldedit.function.mask.BoundedHeightMask;
import com.sk89q.worldedit.function.mask.ExistingBlockMask;
import com.sk89q.worldedit.function.mask.Mask;
import com.sk89q.worldedit.function.mask.MaskIntersection;
import com.sk89q.worldedit.function.mask.Masks;
import com.sk89q.worldedit.function.mask.NoiseFilter2D;
import com.sk89q.worldedit.function.mask.RegionMask;
import com.sk89q.worldedit.function.operation.ChangeSetExecutor;
import com.sk89q.worldedit.function.operation.ForwardExtentCopy;
import com.sk89q.worldedit.function.operation.Operations;
import com.sk89q.worldedit.function.pattern.BlockPattern;
import com.sk89q.worldedit.function.util.RegionOffset;
import com.sk89q.worldedit.function.visitor.DirectionalVisitor;
import com.sk89q.worldedit.function.visitor.DownwardVisitor;
import com.sk89q.worldedit.function.visitor.FlatRegionVisitor;
import com.sk89q.worldedit.function.visitor.LayerVisitor;
import com.sk89q.worldedit.function.visitor.NonRisingVisitor;
import com.sk89q.worldedit.function.visitor.RecursiveVisitor;
import com.sk89q.worldedit.function.visitor.RegionVisitor;
import com.sk89q.worldedit.history.UndoContext;
import com.sk89q.worldedit.history.change.BlockChange;
import com.sk89q.worldedit.history.changeset.ChangeSet;
import com.sk89q.worldedit.internal.expression.Expression;
import com.sk89q.worldedit.internal.expression.ExpressionException;
import com.sk89q.worldedit.internal.expression.runtime.EvaluationException;
import com.sk89q.worldedit.internal.expression.runtime.RValue;
import com.sk89q.worldedit.math.interpolation.KochanekBartelsInterpolation;
import com.sk89q.worldedit.math.interpolation.Node;
import com.sk89q.worldedit.math.noise.RandomNoise;
import com.sk89q.worldedit.math.transform.AffineTransform;
import com.sk89q.worldedit.patterns.Pattern;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.regions.EllipsoidRegion;
import com.sk89q.worldedit.regions.FlatRegion;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.regions.Regions;
import com.sk89q.worldedit.regions.shape.ArbitraryBiomeShape;
import com.sk89q.worldedit.regions.shape.ArbitraryShape;
import com.sk89q.worldedit.regions.shape.RegionShape;
import com.sk89q.worldedit.regions.shape.WorldEditExpressionEnvironment;
import com.sk89q.worldedit.util.Countable;
import com.sk89q.worldedit.util.Location;
import com.sk89q.worldedit.util.TreeGenerator;
import com.sk89q.worldedit.util.eventbus.EventBus;
import com.sk89q.worldedit.world.SimpleWorld;
import com.sk89q.worldedit.world.World;
import com.sk89q.worldedit.world.biome.BaseBiome;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import com.sk89q.worldedit.world.block.BlockType;
import com.sk89q.worldedit.world.block.BlockTypes;
import com.sk89q.worldedit.world.weather.WeatherType;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class EditSession
extends AbstractDelegateExtent
implements HasFaweQueue,
SimpleWorld {
    private World world;
    private String worldName;
    private FaweQueue queue;
    private boolean wrapped;
    private boolean fastMode;
    private AbstractDelegateExtent extent;
    private HistoryExtent history;
    private AbstractDelegateExtent bypassHistory;
    private AbstractDelegateExtent bypassAll;
    private FaweLimit originalLimit;
    private FaweLimit limit;
    private FawePlayer player;
    private FaweChangeSet changeTask;
    private MutableBlockVector mutable = new MutableBlockVector();
    private int changes = 0;
    private BlockBag blockBag;
    private final int maxY;
    public static final UUID CONSOLE = UUID.fromString("1-1-3-3-7");
    public static final BaseBiome nullBiome = new BaseBiome(0);
    public static final BlockState nullBlock = BlockTypes.AIR.getDefaultState();
    private static final Vector[] recurseDirections = new Vector[]{PlayerDirection.NORTH.vector(), PlayerDirection.EAST.vector(), PlayerDirection.SOUTH.vector(), PlayerDirection.WEST.vector(), PlayerDirection.UP.vector(), PlayerDirection.DOWN.vector()};

    @Deprecated
    public EditSession(@Nonnull World world, @Nullable FaweQueue queue, @Nullable FawePlayer player, @Nullable FaweLimit limit, @Nullable FaweChangeSet changeSet, @Nullable RegionWrapper[] allowedRegions, @Nullable Boolean autoQueue, @Nullable Boolean fastmode, @Nullable Boolean checkMemory, @Nullable Boolean combineStages, @Nullable BlockBag blockBag, @Nullable EventBus bus, @Nullable EditSessionEvent event) {
        this((String)null, world, queue, player, limit, changeSet, allowedRegions, autoQueue, fastmode, checkMemory, combineStages, blockBag, bus, event);
    }

    @Deprecated
    public EditSession(@Nullable String worldName, @Nullable World world, @Nullable FaweQueue queue, @Nullable FawePlayer player, @Nullable FaweLimit limit, @Nullable FaweChangeSet changeSet, @Nullable RegionWrapper[] allowedRegions, @Nullable Boolean autoQueue, @Nullable Boolean fastmode, @Nullable Boolean checkMemory, @Nullable Boolean combineStages, @Nullable BlockBag blockBag, @Nullable EventBus bus, @Nullable EditSessionEvent event) {
        this(worldName, world, queue, player, limit, changeSet, (Region[])allowedRegions, autoQueue, fastmode, checkMemory, combineStages, blockBag, bus, event);
    }

    public EditSession(@Nullable String worldName, @Nullable World world, @Nullable FaweQueue queue, @Nullable FawePlayer player, @Nullable FaweLimit limit, @Nullable FaweChangeSet changeSet, @Nullable Region[] allowedRegions, @Nullable Boolean autoQueue, @Nullable Boolean fastmode, @Nullable Boolean checkMemory, @Nullable Boolean combineStages, @Nullable BlockBag blockBag, @Nullable EventBus bus, @Nullable EditSessionEvent event) {
        super(world);
        String string = worldName == null ? (world == null ? (queue == null ? "" : queue.getWorldName()) : Fawe.imp().getWorldName(world)) : (this.worldName = worldName);
        if (world == null && this.worldName != null) {
            world = FaweAPI.getWorld(this.worldName);
        }
        this.world = world;
        if (bus == null) {
            bus = WorldEdit.getInstance().getEventBus();
        }
        if (event == null) {
            event = new EditSessionEvent(world, player == null ? null : player.getPlayer(), -1, null);
        }
        event.setEditSession(this);
        if (player == null && event.getActor() != null) {
            player = FawePlayer.wrap(event.getActor());
        }
        this.player = player;
        if (limit == null) {
            limit = player == null ? FaweLimit.MAX : player.getLimit();
        }
        if (autoQueue == null) {
            autoQueue = true;
        }
        if (fastmode == null) {
            fastmode = player == null ? Boolean.valueOf(!Settings.IMP.HISTORY.ENABLE_FOR_CONSOLE) : Boolean.valueOf(player.getSession().hasFastMode());
        }
        this.fastMode = fastmode;
        if (checkMemory == null) {
            checkMemory = player != null && !this.fastMode;
        }
        if (checkMemory.booleanValue() && MemUtil.isMemoryLimitedSlow()) {
            if (Perm.hasPermission(player, "worldedit.fast")) {
                BBC.WORLDEDIT_OOM_ADMIN.send(player, new Object[0]);
            }
            throw new FaweException(BBC.WORLDEDIT_CANCEL_REASON_LOW_MEMORY);
        }
        this.originalLimit = limit;
        this.blockBag = limit.INVENTORY_MODE != 0 ? blockBag : null;
        this.limit = limit.copy();
        if (queue == null) {
            boolean placeChunks = this.fastMode || this.limit.FAST_PLACEMENT;
            World unwrapped = WorldWrapper.unwrap(world);
            queue = unwrapped instanceof FaweQueue ? (FaweQueue)((Object)unwrapped) : (unwrapped instanceof MCAWorld ? ((MCAWorld)unwrapped).getQueue() : (player != null && world.equals(player.getWorld()) ? player.getFaweQueue(placeChunks, autoQueue) : SetQueue.IMP.getNewQueue(world, placeChunks, (boolean)autoQueue)));
        }
        if (combineStages == null) {
            combineStages = Settings.IMP.HISTORY.COMBINE_STAGES && this.limit.FAST_PLACEMENT && queue.supports(FaweQueue.Capability.CHANGE_TASKS) && this.blockBag == null;
        }
        if (Settings.IMP.EXPERIMENTAL.ANVIL_QUEUE_MODE && !(queue instanceof MCAQueue)) {
            queue = new MCAQueue(queue);
        }
        this.queue = queue;
        this.queue.addEditSession(this);
        Settings.QUEUE cfr_ignored_0 = Settings.IMP.QUEUE;
        if (!Settings.QUEUE.PROGRESS.DISPLAY.equalsIgnoreCase("false") && player != null) {
            Settings.QUEUE cfr_ignored_1 = Settings.IMP.QUEUE;
            switch (Settings.QUEUE.PROGRESS.DISPLAY.toLowerCase()) {
                case "chat": {
                    this.queue.setProgressTask(new ChatProgressTracker(player));
                    break;
                }
                default: {
                    this.queue.setProgressTask(new DefaultProgressTracker(player));
                }
            }
        }
        this.bypassAll = this.wrapExtent(new FastWorldEditExtent(world, queue), bus, event, Stage.BEFORE_CHANGE);
        this.bypassHistory = this.extent = this.wrapExtent(this.bypassAll, bus, event, Stage.BEFORE_REORDER);
        if (!this.fastMode || changeSet != null) {
            if (changeSet == null) {
                if (Settings.IMP.HISTORY.USE_DISK) {
                    UUID uuid;
                    UUID uUID = uuid = player == null ? CONSOLE : player.getUUID();
                    changeSet = Settings.IMP.HISTORY.USE_DATABASE ? new RollbackOptimizedHistory(world, uuid) : new DiskStorageHistory(world, uuid);
                } else {
                    changeSet = combineStages != false && Settings.IMP.HISTORY.COMPRESSION_LEVEL == 0 && !(queue instanceof MCAQueue) ? new CPUOptimizedChangeSet(world) : new MemoryOptimizedHistory(world);
                }
            }
            if (this.limit.SPEED_REDUCTION > 0) {
                this.bypassHistory = new SlowExtent(this.bypassHistory, this.limit.SPEED_REDUCTION);
            }
            if (changeSet instanceof NullChangeSet && Fawe.imp().getBlocksHubApi() != null && player != null) {
                changeSet = LoggingChangeSet.wrap(player, changeSet);
            }
            if (!(changeSet instanceof NullChangeSet)) {
                if (!(changeSet instanceof LoggingChangeSet) && player != null && Fawe.imp().getBlocksHubApi() != null) {
                    changeSet = LoggingChangeSet.wrap(player, changeSet);
                }
                if (this.blockBag != null) {
                    changeSet = new BlockBagChangeSet(changeSet, blockBag, limit.INVENTORY_MODE == 1);
                }
                if (combineStages.booleanValue()) {
                    this.changeTask = changeSet;
                    changeSet.addChangeTask(queue);
                } else {
                    this.history = new HistoryExtent(this, this.bypassHistory, changeSet, queue);
                    this.extent = this.history;
                }
            }
        }
        if (!(allowedRegions != null || player == null || player.hasPermission("fawe.bypass") || player.hasPermission("fawe.bypass.regions") || queue instanceof VirtualWorld)) {
            allowedRegions = player.getCurrentRegions();
        }
        int n = this.maxY = this.getWorld() == null ? 255 : world.getMaxY();
        if (allowedRegions != null) {
            if (allowedRegions.length == 0) {
                this.extent = new NullExtent((Extent)this.extent, BBC.WORLDEDIT_CANCEL_REASON_NO_REGION);
            } else {
                this.extent = new ProcessedWEExtent(this.extent, this.limit);
                if (allowedRegions.length == 1) {
                    Region region = allowedRegions[0];
                    this.extent = new SingleRegionExtent(this.extent, this.limit, allowedRegions[0]);
                } else {
                    this.extent = new MultiRegionExtent(this.extent, this.limit, allowedRegions);
                }
            }
        } else {
            this.extent = new HeightBoundExtent(this.extent, this.limit, 0, this.maxY);
        }
        if (this.limit.STRIP_NBT != null && !this.limit.STRIP_NBT.isEmpty()) {
            this.extent = new StripNBTExtent(this.extent, this.limit.STRIP_NBT);
        }
        this.extent = this.wrapExtent(this.extent, bus, event, Stage.BEFORE_HISTORY);
        this.setExtent(this.extent);
    }

    @Deprecated
    public EditSession(World world, int maxBlocks) {
        this(world, maxBlocks, null);
    }

    @Deprecated
    public EditSession(World world, int maxBlocks, @Nullable BlockBag blockBag) {
        this(WorldEdit.getInstance().getEventBus(), world, maxBlocks, blockBag, new EditSessionEvent(world, null, maxBlocks, null));
    }

    public EditSession(EventBus eventBus, World world, int maxBlocks, @Nullable BlockBag blockBag, EditSessionEvent event) {
        this(world, null, null, null, null, null, true, null, null, null, blockBag, eventBus, event);
    }

    public FaweLimit getLimit() {
        return this.originalLimit;
    }

    public void resetLimit() {
        this.limit.set(this.originalLimit);
        ExtentTraverser<ProcessedWEExtent> find = new ExtentTraverser<AbstractDelegateExtent>(this.extent).find(ProcessedWEExtent.class);
        if (find != null && find.get() != null) {
            find.get().setLimit(this.limit);
        }
    }

    public FaweLimit getLimitUsed() {
        FaweLimit newLimit = new FaweLimit();
        newLimit.MAX_ACTIONS = this.originalLimit.MAX_ACTIONS - this.limit.MAX_ACTIONS;
        newLimit.MAX_CHANGES = this.originalLimit.MAX_CHANGES - this.limit.MAX_CHANGES;
        newLimit.MAX_FAILS = this.originalLimit.MAX_FAILS - this.limit.MAX_FAILS;
        newLimit.MAX_CHECKS = this.originalLimit.MAX_CHECKS - this.limit.MAX_CHECKS;
        newLimit.MAX_ITERATIONS = this.originalLimit.MAX_ITERATIONS - this.limit.MAX_ITERATIONS;
        newLimit.MAX_BLOCKSTATES = this.originalLimit.MAX_BLOCKSTATES - this.limit.MAX_BLOCKSTATES;
        newLimit.MAX_ENTITIES = this.originalLimit.MAX_ENTITIES - this.limit.MAX_ENTITIES;
        newLimit.MAX_HISTORY = this.limit.MAX_HISTORY;
        return newLimit;
    }

    public FaweLimit getLimitLeft() {
        return this.limit;
    }

    public FaweRegionExtent getRegionExtent() {
        ExtentTraverser<FaweRegionExtent> traverser = new ExtentTraverser<AbstractDelegateExtent>(this.extent).find(FaweRegionExtent.class);
        return traverser == null ? null : traverser.get();
    }

    public Extent getBypassAll() {
        return this.bypassAll;
    }

    public Extent getBypassHistory() {
        return this.bypassHistory;
    }

    @Override
    public Extent getExtent() {
        return this.extent;
    }

    public void setExtent(AbstractDelegateExtent extent) {
        this.extent = extent;
        new ExtentTraverser<EditSession>(this).setNext((EditSession)extent);
    }

    @Nullable
    public FawePlayer getPlayer() {
        return this.player;
    }

    public boolean cancel() {
        ExtentTraverser<AbstractDelegateExtent> traverser = new ExtentTraverser<AbstractDelegateExtent>(this.extent);
        NullExtent nullExtent = new NullExtent((Extent)this.world, BBC.WORLDEDIT_CANCEL_REASON_MANUAL);
        while (traverser != null) {
            ExtentTraverser<AbstractDelegateExtent> next = traverser.next();
            AbstractDelegateExtent get = traverser.get();
            if (get instanceof AbstractDelegateExtent && !(get instanceof NullExtent)) {
                traverser.setNext(nullExtent);
            }
            traverser = next;
        }
        this.bypassHistory = nullExtent;
        this.extent = nullExtent;
        this.bypassAll = nullExtent;
        this.dequeue();
        this.queue.clear();
        return true;
    }

    public void dequeue() {
        if (this.queue != null) {
            SetQueue.IMP.dequeue(this.queue);
        }
    }

    public void addNotifyTask(Runnable whenDone) {
        if (this.queue != null) {
            this.queue.addNotifyTask(whenDone);
        }
    }

    public void debug(BBC message, Object ... args) {
        message.send(this.player, args);
    }

    @Override
    public FaweQueue getQueue() {
        return this.queue;
    }

    @Deprecated
    private AbstractDelegateExtent wrapExtent(AbstractDelegateExtent extent, EventBus eventBus, EditSessionEvent event, Stage stage) {
        event = event.clone(stage);
        event.setExtent(extent);
        eventBus.post(event);
        if (event.isCancelled()) {
            return new NullExtent((Extent)extent, BBC.WORLDEDIT_CANCEL_REASON_MANUAL);
        }
        Extent toReturn = event.getExtent();
        if (!(toReturn instanceof AbstractDelegateExtent)) {
            Fawe.debug("Extent " + toReturn + " must be AbstractDelegateExtent");
            return extent;
        }
        if (toReturn != extent) {
            String className = toReturn.getClass().getName().toLowerCase();
            for (String allowed : Settings.IMP.EXTENT.ALLOWED_PLUGINS) {
                if (!className.contains(allowed.toLowerCase())) continue;
                this.wrapped = true;
                return (AbstractDelegateExtent)toReturn;
            }
            if (Settings.IMP.EXTENT.DEBUG) {
                Fawe.debug("&cPotentially unsafe extent blocked: " + toReturn.getClass().getName());
                Fawe.debug("&8 - &7For area restrictions, it is recommended to use the FaweAPI");
                Fawe.debug("&8 - &7For block logging, it is recommended to use use BlocksHub");
                Fawe.debug("&8 - &7To allow this plugin add it to the FAWE `allowed-plugins` list");
                Fawe.debug("&8 - &7To hide this message set `debug` to false in the FAWE config.yml");
                if (toReturn.getClass().getName().contains("CoreProtect")) {
                    Fawe.debug("Note on CoreProtect: ");
                    Fawe.debug(" - If you disable CP's WE logger (CP config) and this still shows, please update CP");
                    Fawe.debug(" - Use BlocksHub and set `debug` false in the FAWE config");
                }
            }
        }
        return extent;
    }

    public World getWorld() {
        return this.world;
    }

    public ChangeSet getChangeSet() {
        return this.changeTask != null ? this.changeTask : (this.history != null ? this.history.getChangeSet() : null);
    }

    public FaweChangeSet getChangeTask() {
        return this.changeTask;
    }

    public void setRawChangeSet(@Nullable FaweChangeSet set) {
        this.changeTask = set;
        ++this.changes;
    }

    public void setChangeSet(@Nullable FaweChangeSet set) {
        if (set == null) {
            this.disableHistory(true);
        } else if (this.history != null) {
            this.history.setChangeSet(set);
        } else {
            this.changeTask = set;
            set.addChangeTask(this.queue);
        }
        ++this.changes;
    }

    @Deprecated
    public int getBlockChangeLimit() {
        return this.originalLimit.MAX_CHANGES;
    }

    public void setBlockChangeLimit(int limit) {
    }

    public boolean isQueueEnabled() {
        return true;
    }

    public void enableQueue() {
    }

    public void disableQueue() {
        if (this.isQueueEnabled()) {
            this.flushQueue();
        }
    }

    public Mask getMask() {
        ExtentTraverser<MaskingExtent> maskingExtent = new ExtentTraverser<AbstractDelegateExtent>(this.extent).find(MaskingExtent.class);
        return maskingExtent != null ? maskingExtent.get().getMask() : null;
    }

    public Mask getSourceMask() {
        ExtentTraverser<SourceMaskExtent> maskingExtent = new ExtentTraverser<AbstractDelegateExtent>(this.extent).find(SourceMaskExtent.class);
        return maskingExtent != null ? maskingExtent.get().getMask() : null;
    }

    public void addTransform(ResettableExtent transform) {
        this.wrapped = true;
        if (transform == null) {
            AbstractDelegateExtent next = this.extent;
            for (ExtentTraverser<ResettableExtent> traverser = new ExtentTraverser<AbstractDelegateExtent>(this.extent).find(ResettableExtent.class); traverser != null && traverser.get() instanceof ResettableExtent; traverser = traverser.next()) {
                next = traverser.get();
            }
            this.extent = next;
            return;
        }
        this.extent = transform.setExtent(this.extent);
    }

    @Nullable
    public ResettableExtent getTransform() {
        ExtentTraverser<ResettableExtent> traverser = new ExtentTraverser<AbstractDelegateExtent>(this.extent).find(ResettableExtent.class);
        if (traverser != null) {
            return traverser.get();
        }
        return null;
    }

    public void setSourceMask(Mask mask) {
        if (mask == null) {
            mask = Masks.alwaysTrue();
        } else {
            new MaskTraverser(mask).reset(this);
        }
        ExtentTraverser<SourceMaskExtent> maskingExtent = new ExtentTraverser<AbstractDelegateExtent>(this.extent).find(SourceMaskExtent.class);
        if (maskingExtent != null && maskingExtent.get() != null) {
            Mask oldMask = maskingExtent.get().getMask();
            if (oldMask instanceof ResettableMask) {
                ((ResettableMask)((Object)oldMask)).reset();
            }
            maskingExtent.get().setMask(mask);
        } else if (mask != Masks.alwaysTrue()) {
            this.extent = new SourceMaskExtent(this.extent, mask);
        }
    }

    public void addSourceMask(Mask mask) {
        Preconditions.checkNotNull((Object)mask);
        Mask existing = this.getSourceMask();
        if (existing != null) {
            if (existing instanceof MaskIntersection) {
                ((MaskIntersection)existing).add(mask);
                return;
            }
            MaskIntersection intersection = new MaskIntersection(existing);
            intersection.add(mask);
            mask = intersection;
        }
        this.setSourceMask(mask);
    }

    public void setMask(Mask mask) {
        if (mask == null) {
            mask = Masks.alwaysTrue();
        } else {
            new MaskTraverser(mask).reset(this);
        }
        ExtentTraverser<MaskingExtent> maskingExtent = new ExtentTraverser<AbstractDelegateExtent>(this.extent).find(MaskingExtent.class);
        if (maskingExtent != null && maskingExtent.get() != null) {
            Mask oldMask = maskingExtent.get().getMask();
            if (oldMask instanceof ResettableMask) {
                ((ResettableMask)((Object)oldMask)).reset();
            }
            maskingExtent.get().setMask(mask);
        } else if (mask != Masks.alwaysTrue()) {
            this.extent = new MaskingExtent(this.extent, mask);
        }
    }

    public SurvivalModeExtent getSurvivalExtent() {
        ExtentTraverser<SurvivalModeExtent> survivalExtent = new ExtentTraverser<AbstractDelegateExtent>(this.extent).find(SurvivalModeExtent.class);
        if (survivalExtent != null) {
            return survivalExtent.get();
        }
        AbstractDelegateExtent extent = this.extent;
        SurvivalModeExtent survival = new SurvivalModeExtent(extent.getExtent(), this.getWorld());
        new ExtentTraverser<AbstractDelegateExtent>(extent).setNext(survival);
        return survival;
    }

    public void setFastMode(boolean enabled) {
        this.fastMode = enabled;
        this.disableHistory(enabled);
    }

    public void disableHistory(boolean disableHistory) {
        ExtentTraverser traverseBypass;
        if (this.history == null) {
            return;
        }
        ExtentTraverser<HistoryExtent> traverseHistory = new ExtentTraverser<AbstractDelegateExtent>(this.extent).find(HistoryExtent.class);
        if (disableHistory) {
            if (traverseHistory != null && traverseHistory.exists()) {
                ExtentTraverser<HistoryExtent> beforeHistory = traverseHistory.previous();
                ExtentTraverser<HistoryExtent> afterHistory = traverseHistory.next();
                if (beforeHistory != null && beforeHistory.exists()) {
                    beforeHistory.setNext(afterHistory.get());
                } else {
                    this.extent = afterHistory.get();
                }
            }
        } else if (!(traverseHistory != null && traverseHistory.exists() || (traverseBypass = new ExtentTraverser<AbstractDelegateExtent>(this.extent).find(this.bypassHistory)) == null)) {
            ExtentTraverser beforeHistory = traverseBypass.previous();
            beforeHistory.setNext(this.history);
        }
    }

    public boolean hasFastMode() {
        return this.getChangeSet() == null;
    }

    public BlockBag getBlockBag() {
        return this.blockBag;
    }

    public void setBlockBag(BlockBag blockBag) {
        this.blockBag = blockBag;
    }

    @Override
    public String toString() {
        return super.toString() + ":" + this.extent;
    }

    public Map<BlockType, Integer> popMissingBlocks() {
        BlockBag bag = this.getBlockBag();
        if (bag != null) {
            ExtentTraverser<BlockBagExtent> find;
            bag.flushChanges();
            ChangeSet changeSet = this.getChangeSet();
            Map<BlockType, Integer> missingBlocks = changeSet instanceof BlockBagChangeSet ? ((BlockBagChangeSet)changeSet).popMissing() : ((find = new ExtentTraverser<AbstractDelegateExtent>(this.extent).find(BlockBagExtent.class)) != null && find.get() != null ? find.get().popMissing() : null);
            if (missingBlocks != null && !missingBlocks.isEmpty()) {
                StringBuilder str = new StringBuilder();
                int size = missingBlocks.size();
                int i = 0;
                for (Map.Entry<BlockType, Integer> entry : missingBlocks.entrySet()) {
                    BlockType type = entry.getKey();
                    int amount = entry.getValue();
                    str.append(type.getName()).append(amount != 1 ? "x" + amount : "");
                    if (++i == size) continue;
                    str.append(", ");
                }
                BBC.WORLDEDIT_SOME_FAILS_BLOCKBAG.send(this.player, str.toString());
            }
        }
        return new HashMap<BlockType, Integer>();
    }

    public int getBlockChangeCount() {
        return this.changes;
    }

    @Override
    public BaseBiome getBiome(Vector2D position) {
        return this.extent.getBiome(position);
    }

    @Override
    public boolean setBiome(Vector2D position, BaseBiome biome) {
        ++this.changes;
        return this.extent.setBiome(position, biome);
    }

    @Override
    public boolean setBiome(int x, int y, int z, BaseBiome biome) {
        ++this.changes;
        return this.extent.setBiome(x, y, z, biome);
    }

    @Override
    public int getLight(int x, int y, int z) {
        return this.queue.getLight(x, y, z);
    }

    @Override
    public int getBlockLight(int x, int y, int z) {
        return this.queue.getEmmittedLight(x, y, z);
    }

    @Override
    public int getSkyLight(int x, int y, int z) {
        return this.queue.getSkyLight(x, y, z);
    }

    @Override
    public int getBrightness(int x, int y, int z) {
        return this.queue.getBrightness(x, y, z);
    }

    @Override
    public int getOpacity(int x, int y, int z) {
        return this.queue.getOpacity(x, y, z);
    }

    @Override
    public BlockState getLazyBlock(Vector position) {
        return this.getLazyBlock(position.getBlockX(), position.getBlockY(), position.getBlockZ());
    }

    @Override
    public BlockState getLazyBlock(int x, int y, int z) {
        return this.extent.getLazyBlock(x, y, z);
    }

    public BlockState getBlock(int x, int y, int z) {
        return this.getLazyBlock(x, y, z);
    }

    @Override
    public BlockState getBlock(Vector position) {
        return this.getLazyBlock(position.getBlockX(), position.getBlockY(), position.getBlockZ());
    }

    @Override
    @Deprecated
    public BlockType getBlockType(Vector position) {
        return this.getBlockType(position.getBlockX(), position.getBlockY(), position.getBlockZ());
    }

    public BlockType getBlockType(int x, int y, int z) {
        if (!this.limit.MAX_CHECKS()) {
            throw new FaweException(BBC.WORLDEDIT_CANCEL_REASON_MAX_CHECKS);
        }
        int combinedId4Data = this.queue.getCombinedId4DataDebug(x, y, z, BlockTypes.AIR.getInternalId(), this);
        return BlockTypes.getFromStateId(combinedId4Data);
    }

    public boolean setBlock(Vector position, BaseBlock block, Stage stage) throws WorldEditException {
        ++this.changes;
        switch (stage) {
            case BEFORE_HISTORY: {
                return this.extent.setBlock(position, block);
            }
            case BEFORE_CHANGE: {
                return this.bypassHistory.setBlock(position, block);
            }
            case BEFORE_REORDER: {
                return this.bypassAll.setBlock(position, block);
            }
        }
        throw new RuntimeException("New enum entry added that is unhandled here");
    }

    public boolean smartSetBlock(Vector position, BlockStateHolder block) {
        ++this.changes;
        try {
            return this.bypassAll.setBlock(position, block);
        }
        catch (WorldEditException e) {
            throw new RuntimeException("Unexpected exception", e);
        }
    }

    @Override
    public boolean setBlock(Vector position, BlockStateHolder block) throws MaxChangedBlocksException {
        ++this.changes;
        try {
            return this.extent.setBlock(position, block);
        }
        catch (MaxChangedBlocksException e) {
            throw e;
        }
        catch (WorldEditException e) {
            throw new RuntimeException("Unexpected exception", e);
        }
    }

    @Override
    public boolean setBlock(int x, int y, int z, BlockStateHolder block) {
        ++this.changes;
        try {
            return this.extent.setBlock(x, y, z, block);
        }
        catch (WorldEditException e) {
            throw new RuntimeException("Unexpected exception", e);
        }
    }

    public boolean setBlock(int x, int y, int z, com.sk89q.worldedit.function.pattern.Pattern pattern) {
        ++this.changes;
        try {
            this.mutable.setComponents(x, y, z);
            return pattern.apply(this.extent, this.mutable, this.mutable);
        }
        catch (WorldEditException e) {
            throw new RuntimeException("Unexpected exception", e);
        }
    }

    @Deprecated
    public boolean setBlock(int x, int y, int z, Pattern pattern) {
        return this.setBlock(x, y, z, (com.sk89q.worldedit.function.pattern.Pattern)pattern);
    }

    @Deprecated
    public boolean setBlock(Vector position, Pattern pattern) {
        return this.setBlock(position, (com.sk89q.worldedit.function.pattern.Pattern)pattern);
    }

    @Deprecated
    public boolean setBlock(int x, int y, int z, BaseBlock block) {
        return this.setBlock(x, y, z, (BlockStateHolder)block);
    }

    @Deprecated
    public boolean setBlock(Vector position, BaseBlock block) throws MaxChangedBlocksException {
        return this.setBlock(position, (BlockStateHolder)block);
    }

    public boolean setBlock(Vector position, com.sk89q.worldedit.function.pattern.Pattern pattern) {
        ++this.changes;
        try {
            return pattern.apply(this.extent, position, position);
        }
        catch (WorldEditException e) {
            throw new RuntimeException(e);
        }
    }

    public int setBlocks(Set<Vector> vset, com.sk89q.worldedit.function.pattern.Pattern pattern) {
        RegionVisitor visitor = new RegionVisitor(vset, (RegionFunction)new BlockReplace(this.extent, pattern), (HasFaweQueue)this);
        Operations.completeBlindly(visitor);
        this.changes += visitor.getAffected();
        return this.changes;
    }

    public boolean setChanceBlockIfAir(Vector position, BaseBlock block, double probability) throws MaxChangedBlocksException {
        return (double)ThreadLocalRandom.current().nextInt(65536) <= probability * 65536.0 && this.setBlockIfAir(position, block);
    }

    @Deprecated
    public boolean setBlockIfAir(Vector position, BlockStateHolder block) throws MaxChangedBlocksException {
        return this.getBlock(position).getBlockType().getMaterial().isAir() && this.setBlock(position, block);
    }

    @Override
    @Nullable
    public Entity createEntity(Location location, BaseEntity entity) {
        Entity result = this.extent.createEntity(location, entity);
        return result;
    }

    @Deprecated
    public void rememberChange(Vector position, BaseBlock existing, BaseBlock block) {
        ChangeSet changeSet = this.getChangeSet();
        if (changeSet != null) {
            changeSet.add(new BlockChange(position.toBlockVector(), existing, block));
        }
    }

    public void undo(EditSession editSession) {
        UndoContext context = new UndoContext();
        context.setExtent(editSession.bypassAll);
        ChangeSet changeSet = this.getChangeSet();
        editSession.getQueue().setChangeTask(null);
        Operations.completeBlindly(ChangeSetExecutor.create(changeSet, context, ChangeSetExecutor.Type.UNDO, editSession.getBlockBag(), editSession.getLimit().INVENTORY_MODE));
        this.flushQueue();
        editSession.changes = 1;
    }

    public void setBlocks(ChangeSet changeSet, ChangeSetExecutor.Type type) {
        UndoContext context = new UndoContext();
        AbstractDelegateExtent bypass = this.history == null ? this.bypassAll : this.history;
        context.setExtent(bypass);
        Operations.completeBlindly(ChangeSetExecutor.create(changeSet, context, type, this.getBlockBag(), this.getLimit().INVENTORY_MODE));
        this.flushQueue();
        this.changes = 1;
    }

    public void redo(EditSession editSession) {
        UndoContext context = new UndoContext();
        context.setExtent(editSession.bypassAll);
        ChangeSet changeSet = this.getChangeSet();
        editSession.getQueue().setChangeTask(null);
        Operations.completeBlindly(ChangeSetExecutor.create(changeSet, context, ChangeSetExecutor.Type.REDO, editSession.getBlockBag(), editSession.getLimit().INVENTORY_MODE));
        this.flushQueue();
        editSession.changes = 1;
    }

    public int size() {
        return this.getBlockChangeCount();
    }

    public void setSize(int size) {
        this.changes = size;
    }

    @Override
    public Vector getMinimumPoint() {
        if (this.extent != null) {
            return this.extent.getMinimumPoint();
        }
        return new Vector(-30000000, 0, -30000000);
    }

    @Override
    public Vector getMaximumPoint() {
        if (this.extent != null) {
            return this.extent.getMaximumPoint();
        }
        return new Vector(30000000, 255, 30000000);
    }

    @Override
    public List<? extends Entity> getEntities(Region region) {
        return this.extent.getEntities(region);
    }

    @Override
    public List<? extends Entity> getEntities() {
        return this.extent.getEntities();
    }

    public void flushQueue() {
        Operations.completeBlindly(this.commit());
        FaweLimit used = this.getLimitUsed();
        if (used.MAX_FAILS > 0) {
            if (used.MAX_CHANGES > 0 || used.MAX_ENTITIES > 0) {
                BBC.WORLDEDIT_SOME_FAILS.send(this.player, used.MAX_FAILS);
            } else if (new ExtentTraverser<EditSession>(this).findAndGet(FaweRegionExtent.class) != null) {
                BBC.WORLDEDIT_CANCEL_REASON_OUTSIDE_REGION.send(this.player, new Object[0]);
            } else {
                BBC.WORLDEDIT_CANCEL_REASON_OUTSIDE_LEVEL.send(this.player, new Object[0]);
            }
        }
        this.limit.set(this.originalLimit);
        if (this.queue == null || this.queue.isEmpty()) {
            this.queue.dequeue();
            return;
        }
        if (Fawe.isMainThread()) {
            SetQueue.IMP.flush(this.queue);
        } else {
            this.queue.flush();
        }
        if (this.getChangeSet() != null) {
            if (Settings.IMP.HISTORY.COMBINE_STAGES) {
                ((FaweChangeSet)this.getChangeSet()).closeAsync();
            } else {
                ((FaweChangeSet)this.getChangeSet()).close();
            }
        }
    }

    public int countBlock(Region region, Set<BlockType> searchIDs) {
        if (searchIDs.isEmpty()) {
            return 0;
        }
        if (searchIDs.size() == 1) {
            final BlockType id = searchIDs.iterator().next();
            RegionVisitor visitor = new RegionVisitor(region, new RegionFunction(){

                @Override
                public boolean apply(Vector position) throws WorldEditException {
                    return EditSession.this.getBlockType(position) == id;
                }
            }, this);
            Operations.completeBlindly(visitor);
            return visitor.getAffected();
        }
        boolean[] ids = new boolean[BlockTypes.size()];
        for (BlockType id : searchIDs) {
            ids[id.getInternalId()] = true;
        }
        return this.countBlock(region, ids);
    }

    public int countBlock(Region region, final boolean[] ids) {
        RegionVisitor visitor = new RegionVisitor(region, new RegionFunction(){

            @Override
            public boolean apply(Vector position) throws WorldEditException {
                return ids[EditSession.this.getBlockType(position).getInternalId()];
            }
        }, this);
        Operations.completeBlindly(visitor);
        return visitor.getAffected();
    }

    public int countBlock(Region region, final Mask mask) {
        RegionVisitor visitor = new RegionVisitor(region, new RegionFunction(){

            @Override
            public boolean apply(Vector position) throws WorldEditException {
                return mask.test(position);
            }
        }, this);
        Operations.completeBlindly(visitor);
        return visitor.getAffected();
    }

    public int countBlocks(Region region, Set<BlockStateHolder> searchBlocks) {
        final BlockMask mask = new BlockMaskBuilder().addBlocks(searchBlocks).build(this.extent);
        RegionVisitor visitor = new RegionVisitor(region, new RegionFunction(){

            @Override
            public boolean apply(Vector position) throws WorldEditException {
                return mask.test(position);
            }
        }, this);
        Operations.completeBlindly(visitor);
        return visitor.getAffected();
    }

    public int fall(Region region, boolean fullHeight, final BlockStateHolder replace) {
        FlatRegion flat = Regions.asFlatRegion(region);
        final int startPerformY = region.getMinimumPoint().getBlockY();
        final int startCheckY = fullHeight ? 0 : startPerformY;
        final int endY = region.getMaximumPoint().getBlockY();
        RegionVisitor visitor = new RegionVisitor((Region)flat, new RegionFunction(){

            @Override
            public boolean apply(Vector pos) throws WorldEditException {
                int x = pos.getBlockX();
                int z = pos.getBlockZ();
                int freeSpot = startCheckY;
                for (int y = startCheckY; y <= endY; ++y) {
                    if (y < startPerformY) {
                        if (EditSession.this.getBlockType(x, y, z).getMaterial().isAir()) continue;
                        freeSpot = y + 1;
                        continue;
                    }
                    BlockType block = EditSession.this.getBlockType(x, y, z);
                    if (block.getMaterial().isAir()) continue;
                    if (freeSpot != y) {
                        EditSession.this.setBlock(x, freeSpot, z, block);
                        EditSession.this.setBlock(x, y, z, replace);
                    }
                    ++freeSpot;
                }
                return true;
            }
        }, this);
        Operations.completeBlindly(visitor);
        return this.changes;
    }

    public int fillDirection(Vector origin, com.sk89q.worldedit.function.pattern.Pattern pattern, double radius, int depth, Vector direction) {
        Preconditions.checkNotNull((Object)origin);
        Preconditions.checkNotNull((Object)pattern);
        Preconditions.checkArgument((radius >= 0.0 ? 1 : 0) != 0, (Object)"radius >= 0");
        Preconditions.checkArgument((depth >= 1 ? 1 : 0) != 0, (Object)"depth >= 1");
        if (direction.equals(new Vector(0, -1, 0))) {
            return this.fillXZ(origin, pattern, radius, depth, false);
        }
        MaskIntersection mask = new MaskIntersection(new RegionMask(new EllipsoidRegion(null, origin, new Vector(radius, radius, radius))), Masks.negate(new ExistingBlockMask(this)));
        BlockReplace replace = new BlockReplace(this, pattern);
        DirectionalVisitor visitor = new DirectionalVisitor(mask, replace, origin, direction, (int)(radius * 2.0 + 1.0), this);
        visitor.visit(origin);
        Operations.completeBlindly(visitor);
        this.changes = visitor.getAffected();
        return this.changes;
    }

    public int fillXZ(Vector origin, BaseBlock block, double radius, int depth, boolean recursive) {
        return this.fillXZ(origin, (com.sk89q.worldedit.function.pattern.Pattern)block, radius, depth, recursive);
    }

    public int fillXZ(Vector origin, com.sk89q.worldedit.function.pattern.Pattern pattern, double radius, int depth, boolean recursive) {
        Preconditions.checkNotNull((Object)origin);
        Preconditions.checkNotNull((Object)pattern);
        Preconditions.checkArgument((radius >= 0.0 ? 1 : 0) != 0, (Object)"radius >= 0");
        Preconditions.checkArgument((depth >= 1 ? 1 : 0) != 0, (Object)"depth >= 1");
        MaskIntersection mask = new MaskIntersection(new RegionMask(new EllipsoidRegion(null, origin, new Vector(radius, radius, radius))), new BoundedHeightMask(Math.max(origin.getBlockY() - depth + 1, this.getMinimumPoint().getBlockY()), Math.min(this.getMaximumPoint().getBlockY(), origin.getBlockY())), Masks.negate(new ExistingBlockMask(this)));
        BlockReplace replace = new BlockReplace(this, pattern);
        RecursiveVisitor visitor = recursive ? new RecursiveVisitor(mask, replace, (int)(radius * 2.0 + 1.0), this) : new DownwardVisitor(mask, replace, origin.getBlockY(), (int)(radius * 2.0 + 1.0), this);
        visitor.visit(origin);
        Operations.completeBlindly(visitor);
        this.changes = visitor.getAffected();
        return this.changes;
    }

    public int removeAbove(Vector position, int apothem, int height) {
        Preconditions.checkNotNull((Object)position);
        Preconditions.checkArgument((apothem >= 1 ? 1 : 0) != 0, (Object)"apothem >= 1");
        Preconditions.checkArgument((height >= 1 ? 1 : 0) != 0, (Object)"height >= 1");
        CuboidRegion region = new CuboidRegion(this.getWorld(), position.add(-apothem + 1, 0, -apothem + 1), position.add(apothem - 1, height - 1, apothem - 1));
        BlockState pattern = BlockTypes.AIR.getDefaultState();
        return this.setBlocks((Region)region, (com.sk89q.worldedit.function.pattern.Pattern)pattern);
    }

    public int removeBelow(Vector position, int apothem, int height) {
        Preconditions.checkNotNull((Object)position);
        Preconditions.checkArgument((apothem >= 1 ? 1 : 0) != 0, (Object)"apothem >= 1");
        Preconditions.checkArgument((height >= 1 ? 1 : 0) != 0, (Object)"height >= 1");
        CuboidRegion region = new CuboidRegion(this.getWorld(), position.add(-apothem + 1, 0, -apothem + 1), position.add(apothem - 1, -height + 1, apothem - 1));
        BlockState pattern = BlockTypes.AIR.getDefaultState();
        return this.setBlocks((Region)region, (com.sk89q.worldedit.function.pattern.Pattern)pattern);
    }

    public int removeNear(Vector position, Mask mask, int apothem) {
        Preconditions.checkNotNull((Object)position);
        Preconditions.checkArgument((apothem >= 1 ? 1 : 0) != 0, (Object)"apothem >= 1");
        Vector adjustment = new Vector(1, 1, 1).multiply(apothem - 1);
        CuboidRegion region = new CuboidRegion(this.getWorld(), position.add(adjustment.multiply(-1)), position.add(adjustment));
        BlockState pattern = BlockTypes.AIR.getDefaultState();
        return this.replaceBlocks((Region)region, mask, (com.sk89q.worldedit.function.pattern.Pattern)pattern);
    }

    public boolean canBypassAll(Region region, boolean get, boolean set) {
        if (this.wrapped) {
            return false;
        }
        if (this.history != null) {
            return false;
        }
        FaweRegionExtent regionExtent = this.getRegionExtent();
        if (!(region instanceof CuboidRegion)) {
            return false;
        }
        if (regionExtent != null) {
            if (!(region instanceof CuboidRegion)) {
                return false;
            }
            Vector pos1 = region.getMinimumPoint();
            Vector pos2 = region.getMaximumPoint();
            boolean contains = false;
            for (Region current : regionExtent.getRegions()) {
                if (!current.contains((int)pos1.getX(), pos1.getBlockY(), pos1.getBlockZ()) || !current.contains(pos2.getBlockX(), pos2.getBlockY(), pos2.getBlockZ())) continue;
                contains = true;
                break;
            }
            if (!contains) {
                return false;
            }
        }
        long area = region.getArea();
        FaweLimit left = this.getLimitLeft();
        if (!left.isUnlimited() && ((get || this.getChangeTask() != null) && (long)left.MAX_CHECKS <= area || set && (long)left.MAX_CHANGES <= area)) {
            return false;
        }
        if (this.getChangeTask() != this.getChangeSet()) {
            return false;
        }
        if (!Masks.isNull(this.getMask()) || !Masks.isNull(this.getSourceMask())) {
            return false;
        }
        return this.getBlockBag() == null;
    }

    public boolean hasExtraExtents() {
        return this.wrapped || this.getMask() != null || this.getSourceMask() != null || this.history != null;
    }

    public int setBlocks(Region region, BlockStateHolder block) {
        Preconditions.checkNotNull((Object)region);
        Preconditions.checkNotNull((Object)block);
        if (this.canBypassAll(region, false, true) && !block.hasNbtData()) {
            this.changes = this.queue.setBlocks((CuboidRegion)region, block.getInternalId());
            return this.changes;
        }
        try {
            if (this.hasExtraExtents()) {
                RegionVisitor visitor = new RegionVisitor(region, (RegionFunction)new BlockReplace(this.extent, block), this);
                Operations.completeBlindly(visitor);
                this.changes += visitor.getAffected();
            } else {
                Iterator iter = region.iterator();
                while (iter.hasNext()) {
                    if (!this.extent.setBlock((Vector)iter.next(), block)) continue;
                    ++this.changes;
                }
            }
        }
        catch (WorldEditException e) {
            throw new RuntimeException("Unexpected exception", e);
        }
        return this.changes;
    }

    public int setBlocks(Region region, com.sk89q.worldedit.function.pattern.Pattern pattern) {
        Preconditions.checkNotNull((Object)region);
        Preconditions.checkNotNull((Object)pattern);
        if (pattern instanceof BlockPattern) {
            return this.setBlocks(region, ((BlockPattern)pattern).getBlock());
        }
        if (pattern instanceof BlockStateHolder) {
            return this.setBlocks(region, (BlockStateHolder)pattern);
        }
        BlockReplace replace = new BlockReplace(this, pattern);
        RegionVisitor visitor = new RegionVisitor(region, (RegionFunction)replace, this.queue instanceof MappedFaweQueue ? (MappedFaweQueue)this.queue : null);
        Operations.completeBlindly(visitor);
        this.changes = visitor.getAffected();
        return this.changes;
    }

    public int replaceBlocks(Region region, Set<BlockStateHolder> filter, BlockStateHolder replacement) throws MaxChangedBlocksException {
        return this.replaceBlocks(region, filter, (com.sk89q.worldedit.function.pattern.Pattern)new BlockPattern(replacement));
    }

    public int replaceBlocks(Region region, Set<BlockStateHolder> filter, com.sk89q.worldedit.function.pattern.Pattern pattern) throws MaxChangedBlocksException {
        ExistingBlockMask mask = filter == null ? new ExistingBlockMask(this) : new BlockMaskBuilder().addBlocks(filter).build(this);
        return this.replaceBlocks(region, mask, pattern);
    }

    public int replaceBlocks(Region region, Mask mask, com.sk89q.worldedit.function.pattern.Pattern pattern) {
        Preconditions.checkNotNull((Object)region);
        Preconditions.checkNotNull((Object)mask);
        Preconditions.checkNotNull((Object)pattern);
        BlockReplace replace = new BlockReplace(this, pattern);
        RegionMaskingFilter filter = new RegionMaskingFilter(mask, replace);
        RegionVisitor visitor = new RegionVisitor(region, (RegionFunction)filter, this.queue instanceof MappedFaweQueue ? (MappedFaweQueue)this.queue : null);
        Operations.completeBlindly(visitor);
        this.changes = visitor.getAffected();
        return this.changes;
    }

    public int center(Region region, com.sk89q.worldedit.function.pattern.Pattern pattern) {
        Preconditions.checkNotNull((Object)region);
        Preconditions.checkNotNull((Object)pattern);
        Vector center = region.getCenter();
        CuboidRegion centerRegion = new CuboidRegion(this.getWorld(), center.floor(), center.ceil());
        return this.setBlocks((Region)centerRegion, pattern);
    }

    public int makeCuboidFaces(Region region, BlockStateHolder block) {
        return this.makeCuboidFaces(region, (com.sk89q.worldedit.function.pattern.Pattern)block);
    }

    public int makeCuboidFaces(Region region, com.sk89q.worldedit.function.pattern.Pattern pattern) {
        Preconditions.checkNotNull((Object)region);
        Preconditions.checkNotNull((Object)pattern);
        CuboidRegion cuboid = CuboidRegion.makeCuboid(region);
        Region faces = cuboid.getFaces();
        return this.setBlocks(faces, pattern);
    }

    public int makeFaces(Region region, com.sk89q.worldedit.function.pattern.Pattern pattern) throws WorldEditException {
        Preconditions.checkNotNull((Object)region);
        Preconditions.checkNotNull((Object)pattern);
        if (region instanceof CuboidRegion) {
            return this.makeCuboidFaces(region, pattern);
        }
        return new RegionShape(region).generate(this, pattern, true);
    }

    public int makeCuboidWalls(Region region, BlockStateHolder block) {
        return this.makeCuboidWalls(region, (com.sk89q.worldedit.function.pattern.Pattern)block);
    }

    public int makeCuboidWalls(Region region, com.sk89q.worldedit.function.pattern.Pattern pattern) {
        Preconditions.checkNotNull((Object)region);
        Preconditions.checkNotNull((Object)pattern);
        CuboidRegion cuboid = CuboidRegion.makeCuboid(region);
        Region faces = cuboid.getWalls();
        return this.setBlocks(faces, pattern);
    }

    public int makeWalls(Region region, com.sk89q.worldedit.function.pattern.Pattern pattern) throws WorldEditException {
        Preconditions.checkNotNull((Object)region);
        Preconditions.checkNotNull((Object)pattern);
        if (region instanceof CuboidRegion) {
            return this.makeCuboidWalls(region, pattern);
        }
        for (BlockVector position : region) {
            int x = position.getBlockX();
            int y = position.getBlockY();
            int z = position.getBlockZ();
            if (region.contains(x, z + 1) && region.contains(x, z - 1) && region.contains(x + 1, z) && region.contains(x - 1, z)) continue;
            this.setBlock((Vector)position, pattern);
        }
        return this.changes;
    }

    public int overlayCuboidBlocks(Region region, BlockStateHolder block) throws MaxChangedBlocksException {
        Preconditions.checkNotNull((Object)block);
        return this.overlayCuboidBlocks(region, (com.sk89q.worldedit.function.pattern.Pattern)block);
    }

    public int overlayCuboidBlocks(Region region, com.sk89q.worldedit.function.pattern.Pattern pattern) {
        Preconditions.checkNotNull((Object)region);
        Preconditions.checkNotNull((Object)pattern);
        BlockReplace replace = new BlockReplace(this, pattern);
        RegionOffset offset = new RegionOffset(new Vector(0, 1, 0), replace);
        int minY = region.getMinimumPoint().getBlockY();
        int maxY = Math.min(this.getMaximumPoint().getBlockY(), region.getMaximumPoint().getBlockY() + 1);
        SurfaceRegionFunction surface = new SurfaceRegionFunction(this, offset, minY, maxY);
        FlatRegionVisitor visitor = new FlatRegionVisitor(Regions.asFlatRegion(region), surface, this);
        Operations.completeBlindly(visitor);
        this.changes = visitor.getAffected();
        return this.changes;
    }

    public int naturalizeCuboidBlocks(Region region) {
        Preconditions.checkNotNull((Object)region);
        Naturalizer naturalizer = new Naturalizer(this);
        FlatRegion flatRegion = Regions.asFlatRegion(region);
        LayerVisitor visitor = new LayerVisitor(flatRegion, Regions.minimumBlockY(region), Regions.maximumBlockY(region), naturalizer);
        Operations.completeBlindly(visitor);
        this.changes = naturalizer.getAffected();
        return this.changes;
    }

    public int stackCuboidRegion(Region region, Vector dir, int count, boolean copyAir) {
        return this.stackCuboidRegion(region, dir, count, copyAir, true, false);
    }

    public int stackCuboidRegion(Region region, Vector dir, int count, boolean copyAir, boolean copyEntities, boolean copyBiomes) {
        Preconditions.checkNotNull((Object)region);
        Preconditions.checkNotNull((Object)dir);
        Preconditions.checkArgument((count >= 1 ? 1 : 0) != 0, (Object)"count >= 1 required");
        Vector size = region.getMaximumPoint().subtract(region.getMinimumPoint()).add(1, 1, 1);
        Vector to = region.getMinimumPoint();
        ForwardExtentCopy copy = new ForwardExtentCopy(this, region, this, to);
        copy.setCopyingEntities(copyEntities);
        copy.setCopyBiomes(copyBiomes);
        copy.setRepetitions(count);
        copy.setTransform(new AffineTransform().translate(dir.multiply(size)));
        Mask sourceMask = this.getSourceMask();
        if (sourceMask != null) {
            new MaskTraverser(sourceMask).reset(this);
            copy.setSourceMask(sourceMask);
            this.setSourceMask(null);
        }
        if (!copyAir) {
            copy.setSourceMask(new ExistingBlockMask(this));
        }
        Operations.completeBlindly(copy);
        this.changes = copy.getAffected();
        return this.changes;
    }

    public int moveRegion(Region region, Vector dir, int distance, boolean copyAir, BlockStateHolder replacement) {
        return this.moveRegion(region, dir, distance, copyAir, true, false, replacement);
    }

    public int moveRegion(Region region, Vector dir, int distance, boolean copyAir, boolean copyEntities, boolean copyBiomes, BlockStateHolder replacement) {
        return this.moveRegion(region, dir, distance, copyAir, copyEntities, copyBiomes, (com.sk89q.worldedit.function.pattern.Pattern)replacement);
    }

    public int moveRegion(Region region, Vector dir, int distance, boolean copyAir, boolean copyEntities, boolean copyBiomes, com.sk89q.worldedit.function.pattern.Pattern replacement) {
        Preconditions.checkNotNull((Object)region);
        Preconditions.checkNotNull((Object)dir);
        Preconditions.checkArgument((distance >= 1 ? 1 : 0) != 0, (Object)"distance >= 1 required");
        Vector displace = dir.multiply(distance);
        Vector size = region.getMaximumPoint().subtract(region.getMinimumPoint()).add(1, 1, 1);
        Vector to = region.getMinimumPoint().add(dir.multiply(distance));
        Vector disAbs = displace.positive();
        if (disAbs.getBlockX() < size.getBlockX() && disAbs.getBlockY() < size.getBlockY() && disAbs.getBlockZ() < size.getBlockZ()) {
            this.queue.dequeue();
        }
        ForwardExtentCopy copy = new ForwardExtentCopy(this, region, this, to);
        if (replacement == null) {
            replacement = nullBlock;
        }
        BlockReplace remove = replacement instanceof ExistingPattern ? null : new BlockReplace(this, replacement);
        copy.setCopyBiomes(copyBiomes);
        copy.setCopyingEntities(copyEntities);
        copy.setSourceFunction(remove);
        copy.setRepetitions(1);
        Mask sourceMask = this.getSourceMask();
        if (sourceMask != null) {
            new MaskTraverser(sourceMask).reset(this);
            copy.setSourceMask(sourceMask);
            this.setSourceMask(null);
        }
        if (!copyAir) {
            copy.setSourceMask(new ExistingBlockMask(this));
        }
        Operations.completeBlindly(copy);
        this.changes = copy.getAffected();
        return this.changes;
    }

    public int moveCuboidRegion(Region region, Vector dir, int distance, boolean copyAir, BlockStateHolder replacement) {
        return this.moveRegion(region, dir, distance, copyAir, replacement);
    }

    public int drainArea(Vector origin, double radius) {
        Preconditions.checkNotNull((Object)origin);
        Preconditions.checkArgument((radius >= 0.0 ? 1 : 0) != 0, (Object)"radius >= 0 required");
        BlockTypeMask liquidMask = new BlockTypeMask((Extent)this, BlockTypes.LAVA, BlockTypes.WATER);
        MaskIntersection mask = new MaskIntersection(new BoundedHeightMask(0, this.getMaximumPoint().getBlockY()), new RegionMask(new EllipsoidRegion(null, origin, new Vector(radius, radius, radius))), liquidMask);
        BlockReplace replace = new BlockReplace(this, BlockTypes.AIR.getDefaultState());
        RecursiveVisitor visitor = new RecursiveVisitor(mask, replace, (int)(radius * 2.0 + 1.0), this);
        for (BlockVector position : CuboidRegion.fromCenter(origin, 1)) {
            if (!mask.test(position)) continue;
            visitor.visit(position);
        }
        Operations.completeBlindly(visitor);
        this.changes = visitor.getAffected();
        return this.changes;
    }

    public int fixLiquid(Vector origin, double radius, Mask liquidMask, com.sk89q.worldedit.function.pattern.Pattern pattern) {
        Preconditions.checkNotNull((Object)origin);
        Preconditions.checkArgument((radius >= 0.0 ? 1 : 0) != 0, (Object)"radius >= 0 required");
        MaskIntersection mask = new MaskIntersection(new BoundedHeightMask(0, Math.min(origin.getBlockY(), this.getMaximumPoint().getBlockY())), new RegionMask(new EllipsoidRegion(null, origin, new Vector(radius, radius, radius))), liquidMask);
        BlockReplace replace = new BlockReplace(this, pattern);
        NonRisingVisitor visitor = new NonRisingVisitor(mask, replace, (int)(radius * 2.0 + 1.0), this);
        for (BlockVector position : CuboidRegion.fromCenter(origin, 1)) {
            if (!liquidMask.test(position)) continue;
            visitor.visit(position);
        }
        Operations.completeBlindly(visitor);
        return this.getBlockChangeCount();
    }

    public int makeCylinder(Vector pos, com.sk89q.worldedit.function.pattern.Pattern block, double radius, int height, boolean filled) {
        return this.makeCylinder(pos, block, radius, radius, height, filled);
    }

    public int makeCylinder(Vector pos, com.sk89q.worldedit.function.pattern.Pattern block, double radiusX, double radiusZ, int height, boolean filled) {
        return this.makeCylinder(pos, block, radiusX, radiusZ, height, 0.0, filled);
    }

    public int makeHollowCylinder(Vector pos, com.sk89q.worldedit.function.pattern.Pattern block, double radiusX, double radiusZ, int height, double thickness) {
        return this.makeCylinder(pos, block, radiusX, radiusZ, height, thickness, false);
    }

    private int makeCylinder(Vector pos, com.sk89q.worldedit.function.pattern.Pattern block, double radiusX, double radiusZ, int height, double thickness, boolean filled) {
        block15: {
            radiusX += 0.5;
            radiusZ += 0.5;
            if (height == 0) {
                return this.changes;
            }
            if (height < 0) {
                height = -height;
                pos.mutY(pos.getY() - (double)height);
            }
            if (pos.getBlockY() < 0) {
                pos.mutY(0);
            } else if (pos.getBlockY() + height - 1 > this.maxY) {
                height = this.maxY - pos.getBlockY() + 1;
            }
            double invRadiusX = 1.0 / radiusX;
            double invRadiusZ = 1.0 / radiusZ;
            int px = pos.getBlockX();
            int py = pos.getBlockY();
            int pz = pos.getBlockZ();
            MutableBlockVector mutable = new MutableBlockVector();
            int ceilRadiusX = (int)Math.ceil(radiusX);
            int ceilRadiusZ = (int)Math.ceil(radiusZ);
            double nextXn = 0.0;
            if (thickness != 0.0) {
                double nextMinXn = 0.0;
                double minInvRadiusX = 1.0 / (radiusX - thickness);
                double minInvRadiusZ = 1.0 / (radiusZ - thickness);
                block0: for (int x = 0; x <= ceilRadiusX; ++x) {
                    double xn = nextXn;
                    double dx2 = nextMinXn * nextMinXn;
                    nextXn = (double)(x + 1) * invRadiusX;
                    nextMinXn = (double)(x + 1) * minInvRadiusX;
                    double nextZn = 0.0;
                    double nextMinZn = 0.0;
                    double dx = xn * xn;
                    for (int z = 0; z <= ceilRadiusZ; ++z) {
                        double zn = nextZn;
                        double dz2 = nextMinZn * nextMinZn;
                        nextZn = (double)(z + 1) * invRadiusZ;
                        nextMinZn = (double)(z + 1) * minInvRadiusZ;
                        double dz = zn * zn;
                        double dxz = dx + dz;
                        if (dxz > 1.0) {
                            if (z != 0) continue block0;
                            break block15;
                        }
                        if (dz2 + nextMinXn * nextMinXn <= 1.0 && nextMinZn * nextMinZn + dx2 <= 1.0) continue;
                        for (int y = 0; y < height; ++y) {
                            this.setBlock((Vector)mutable.setComponents(px + x, py + y, pz + z), block);
                            this.setBlock((Vector)mutable.setComponents(px - x, py + y, pz + z), block);
                            this.setBlock((Vector)mutable.setComponents(px + x, py + y, pz - z), block);
                            this.setBlock((Vector)mutable.setComponents(px - x, py + y, pz - z), block);
                        }
                    }
                }
            } else {
                block3: for (int x = 0; x <= ceilRadiusX; ++x) {
                    double xn = nextXn;
                    nextXn = (double)(x + 1) * invRadiusX;
                    double nextZn = 0.0;
                    double dx = xn * xn;
                    for (int z = 0; z <= ceilRadiusZ; ++z) {
                        double zn = nextZn;
                        nextZn = (double)(z + 1) * invRadiusZ;
                        double dz = zn * zn;
                        double dxz = dx + dz;
                        if (dxz > 1.0) {
                            if (z != 0) continue block3;
                            break block15;
                        }
                        if (!filled && dz + nextXn * nextXn <= 1.0 && nextZn * nextZn + dx <= 1.0) continue;
                        for (int y = 0; y < height; ++y) {
                            this.setBlock((Vector)mutable.setComponents(px + x, py + y, pz + z), block);
                            this.setBlock((Vector)mutable.setComponents(px - x, py + y, pz + z), block);
                            this.setBlock((Vector)mutable.setComponents(px + x, py + y, pz - z), block);
                            this.setBlock((Vector)mutable.setComponents(px - x, py + y, pz - z), block);
                        }
                    }
                }
            }
        }
        return this.changes;
    }

    public int makeCircle(Vector pos, com.sk89q.worldedit.function.pattern.Pattern block, double radiusX, double radiusY, double radiusZ, boolean filled, Vector normal) {
        radiusX += 0.5;
        radiusY += 0.5;
        radiusZ += 0.5;
        normal = normal.normalize();
        double nx = normal.getX();
        double ny = normal.getY();
        double nz = normal.getZ();
        double invRadiusX = 1.0 / radiusX;
        double invRadiusY = 1.0 / radiusY;
        double invRadiusZ = 1.0 / radiusZ;
        int px = pos.getBlockX();
        int py = pos.getBlockY();
        int pz = pos.getBlockZ();
        MutableBlockVector mutable = new MutableBlockVector();
        int ceilRadiusX = (int)Math.ceil(radiusX);
        int ceilRadiusY = (int)Math.ceil(radiusY);
        int ceilRadiusZ = (int)Math.ceil(radiusZ);
        double threshold = 0.5;
        LocalBlockVectorSet set = new LocalBlockVectorSet();
        double nextXn = 0.0;
        block0: for (int x = 0; x <= ceilRadiusX; ++x) {
            double xn = nextXn;
            double dx = xn * xn;
            nextXn = (double)(x + 1) * invRadiusX;
            double nextYn = 0.0;
            block1: for (int y = 0; y <= ceilRadiusY; ++y) {
                double yn = nextYn;
                double dy = yn * yn;
                double dxy = dx + dy;
                nextYn = (double)(y + 1) * invRadiusY;
                double nextZn = 0.0;
                for (int z = 0; z <= ceilRadiusZ; ++z) {
                    double zn = nextZn;
                    double dz = zn * zn;
                    double dxyz = dxy + dz;
                    nextZn = (double)(z + 1) * invRadiusZ;
                    if (dxyz > 1.0) {
                        if (z != 0) continue block1;
                        if (y != 0) continue block0;
                        break block0;
                    }
                    if (!filled && nextXn * nextXn + dy + dz <= 1.0 && nextYn * nextYn + dx + dz <= 1.0 && nextZn * nextZn + dx + dy <= 1.0) continue;
                    if (Math.abs((double)x * nx + (double)y * ny + (double)z * nz) < threshold) {
                        this.setBlock((Vector)mutable.setComponents(px + x, py + y, pz + z), block);
                    }
                    if (Math.abs((double)(-x) * nx + (double)y * ny + (double)z * nz) < threshold) {
                        this.setBlock((Vector)mutable.setComponents(px - x, py + y, pz + z), block);
                    }
                    if (Math.abs((double)x * nx + (double)(-y) * ny + (double)z * nz) < threshold) {
                        this.setBlock((Vector)mutable.setComponents(px + x, py - y, pz + z), block);
                    }
                    if (Math.abs((double)x * nx + (double)y * ny + (double)(-z) * nz) < threshold) {
                        this.setBlock((Vector)mutable.setComponents(px + x, py + y, pz - z), block);
                    }
                    if (Math.abs((double)(-x) * nx + (double)(-y) * ny + (double)z * nz) < threshold) {
                        this.setBlock((Vector)mutable.setComponents(px - x, py - y, pz + z), block);
                    }
                    if (Math.abs((double)x * nx + (double)(-y) * ny + (double)(-z) * nz) < threshold) {
                        this.setBlock((Vector)mutable.setComponents(px + x, py - y, pz - z), block);
                    }
                    if (Math.abs((double)(-x) * nx + (double)y * ny + (double)(-z) * nz) < threshold) {
                        this.setBlock((Vector)mutable.setComponents(px - x, py + y, pz - z), block);
                    }
                    if (!(Math.abs((double)(-x) * nx + (double)(-y) * ny + (double)(-z) * nz) < threshold)) continue;
                    this.setBlock((Vector)mutable.setComponents(px - x, py - y, pz - z), block);
                }
            }
        }
        return this.changes;
    }

    public int makeSphere(Vector pos, com.sk89q.worldedit.function.pattern.Pattern block, double radius, boolean filled) {
        return this.makeSphere(pos, block, radius, radius, radius, filled);
    }

    public int makeSphere(Vector pos, com.sk89q.worldedit.function.pattern.Pattern block, double radiusX, double radiusY, double radiusZ, boolean filled) {
        double invRadiusX = 1.0 / (radiusX += 0.5);
        double invRadiusY = 1.0 / (radiusY += 0.5);
        double invRadiusZ = 1.0 / (radiusZ += 0.5);
        int px = pos.getBlockX();
        int py = pos.getBlockY();
        int pz = pos.getBlockZ();
        int ceilRadiusX = (int)Math.ceil(radiusX);
        int ceilRadiusY = (int)Math.ceil(radiusY);
        int ceilRadiusZ = (int)Math.ceil(radiusZ);
        double nextXn = 0.0;
        block0: for (int x = 0; x <= ceilRadiusX; ++x) {
            double xn = nextXn;
            double dx = xn * xn;
            nextXn = (double)(x + 1) * invRadiusX;
            double nextYn = 0.0;
            block1: for (int y = 0; y <= ceilRadiusY; ++y) {
                double yn = nextYn;
                double dy = yn * yn;
                double dxy = dx + dy;
                nextYn = (double)(y + 1) * invRadiusY;
                double nextZn = 0.0;
                for (int z = 0; z <= ceilRadiusZ; ++z) {
                    double zn = nextZn;
                    double dz = zn * zn;
                    double dxyz = dxy + dz;
                    nextZn = (double)(z + 1) * invRadiusZ;
                    if (dxyz > 1.0) {
                        if (z != 0) continue block1;
                        if (y != 0) continue block0;
                        break block0;
                    }
                    if (!filled && nextXn * nextXn + dy + dz <= 1.0 && nextYn * nextYn + dx + dz <= 1.0 && nextZn * nextZn + dx + dy <= 1.0) continue;
                    this.setBlock(px + x, py + y, pz + z, block);
                    this.setBlock(px - x, py + y, pz + z, block);
                    this.setBlock(px + x, py - y, pz + z, block);
                    this.setBlock(px + x, py + y, pz - z, block);
                    this.setBlock(px - x, py - y, pz + z, block);
                    this.setBlock(px + x, py - y, pz - z, block);
                    this.setBlock(px - x, py + y, pz - z, block);
                    this.setBlock(px - x, py - y, pz - z, block);
                }
            }
        }
        return this.changes;
    }

    public int makePyramid(Vector position, com.sk89q.worldedit.function.pattern.Pattern block, int size, boolean filled) {
        int height = size;
        for (int y = 0; y <= height; ++y) {
            --size;
            for (int x = 0; x <= size; ++x) {
                for (int z = 0; z <= size; ++z) {
                    if ((!filled || z > size || x > size) && z != size && x != size) continue;
                    this.setBlock(position.add(x, y, z), block);
                    this.setBlock(position.add(-x, y, z), block);
                    this.setBlock(position.add(x, y, -z), block);
                    this.setBlock(position.add(-x, y, -z), block);
                }
            }
        }
        return this.changes;
    }

    public int thaw(Vector position, double radius) {
        double radiusSq = radius * radius;
        int ox = position.getBlockX();
        int oy = position.getBlockY();
        int oz = position.getBlockZ();
        int ceilRadius = (int)Math.ceil(radius);
        for (int x = ox - ceilRadius; x <= ox + ceilRadius; ++x) {
            int dx = x - ox;
            int dx2 = dx * dx;
            block6: for (int z = oz - ceilRadius; z <= oz + ceilRadius; ++z) {
                int dz = z - oz;
                int dz2 = dz * dz;
                if ((double)(dx2 + dz2) > radiusSq) continue;
                block7: for (int y = this.maxY; y >= 1; --y) {
                    BlockType type = this.getBlockType(x, y, z);
                    switch (type.getTypeEnum()) {
                        case ICE: {
                            this.setBlock(x, y, z, BlockTypes.WATER.getDefaultState());
                            continue block6;
                        }
                        case SNOW: {
                            this.setBlock(x, y, z, BlockTypes.AIR.getDefaultState());
                            continue block6;
                        }
                        case CAVE_AIR: 
                        case VOID_AIR: 
                        case AIR: {
                            continue block7;
                        }
                        default: {
                            continue block6;
                        }
                    }
                }
            }
        }
        return this.changes;
    }

    public int simulateSnow(Vector position, double radius) {
        double radiusSq = radius * radius;
        int ox = position.getBlockX();
        int oy = position.getBlockY();
        int oz = position.getBlockZ();
        int ceilRadius = (int)Math.ceil(radius);
        for (int x = ox - ceilRadius; x <= ox + ceilRadius; ++x) {
            int dx = x - ox;
            int dx2 = dx * dx;
            block6: for (int z = oz - ceilRadius; z <= oz + ceilRadius; ++z) {
                int dz = z - oz;
                int dz2 = dz * dz;
                if ((double)(dx2 + dz2) > radiusSq) continue;
                block7: for (int y = this.maxY; y >= 1; --y) {
                    BlockType type = this.getBlockType(x, y, z);
                    switch (type.getTypeEnum()) {
                        case CAVE_AIR: 
                        case VOID_AIR: 
                        case AIR: {
                            continue block7;
                        }
                        case WATER: {
                            this.setBlock(x, y, z, BlockTypes.ICE.getDefaultState());
                            continue block6;
                        }
                        case ACACIA_LEAVES: 
                        case BIRCH_LEAVES: 
                        case DARK_OAK_LEAVES: 
                        case JUNGLE_LEAVES: 
                        case OAK_LEAVES: 
                        case SPRUCE_LEAVES: {
                            break;
                        }
                        default: {
                            if (type.getMaterial().isTranslucent()) continue block6;
                        }
                    }
                    if (y == this.maxY) continue block6;
                    this.setBlock(x, y + 1, z, BlockTypes.SNOW.getDefaultState());
                    continue block6;
                }
            }
        }
        return this.changes;
    }

    public int green(Vector position, double radius) {
        double radiusSq = radius * radius;
        int ox = position.getBlockX();
        int oy = position.getBlockY();
        int oz = position.getBlockZ();
        int ceilRadius = (int)Math.ceil(radius);
        for (int x = ox - ceilRadius; x <= ox + ceilRadius; ++x) {
            int dx = x - ox;
            int dx2 = dx * dx;
            block5: for (int z = oz - ceilRadius; z <= oz + ceilRadius; ++z) {
                int dz = z - oz;
                int dz2 = dz * dz;
                if ((double)(dx2 + dz2) > radiusSq) continue;
                block6: for (int y = this.maxY; y >= 1; --y) {
                    BlockType block = this.getBlockType(x, y, z);
                    switch (block.getTypeEnum()) {
                        case DIRT: {
                            this.setBlock(x, y, z, BlockTypes.GRASS_BLOCK.getDefaultState());
                            continue block5;
                        }
                        case WATER: 
                        case LAVA: {
                            continue block5;
                        }
                        default: {
                            if (block.getMaterial().isMovementBlocker()) continue block5;
                            continue block6;
                        }
                    }
                }
            }
        }
        return this.changes;
    }

    public int makePumpkinPatches(Vector position, int apothem) {
        return this.makePumpkinPatches(position, apothem, 0.02);
    }

    public int makePumpkinPatches(Vector position, int apothem, double density) {
        GardenPatchGenerator generator = new GardenPatchGenerator(this);
        generator.setPlant(GardenPatchGenerator.getPumpkinPattern());
        CuboidRegion region = new CuboidRegion(this.getWorld(), position.add(-apothem, -5, -apothem), position.add(apothem, 10, apothem));
        GroundFunction ground = new GroundFunction(new ExistingBlockMask(this), generator);
        LayerVisitor visitor = new LayerVisitor(region, Regions.minimumBlockY(region), Regions.maximumBlockY(region), ground);
        visitor.setMask(new NoiseFilter2D(new RandomNoise(), density));
        Operations.completeBlindly(visitor);
        this.changes = ground.getAffected();
        return this.changes;
    }

    public int makeForest(Vector basePosition, int size, double density, TreeGenerator.TreeType treeType) {
        try {
            for (int x = basePosition.getBlockX() - size; x <= basePosition.getBlockX() + size; ++x) {
                for (int z = basePosition.getBlockZ() - size; z <= basePosition.getBlockZ() + size; ++z) {
                    if (!this.getBlockType(x, basePosition.getBlockY(), z).getMaterial().isAir() || (double)ThreadLocalRandom.current().nextInt(65536) >= density * 65536.0) continue;
                    ++this.changes;
                    block9: for (int y = basePosition.getBlockY(); y >= basePosition.getBlockY() - 10; --y) {
                        BlockType type = this.getBlockType(x, y, z);
                        switch (type.getTypeEnum()) {
                            case DIRT: 
                            case GRASS: {
                                treeType.generate(this, new Vector(x, y + 1, z));
                                ++this.changes;
                                continue block9;
                            }
                            case SNOW: {
                                this.setBlock(new Vector(x, y, z), BlockTypes.AIR.getDefaultState());
                                continue block9;
                            }
                            case CAVE_AIR: 
                            case VOID_AIR: 
                            case AIR: {
                                continue block9;
                            }
                        }
                    }
                }
            }
        }
        catch (MaxChangedBlocksException maxChangedBlocksException) {
            // empty catch block
        }
        return this.changes;
    }

    @Override
    public List<Countable<BlockType>> getBlockDistribution(Region region) {
        int[] counter = new int[BlockTypes.size()];
        if (region instanceof CuboidRegion) {
            Vector min = region.getMinimumPoint();
            Vector max = region.getMaximumPoint();
            int minX = min.getBlockX();
            int minY = min.getBlockY();
            int minZ = min.getBlockZ();
            int maxX = max.getBlockX();
            int maxY = max.getBlockY();
            int maxZ = max.getBlockZ();
            MutableBlockVector mutable = new MutableBlockVector(minX, minY, minZ);
            for (int x = minX; x <= maxX; ++x) {
                for (int y = minY; y <= maxY; ++y) {
                    for (int z = minZ; z <= maxZ; ++z) {
                        BlockType type = this.getBlockType(x, y, z);
                        int n = type.getInternalId();
                        counter[n] = counter[n] + 1;
                    }
                }
            }
        } else {
            for (Vector pt : region) {
                BlockType type = this.getBlockType(pt);
                int n = type.getInternalId();
                counter[n] = counter[n] + 1;
            }
        }
        ArrayList<Countable<BlockType>> distribution = new ArrayList<Countable<BlockType>>();
        for (int i = 0; i < counter.length; ++i) {
            int count = counter[i];
            if (count == 0) continue;
            distribution.add(new Countable<BlockTypes>(BlockTypes.get(i), count));
        }
        Collections.sort(distribution);
        return distribution;
    }

    @Override
    public List<Countable<BlockStateHolder>> getBlockDistributionWithData(Region region) {
        int[][] counter = new int[BlockTypes.size()][];
        if (region instanceof CuboidRegion) {
            Vector min = region.getMinimumPoint();
            Vector max = region.getMaximumPoint();
            int minX = min.getBlockX();
            int minY = min.getBlockY();
            int minZ = min.getBlockZ();
            int maxX = max.getBlockX();
            int maxY = max.getBlockY();
            int maxZ = max.getBlockZ();
            for (int x = minX; x <= maxX; ++x) {
                for (int y = minY; y <= maxY; ++y) {
                    for (int z = minZ; z <= maxZ; ++z) {
                        BlockState blk = this.getBlock(x, y, z);
                        BlockTypes type = blk.getBlockType();
                        int[] stateCounter = counter[type.getInternalId()];
                        if (stateCounter == null) {
                            counter[type.getInternalId()] = stateCounter = new int[type.getMaxStateId() + 1];
                        }
                        int n = blk.getInternalPropertiesId();
                        stateCounter[n] = stateCounter[n] + 1;
                    }
                }
            }
        } else {
            for (Vector pt : region) {
                BlockState blk = this.getBlock(pt);
                BlockTypes type = blk.getBlockType();
                int[] stateCounter = counter[type.getInternalId()];
                if (stateCounter == null) {
                    counter[type.getInternalId()] = stateCounter = new int[type.getMaxStateId() + 1];
                }
                int n = blk.getInternalPropertiesId();
                stateCounter[n] = stateCounter[n] + 1;
            }
        }
        ArrayList<Countable<BlockStateHolder>> distribution = new ArrayList<Countable<BlockStateHolder>>();
        for (int typeId = 0; typeId < counter.length; ++typeId) {
            BlockTypes type = BlockTypes.get(typeId);
            int[] stateCount = counter[typeId];
            if (stateCount == null) continue;
            for (int propId = 0; propId < stateCount.length; ++propId) {
                int count = stateCount[propId];
                if (count == 0) continue;
                BlockState state = type.withPropertyId(propId);
                distribution.add(new Countable<BlockState>(state, count));
            }
        }
        return distribution;
    }

    public int makeShape(Region region, final Vector zero, final Vector unit, com.sk89q.worldedit.function.pattern.Pattern pattern, String expressionString, boolean hollow) throws ExpressionException, MaxChangedBlocksException {
        final Expression expression = Expression.compile(expressionString, "x", "y", "z", "type", "data");
        expression.optimize();
        final RValue typeVariable = expression.getVariable("type", false);
        final RValue dataVariable = expression.getVariable("data", false);
        final WorldEditExpressionEnvironment environment = new WorldEditExpressionEnvironment(this, unit, zero);
        expression.setEnvironment(environment);
        ArbitraryShape shape = new ArbitraryShape(region){

            @Override
            public BlockStateHolder getMaterial(int x, int y, int z, BlockStateHolder defaultMaterial) {
                MutableBlockVector current = EditSession.this.mutable.setComponents(x, y, z);
                environment.setCurrentBlock(current);
                Vector scaled = current.subtract(zero).divide(unit);
                try {
                    double[] dArray = new double[]{scaled.getX(), scaled.getY(), scaled.getZ(), defaultMaterial.getBlockType().getInternalId(), defaultMaterial.getInternalPropertiesId()};
                    if (expression.evaluate(dArray) <= 0.0) {
                        return null;
                    }
                    return BlockTypes.get((int)typeVariable.getValue()).withPropertyId((int)dataVariable.getValue());
                }
                catch (Exception e) {
                    Fawe.debug("Failed to create shape: " + e);
                    return null;
                }
            }
        };
        try {
            return shape.generate(this, pattern, hollow);
        }
        catch (WorldEditException e) {
            throw new RuntimeException(e);
        }
    }

    public int deformRegion(Region region, final Vector zero, final Vector unit, String expressionString) throws ExpressionException, MaxChangedBlocksException {
        final Expression expression = Expression.compile(expressionString, "x", "y", "z");
        expression.optimize();
        final RValue x = expression.getVariable("x", false).optimize();
        final RValue y = expression.getVariable("y", false).optimize();
        final RValue z = expression.getVariable("z", false).optimize();
        WorldEditExpressionEnvironment environment = new WorldEditExpressionEnvironment(this, unit, zero);
        expression.setEnvironment(environment);
        final Vector zero2 = zero.add(0.5, 0.5, 0.5);
        RegionVisitor visitor = new RegionVisitor(region, new RegionFunction(){
            private MutableBlockVector mutable = new MutableBlockVector();

            @Override
            public boolean apply(Vector position) throws WorldEditException {
                try {
                    double sx = (position.getX() - zero.getX()) / unit.getX();
                    double sy = (position.getY() - zero.getY()) / unit.getY();
                    double sz = (position.getZ() - zero.getZ()) / unit.getZ();
                    expression.evaluate(sx, sy, sz);
                    int xv = (int)(x.getValue() * unit.getX() + zero2.getX());
                    int yv = (int)(y.getValue() * unit.getY() + zero2.getY());
                    int zv = (int)(z.getValue() * unit.getZ() + zero2.getZ());
                    return EditSession.this.setBlock(position, EditSession.this.getBlock(xv, yv, zv));
                }
                catch (EvaluationException e) {
                    throw new RuntimeException(e);
                }
            }
        }, this);
        Operations.completeBlindly(visitor);
        this.changes += visitor.getAffected();
        return this.changes;
    }

    public int hollowOutRegion(Region region, int thickness, com.sk89q.worldedit.function.pattern.Pattern pattern) {
        LocalBlockVectorSet outside = new LocalBlockVectorSet();
        Vector min = region.getMinimumPoint();
        Vector max = region.getMaximumPoint();
        int minX = min.getBlockX();
        int minY = min.getBlockY();
        int minZ = min.getBlockZ();
        int maxX = max.getBlockX();
        int maxY = max.getBlockY();
        int maxZ = max.getBlockZ();
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                this.recurseHollow(region, new BlockVector(x, y, minZ), outside);
                this.recurseHollow(region, new BlockVector(x, y, maxZ), outside);
            }
        }
        for (int y = minY; y <= maxY; ++y) {
            for (int z = minZ; z <= maxZ; ++z) {
                this.recurseHollow(region, new BlockVector(minX, y, z), outside);
                this.recurseHollow(region, new BlockVector(maxX, y, z), outside);
            }
        }
        for (int z = minZ; z <= maxZ; ++z) {
            for (int x = minX; x <= maxX; ++x) {
                this.recurseHollow(region, new BlockVector(x, minY, z), outside);
                this.recurseHollow(region, new BlockVector(x, maxY, z), outside);
            }
        }
        for (int i = 1; i < thickness; ++i) {
            LocalBlockVectorSet newOutside = new LocalBlockVectorSet();
            block9: for (BlockVector position : region) {
                for (Vector recurseDirection : recurseDirections) {
                    BlockVector neighbor = position.add(recurseDirection).toBlockVector();
                    if (!outside.contains(neighbor)) continue;
                    newOutside.add(position);
                    continue block9;
                }
            }
            outside.addAll(newOutside);
        }
        try {
            block11: for (BlockVector position : region) {
                for (Vector recurseDirection : recurseDirections) {
                    BlockVector neighbor = position.add(recurseDirection).toBlockVector();
                    if (outside.contains(neighbor)) continue block11;
                }
                ++this.changes;
                pattern.apply(this.extent, position, position);
            }
        }
        catch (WorldEditException e) {
            throw new RuntimeException(e);
        }
        return this.changes;
    }

    public int drawLine(com.sk89q.worldedit.function.pattern.Pattern pattern, Vector pos1, Vector pos2, double radius, boolean filled) {
        return this.drawLine(pattern, pos1, pos2, radius, filled, false);
    }

    public int drawLine(com.sk89q.worldedit.function.pattern.Pattern pattern, Vector pos1, Vector pos2, double radius, boolean filled, boolean flat) {
        Set<Vector> newVset;
        int domstep;
        int dz;
        int dy;
        LocalBlockVectorSet vset = new LocalBlockVectorSet();
        boolean notdrawn = true;
        int x1 = pos1.getBlockX();
        int y1 = pos1.getBlockY();
        int z1 = pos1.getBlockZ();
        int x2 = pos2.getBlockX();
        int y2 = pos2.getBlockY();
        int z2 = pos2.getBlockZ();
        int tipx = x1;
        int tipy = y1;
        int tipz = z1;
        int dx = Math.abs(x2 - x1);
        if (dx + (dy = Math.abs(y2 - y1)) + (dz = Math.abs(z2 - z1)) == 0) {
            vset.add(tipx, tipy, tipz);
            notdrawn = false;
        }
        if (Math.max(Math.max(dx, dy), dz) == dx && notdrawn) {
            for (domstep = 0; domstep <= dx; ++domstep) {
                tipx = x1 + domstep * (x2 - x1 > 0 ? 1 : -1);
                tipy = (int)Math.round((double)y1 + (double)domstep * (double)dy / (double)dx * (double)(y2 - y1 > 0 ? 1 : -1));
                tipz = (int)Math.round((double)z1 + (double)domstep * (double)dz / (double)dx * (double)(z2 - z1 > 0 ? 1 : -1));
                vset.add(tipx, tipy, tipz);
            }
            notdrawn = false;
        }
        if (Math.max(Math.max(dx, dy), dz) == dy && notdrawn) {
            for (domstep = 0; domstep <= dy; ++domstep) {
                tipy = y1 + domstep * (y2 - y1 > 0 ? 1 : -1);
                tipx = (int)Math.round((double)x1 + (double)domstep * (double)dx / (double)dy * (double)(x2 - x1 > 0 ? 1 : -1));
                tipz = (int)Math.round((double)z1 + (double)domstep * (double)dz / (double)dy * (double)(z2 - z1 > 0 ? 1 : -1));
                vset.add(tipx, tipy, tipz);
            }
            notdrawn = false;
        }
        if (Math.max(Math.max(dx, dy), dz) == dz && notdrawn) {
            for (domstep = 0; domstep <= dz; ++domstep) {
                tipz = z1 + domstep * (z2 - z1 > 0 ? 1 : -1);
                tipy = (int)Math.round((double)y1 + (double)domstep * (double)dy / (double)dz * (double)(y2 - y1 > 0 ? 1 : -1));
                tipx = (int)Math.round((double)x1 + (double)domstep * (double)dx / (double)dz * (double)(x2 - x1 > 0 ? 1 : -1));
                vset.add(tipx, tipy, tipz);
            }
        }
        if (flat) {
            newVset = this.getStretched(vset, radius);
            if (!filled) {
                newVset = this.getOutline(newVset);
            }
        } else {
            newVset = this.getBallooned(vset, radius);
            if (!filled) {
                newVset = this.getHollowed(newVset);
            }
        }
        return this.setBlocks(newVset, pattern);
    }

    public int drawSpline(com.sk89q.worldedit.function.pattern.Pattern pattern, List<Vector> nodevectors, double tension, double bias, double continuity, double quality, double radius, boolean filled) throws WorldEditException {
        LocalBlockVectorSet vset = new LocalBlockVectorSet();
        ArrayList<Node> nodes = new ArrayList<Node>(nodevectors.size());
        KochanekBartelsInterpolation interpol = new KochanekBartelsInterpolation();
        for (Vector nodevector : nodevectors) {
            Node n = new Node(nodevector);
            n.setTension(tension);
            n.setBias(bias);
            n.setContinuity(continuity);
            nodes.add(n);
        }
        interpol.setNodes(nodes);
        double splinelength = interpol.arcLength(0.0, 1.0);
        for (double loop = 0.0; loop <= 1.0; loop += 1.0 / splinelength / quality) {
            Vector tipv = interpol.getPosition(loop);
            if (radius == 0.0) {
                pattern.apply(this, tipv, tipv);
                continue;
            }
            vset.add(tipv);
        }
        if (radius != 0.0) {
            Set<Vector> newVset = this.getBallooned(vset, radius);
            if (!filled) {
                newVset = this.getHollowed(newVset);
            }
            return this.setBlocks(newVset, pattern);
        }
        return this.changes;
    }

    private Set<Vector> getBallooned(Set<Vector> vset, double radius) {
        if (radius < 1.0) {
            return vset;
        }
        LocalBlockVectorSet returnset = new LocalBlockVectorSet();
        int ceilrad = (int)Math.ceil(radius);
        for (Vector v : vset) {
            int tipx = v.getBlockX();
            int tipy = v.getBlockY();
            int tipz = v.getBlockZ();
            for (int loopx = tipx - ceilrad; loopx <= tipx + ceilrad; ++loopx) {
                for (int loopy = tipy - ceilrad; loopy <= tipy + ceilrad; ++loopy) {
                    for (int loopz = tipz - ceilrad; loopz <= tipz + ceilrad; ++loopz) {
                        double[] dArray = new double[]{loopx - tipx, loopy - tipy, loopz - tipz};
                        if (!(MathMan.hypot(dArray) <= radius)) continue;
                        returnset.add(loopx, loopy, loopz);
                    }
                }
            }
        }
        return returnset;
    }

    public Set<Vector> getStretched(Set<Vector> vset, double radius) {
        if (radius < 1.0) {
            return vset;
        }
        LocalBlockVectorSet returnset = new LocalBlockVectorSet();
        int ceilrad = (int)Math.ceil(radius);
        for (Vector v : vset) {
            int tipx = v.getBlockX();
            int tipy = v.getBlockY();
            int tipz = v.getBlockZ();
            for (int loopx = tipx - ceilrad; loopx <= tipx + ceilrad; ++loopx) {
                for (int loopz = tipz - ceilrad; loopz <= tipz + ceilrad; ++loopz) {
                    double[] dArray = new double[]{loopx - tipx, 0.0, loopz - tipz};
                    if (!(MathMan.hypot(dArray) <= radius)) continue;
                    returnset.add(loopx, v.getBlockY(), loopz);
                }
            }
        }
        return returnset;
    }

    public Set<Vector> getOutline(Set<Vector> vset) {
        LocalBlockVectorSet returnset = new LocalBlockVectorSet();
        for (Vector v : vset) {
            double z;
            double y;
            double x = v.getX();
            if (vset.contains(new Vector(x + 1.0, y = v.getY(), z = v.getZ())) && vset.contains(new Vector(x - 1.0, y, z)) && vset.contains(new Vector(x, y, z + 1.0)) && vset.contains(new Vector(x, y, z - 1.0))) continue;
            returnset.add(v);
        }
        return returnset;
    }

    public Set<Vector> getHollowed(Set<Vector> vset) {
        LocalBlockVectorSet returnset = new LocalBlockVectorSet();
        for (Vector v : vset) {
            double z;
            double y;
            double x = v.getX();
            if (vset.contains(new Vector(x + 1.0, y = v.getY(), z = v.getZ())) && vset.contains(new Vector(x - 1.0, y, z)) && vset.contains(new Vector(x, y + 1.0, z)) && vset.contains(new Vector(x, y - 1.0, z)) && vset.contains(new Vector(x, y, z + 1.0)) && vset.contains(new Vector(x, y, z - 1.0))) continue;
            returnset.add(v);
        }
        return returnset;
    }

    public void recurseHollow(Region region, BlockVector origin, Set<BlockVector> outside) {
        ArrayDeque<BlockVector> queue = new ArrayDeque<BlockVector>();
        queue.addLast(origin);
        while (!queue.isEmpty()) {
            BlockVector current = (BlockVector)queue.removeFirst();
            if (this.getBlockType(current).getMaterial().isMovementBlocker() || !outside.add(current) || !region.contains(current)) continue;
            for (Vector recurseDirection : recurseDirections) {
                queue.addLast(current.add(recurseDirection).toBlockVector());
            }
        }
    }

    public int makeBiomeShape(Region region, Vector zero, Vector unit, BaseBiome biomeType, String expressionString, boolean hollow) throws ExpressionException {
        final Vector2D zero2D = zero.toVector2D();
        final Vector2D unit2D = unit.toVector2D();
        final Expression expression = Expression.compile(expressionString, "x", "z");
        expression.optimize();
        EditSession editSession = this;
        final WorldEditExpressionEnvironment environment = new WorldEditExpressionEnvironment(editSession, unit, zero);
        expression.setEnvironment(environment);
        ArbitraryBiomeShape shape = new ArbitraryBiomeShape(region){

            @Override
            protected BaseBiome getBiome(int x, int z, BaseBiome defaultBiomeType) {
                Vector2D current = new Vector2D(x, z);
                environment.setCurrentBlock(current.toVector(0.0));
                Vector2D scaled = current.subtract(zero2D).divide(unit2D);
                try {
                    double[] dArray = new double[]{scaled.getX(), scaled.getZ()};
                    if (expression.evaluate(dArray) <= 0.0) {
                        return null;
                    }
                    return defaultBiomeType;
                }
                catch (Exception e) {
                    Fawe.debug("Failed to create shape: " + e);
                    return null;
                }
            }
        };
        return shape.generate(this, biomeType, hollow);
    }

    private double lengthSq(double x, double y, double z) {
        return x * x + y * y + z * z;
    }

    private double lengthSq(double x, double z) {
        return x * x + z * z;
    }

    @Override
    public String getName() {
        return this.worldName;
    }

    @Override
    public int getBlockLightLevel(Vector position) {
        return this.queue.getEmmittedLight(position.getBlockX(), position.getBlockY(), position.getBlockZ());
    }

    @Override
    public boolean clearContainerBlockContents(Vector pos) {
        BlockState block = this.getFullBlock(pos);
        CompoundTag nbt = block.getNbtData();
        if (nbt != null && nbt.containsKey("items")) {
            block.setNbtData(null);
            return this.setBlock(pos.getBlockX(), pos.getBlockY(), pos.getBlockZ(), block);
        }
        return false;
    }

    public boolean regenerate(Region region) {
        return this.regenerate(region, this);
    }

    @Override
    public boolean regenerate(Region region, EditSession session) {
        return session.regenerate(region, null, null);
    }

    private void setExistingBlocks(Vector pos1, Vector pos2) {
        for (int x = (int)pos1.getX(); x <= (int)pos2.getX(); ++x) {
            for (int z = pos1.getBlockZ(); z <= pos2.getBlockZ(); ++z) {
                for (int y = (int)pos1.getY(); y <= (int)pos2.getY(); ++y) {
                    CompoundTag tile;
                    int from = this.queue.getCombinedId4Data(x, y, z);
                    this.queue.setBlock(x, y, z, from);
                    if (!BlockTypes.getFromStateId(from).getMaterial().hasContainer() || (tile = this.queue.getTileEntity(x, y, z)) == null) continue;
                    this.queue.setTile(x, y, z, tile);
                }
            }
        }
    }

    public boolean regenerate(Region region, final BaseBiome biome, final Long seed) {
        final FaweQueue queue = this.getQueue();
        queue.setChangeTask(null);
        FaweChangeSet fcs = (FaweChangeSet)this.getChangeSet();
        FaweRegionExtent fe = this.getRegionExtent();
        boolean cuboid = region instanceof CuboidRegion;
        if (fe != null && cuboid) {
            Vector max = region.getMaximumPoint();
            Vector min = region.getMinimumPoint();
            if (!fe.contains(max.getBlockX(), max.getBlockY(), max.getBlockZ()) && !fe.contains(min.getBlockX(), min.getBlockY(), min.getBlockZ())) {
                throw new FaweException(BBC.WORLDEDIT_CANCEL_REASON_OUTSIDE_REGION);
            }
        }
        Set<Vector2D> chunks = region.getChunks();
        MutableBlockVector mutable = new MutableBlockVector();
        MutableBlockVector2D mutable2D = new MutableBlockVector2D();
        for (Vector2D chunk : chunks) {
            int y;
            int zz;
            int z;
            int xx;
            int x;
            final int cx = chunk.getBlockX();
            final int cz = chunk.getBlockZ();
            int bx = cx << 4;
            int bz = cz << 4;
            Vector cmin = new Vector(bx, 0, bz);
            Vector cmax = cmin.add(15, this.getMaxY(), 15);
            boolean containsBot1 = fe == null || fe.contains(cmin.getBlockX(), cmin.getBlockY(), cmin.getBlockZ());
            boolean containsBot2 = region.contains(cmin);
            boolean containsTop1 = fe == null || fe.contains(cmax.getBlockX(), cmax.getBlockY(), cmax.getBlockZ());
            boolean containsTop2 = region.contains(cmax);
            if (containsBot2 && containsTop2 && !containsBot1 && !containsTop1) continue;
            boolean conNextX = chunks.contains(mutable2D.setComponents(cx + 1, cz));
            boolean conNextZ = chunks.contains(mutable2D.setComponents(cx, cz + 1));
            boolean containsAny = false;
            if (cuboid && containsBot1 && containsBot2 && containsTop1 && containsTop2 && conNextX && conNextZ) {
                containsAny = true;
                if (fcs != null) {
                    for (x = 0; x < 16; ++x) {
                        xx = x + bx;
                        for (z = 0; z < 16; ++z) {
                            zz = z + bz;
                            for (y = 0; y < this.getMaxY() + 1; ++y) {
                                BlockState block = this.getFullBlock(mutable.setComponents(xx, y, zz));
                                fcs.add(mutable, block, BlockTypes.AIR.getDefaultState());
                            }
                        }
                    }
                }
            } else {
                if (!conNextX) {
                    this.setExistingBlocks(new Vector(bx + 16, 0, bz), new Vector(bx + 31, this.getMaxY(), bz + 15));
                }
                if (!conNextZ) {
                    this.setExistingBlocks(new Vector(bx, 0, bz + 16), new Vector(bx + 15, this.getMaxY(), bz + 31));
                }
                if (!(chunks.contains(mutable2D.setComponents(cx + 1, cz + 1)) || conNextX || conNextZ)) {
                    this.setExistingBlocks(new Vector(bx + 16, 0, bz + 16), new Vector(bx + 31, this.getMaxY(), bz + 31));
                }
                for (x = 0; x < 16; ++x) {
                    xx = x + bx;
                    mutable.mutX(xx);
                    for (z = 0; z < 16; ++z) {
                        zz = z + bz;
                        mutable.mutZ(zz);
                        for (y = 0; y < this.getMaxY() + 1; ++y) {
                            BlockState block;
                            boolean contains;
                            mutable.mutY(y);
                            boolean bl = contains = (fe == null || fe.contains(xx, y, zz)) && region.contains(mutable);
                            if (contains) {
                                containsAny = true;
                                if (fcs == null) continue;
                                block = this.getFullBlock(mutable.setComponents(xx, y, zz));
                                fcs.add(mutable, block, BlockTypes.AIR.getDefaultState());
                                continue;
                            }
                            block = this.getFullBlock(mutable.setComponents(xx, y, zz));
                            try {
                                this.setBlock((Vector)mutable, block);
                                continue;
                            }
                            catch (MaxChangedBlocksException e) {
                                throw new RuntimeException(e);
                            }
                        }
                    }
                }
            }
            if (!containsAny) continue;
            ++this.changes;
            TaskManager.IMP.sync(new RunnableVal<Object>(){

                @Override
                public void run(Object value) {
                    queue.regenerateChunk(cx, cz, biome, seed);
                }
            });
        }
        if (this.changes != 0) {
            this.flushQueue();
            return true;
        }
        this.queue.clear();
        return false;
    }

    @Override
    public void dropItem(Vector position, BaseItemStack item) {
        if (this.getWorld() != null) {
            this.getWorld().dropItem(position, item);
        }
    }

    @Override
    public void simulateBlockMine(Vector position) {
        TaskManager.IMP.sync(() -> {
            this.world.simulateBlockMine(position);
            return null;
        });
    }

    public boolean generateTree(TreeGenerator.TreeType type, Vector position) {
        return this.generateTree(type, this, position);
    }

    @Override
    public boolean generateTree(TreeGenerator.TreeType type, EditSession editSession, Vector position) {
        if (this.getWorld() != null) {
            try {
                return this.getWorld().generateTree(type, editSession, position);
            }
            catch (MaxChangedBlocksException e) {
                throw new RuntimeException(e);
            }
        }
        return false;
    }

    @Override
    public WeatherType getWeather() {
        return this.world.getWeather();
    }

    @Override
    public long getRemainingWeatherDuration() {
        return this.world.getRemainingWeatherDuration();
    }

    @Override
    public void setWeather(WeatherType weatherType) {
        this.world.setWeather(weatherType);
    }

    @Override
    public void setWeather(WeatherType weatherType, long duration) {
        this.world.setWeather(weatherType, duration);
    }

    public static enum Stage {
        BEFORE_HISTORY,
        BEFORE_REORDER,
        BEFORE_CHANGE;

    }
}

