/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.jnbt;

import com.boydti.fawe.object.io.LittleEndianOutputStream;
import com.google.common.base.Preconditions;
import com.sk89q.jnbt.ByteArrayTag;
import com.sk89q.jnbt.ByteTag;
import com.sk89q.jnbt.CompoundTag;
import com.sk89q.jnbt.DoubleTag;
import com.sk89q.jnbt.EndTag;
import com.sk89q.jnbt.FloatTag;
import com.sk89q.jnbt.IntArrayTag;
import com.sk89q.jnbt.IntTag;
import com.sk89q.jnbt.ListTag;
import com.sk89q.jnbt.LongArrayTag;
import com.sk89q.jnbt.LongTag;
import com.sk89q.jnbt.NBTConstants;
import com.sk89q.jnbt.NBTUtils;
import com.sk89q.jnbt.ShortTag;
import com.sk89q.jnbt.StringTag;
import com.sk89q.jnbt.Tag;
import java.io.Closeable;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.Flushable;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Map;

public final class NBTOutputStream
implements Closeable {
    private DataOutput os;

    public NBTOutputStream(OutputStream os) throws IOException {
        this.os = new DataOutputStream(os);
    }

    public NBTOutputStream(DataOutput os) throws IOException {
        this.os = os;
    }

    public DataOutput getOutputStream() {
        return this.os;
    }

    public void setLittleEndian() {
        if (!(this.os instanceof LittleEndianOutputStream)) {
            this.os = new LittleEndianOutputStream((OutputStream)((Object)this.os));
        }
    }

    public void writeNamedTag(String name, Tag tag) throws IOException {
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkNotNull((Object)tag);
        int type = NBTUtils.getTypeCode(tag.getClass());
        this.writeNamedTagName(name, type);
        if (type == 0) {
            throw new IOException("Named TAG_End not permitted.");
        }
        this.writeTagPayload(tag);
    }

    public void writeNamedTag(String name, String value) throws IOException {
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkNotNull((Object)value);
        int type = 8;
        this.writeNamedTagName(name, type);
        byte[] bytes = value.getBytes(NBTConstants.CHARSET);
        this.os.writeShort(bytes.length);
        this.os.write(bytes);
    }

    public void writeNamedTag(String name, int value) throws IOException {
        Preconditions.checkNotNull((Object)name);
        int type = 3;
        this.writeNamedTagName(name, type);
        this.os.writeInt(value);
    }

    public void writeNamedTag(String name, byte value) throws IOException {
        Preconditions.checkNotNull((Object)name);
        int type = 1;
        this.writeNamedTagName(name, type);
        this.os.writeByte(value);
    }

    public void writeNamedTag(String name, short value) throws IOException {
        Preconditions.checkNotNull((Object)name);
        int type = 2;
        this.writeNamedTagName(name, type);
        this.os.writeShort(value);
    }

    public void writeNamedTag(String name, long value) throws IOException {
        Preconditions.checkNotNull((Object)name);
        int type = 4;
        this.writeNamedTagName(name, type);
        this.os.writeLong(value);
    }

    public void writeNamedTag(String name, byte[] bytes) throws IOException {
        Preconditions.checkNotNull((Object)name);
        int type = 7;
        this.writeNamedTagName(name, type);
        this.os.writeInt(bytes.length);
        this.os.write(bytes);
    }

    public void writeNamedTag(String name, int[] data) throws IOException {
        Preconditions.checkNotNull((Object)name);
        int type = 11;
        this.writeNamedTagName(name, type);
        this.os.writeInt(data.length);
        for (int aData : data) {
            this.os.writeInt(aData);
        }
    }

    public void writeNamedTag(String name, long[] data) throws IOException {
        Preconditions.checkNotNull((Object)name);
        int type = 12;
        this.writeNamedTagName(name, type);
        this.os.writeInt(data.length);
        for (long aData : data) {
            this.os.writeLong(aData);
        }
    }

    public void writeNamedEmptyList(String name) throws IOException {
        this.writeNamedEmptyList(name, 10);
    }

    public void writeNamedEmptyList(String name, int type) throws IOException {
        this.writeNamedTagName(name, 9);
        this.os.writeByte(type);
        this.os.writeInt(0);
    }

    public void writeNamedTagName(String name, int type) throws IOException {
        byte[] nameBytes = name.getBytes(NBTConstants.CHARSET);
        this.os.writeByte(type);
        this.os.writeShort(nameBytes.length);
        this.os.write(nameBytes);
    }

    public void writeLazyCompoundTag(String name, LazyWrite next) throws IOException {
        byte[] nameBytes = name.getBytes(NBTConstants.CHARSET);
        this.os.writeByte(10);
        this.os.writeShort(nameBytes.length);
        this.os.write(nameBytes);
        next.write(this);
        this.os.writeByte(0);
    }

    public void writeTag(Tag tag) throws IOException {
        int type = NBTUtils.getTypeCode(tag.getClass());
        this.os.writeByte(type);
        this.writeTagPayload(tag);
    }

    public void writeEndTag() throws IOException {
        this.os.writeByte(0);
    }

    public void writeTagPayload(Tag tag) throws IOException {
        int type = NBTUtils.getTypeCode(tag.getClass());
        switch (type) {
            case 0: {
                this.writeEndTagPayload((EndTag)tag);
                break;
            }
            case 1: {
                this.writeByteTagPayload((ByteTag)tag);
                break;
            }
            case 2: {
                this.writeShortTagPayload((ShortTag)tag);
                break;
            }
            case 3: {
                this.writeIntTagPayload((IntTag)tag);
                break;
            }
            case 4: {
                this.writeLongTagPayload((LongTag)tag);
                break;
            }
            case 5: {
                this.writeFloatTagPayload((FloatTag)tag);
                break;
            }
            case 6: {
                this.writeDoubleTagPayload((DoubleTag)tag);
                break;
            }
            case 7: {
                this.writeByteArrayTagPayload((ByteArrayTag)tag);
                break;
            }
            case 8: {
                this.writeStringTagPayload((StringTag)tag);
                break;
            }
            case 9: {
                this.writeListTagPayload((ListTag)tag);
                break;
            }
            case 10: {
                this.writeCompoundTagPayload((CompoundTag)tag);
                break;
            }
            case 11: {
                this.writeIntArrayTagPayload((IntArrayTag)tag);
                break;
            }
            case 12: {
                this.writeLongArrayTagPayload((LongArrayTag)tag);
                break;
            }
            default: {
                throw new IOException("Invalid tag type: " + type + ".");
            }
        }
    }

    private void writeByteTagPayload(ByteTag tag) throws IOException {
        this.os.writeByte(tag.getValue().byteValue());
    }

    private void writeByteArrayTagPayload(ByteArrayTag tag) throws IOException {
        byte[] bytes = tag.getValue();
        this.os.writeInt(bytes.length);
        this.os.write(bytes);
    }

    private void writeCompoundTagPayload(CompoundTag tag) throws IOException {
        for (Map.Entry entry : tag.getValue().entrySet()) {
            this.writeNamedTag((String)entry.getKey(), (Tag)entry.getValue());
        }
        this.os.writeByte(0);
    }

    private void writeListTagPayload(ListTag tag) throws IOException {
        Class<Object> clazz = tag.getType();
        if (clazz == null) {
            clazz = CompoundTag.class;
        }
        Object tags = tag.getValue();
        int size = tags.size();
        if (!tags.isEmpty()) {
            Tag tag0 = (Tag)tags.get(0);
            this.os.writeByte(NBTUtils.getTypeCode(tag0.getClass()));
        } else {
            this.os.writeByte(NBTUtils.getTypeCode(clazz));
        }
        this.os.writeInt(size);
        Iterator iterator = tags.iterator();
        while (iterator.hasNext()) {
            Tag tag1 = (Tag)iterator.next();
            this.writeTagPayload(tag1);
        }
    }

    private void writeStringTagPayload(StringTag tag) throws IOException {
        byte[] bytes = tag.getValue().getBytes(NBTConstants.CHARSET);
        this.os.writeShort(bytes.length);
        this.os.write(bytes);
    }

    private void writeDoubleTagPayload(DoubleTag tag) throws IOException {
        this.os.writeDouble(tag.getValue());
    }

    private void writeFloatTagPayload(FloatTag tag) throws IOException {
        this.os.writeFloat(tag.getValue().floatValue());
    }

    private void writeLongTagPayload(LongTag tag) throws IOException {
        this.os.writeLong(tag.getValue());
    }

    private void writeIntTagPayload(IntTag tag) throws IOException {
        this.os.writeInt(tag.getValue());
    }

    private void writeShortTagPayload(ShortTag tag) throws IOException {
        this.os.writeShort(tag.getValue().shortValue());
    }

    private void writeEndTagPayload(EndTag tag) {
    }

    private void writeIntArrayTagPayload(IntArrayTag tag) throws IOException {
        int[] data = tag.getValue();
        this.os.writeInt(data.length);
        for (int aData : data) {
            this.os.writeInt(aData);
        }
    }

    private void writeLongArrayTagPayload(LongArrayTag tag) throws IOException {
        long[] data = tag.getValue();
        this.os.writeInt(data.length);
        for (long aData : data) {
            this.os.writeLong(aData);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.os instanceof Closeable) {
            ((Closeable)((Object)this.os)).close();
        }
    }

    public void flush() throws IOException {
        if (this.os instanceof Flushable) {
            ((Flushable)((Object)this.os)).flush();
        }
    }

    public static interface LazyWrite {
        public void write(NBTOutputStream var1) throws IOException;
    }
}

