/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.util;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import sun.misc.Unsafe;

public class ReflectionUtils9 {
    public static <T extends Enum<?>> T addEnum(Class<T> enumType, String enumName) {
        Field[] fields;
        if (!Enum.class.isAssignableFrom(enumType)) {
            throw new RuntimeException("class " + enumType + " is not an instance of Enum");
        }
        Field valuesField = null;
        for (Field field : fields = enumType.getDeclaredFields()) {
            if (!field.getName().contains("$VALUES")) continue;
            valuesField = field;
            break;
        }
        AccessibleObject.setAccessible(new Field[]{valuesField}, true);
        try {
            Enum[] previousValues = (Enum[])valuesField.get(enumType);
            ArrayList<Enum> values = new ArrayList<Enum>(Arrays.asList(previousValues));
            Enum newValue = (Enum)ReflectionUtils9.makeEnum(enumType, enumName, values.size());
            values.add(newValue);
            try {
                ReflectionUtils9.setFailsafeFieldValue(valuesField, null, values.toArray((Enum[])Array.newInstance(enumType, 0)));
            }
            catch (Throwable e) {
                Field ordinalField = Enum.class.getDeclaredField("ordinal");
                ReflectionUtils9.setFailsafeFieldValue(ordinalField, newValue, 0);
            }
            ReflectionUtils9.cleanEnumCache(enumType);
            return (T)newValue;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static <T extends Enum<?>> void clearEnum(Class<T> enumType) {
        Field[] fields;
        if (!Enum.class.isAssignableFrom(enumType)) {
            throw new RuntimeException("class " + enumType + " is not an instance of Enum");
        }
        Field valuesField = null;
        for (Field field : fields = enumType.getDeclaredFields()) {
            if (!field.getName().contains("$VALUES")) continue;
            valuesField = field;
            break;
        }
        AccessibleObject.setAccessible(new Field[]{valuesField}, true);
        try {
            ReflectionUtils9.setFailsafeFieldValue(valuesField, null, Array.newInstance(enumType, 0));
            ReflectionUtils9.cleanEnumCache(enumType);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static Object makeEnum(Class<?> enumClass, String value, int ordinal) throws Exception {
        Constructor<?> constructor = Unsafe.class.getDeclaredConstructors()[0];
        constructor.setAccessible(true);
        Unsafe unsafe = (Unsafe)constructor.newInstance(new Object[0]);
        Object instance = unsafe.allocateInstance(enumClass);
        Field ordinalField = Enum.class.getDeclaredField("ordinal");
        ReflectionUtils9.setFailsafeFieldValue(ordinalField, instance, 0);
        Field nameField = Enum.class.getDeclaredField("name");
        ReflectionUtils9.setFailsafeFieldValue(nameField, instance, value);
        return instance;
    }

    public static void setFailsafeFieldValue(Field field, Object target, Object value) throws NoSuchFieldException, IllegalAccessException {
        field.setAccessible(true);
        if (Modifier.isFinal(field.getModifiers())) {
            Field modifiersField = Field.class.getDeclaredField("modifiers");
            modifiersField.setAccessible(true);
            int modifiers = modifiersField.getInt(field);
            modifiersField.setInt(field, modifiers &= 0xFFFFFFEF);
        }
        try {
            if (target == null) {
                field.set(null, value);
            } else {
                field.set(target, value);
            }
        }
        catch (NoSuchMethodError error) {
            field.set(target, value);
        }
    }

    private static void blankField(Class<?> enumClass, String fieldName) throws NoSuchFieldException, IllegalAccessException {
        for (Field field : Class.class.getDeclaredFields()) {
            if (!field.getName().contains(fieldName)) continue;
            AccessibleObject.setAccessible(new Field[]{field}, true);
            ReflectionUtils9.setFailsafeFieldValue(field, enumClass, null);
            break;
        }
    }

    private static void cleanEnumCache(Class<?> enumClass) throws NoSuchFieldException, IllegalAccessException {
        ReflectionUtils9.blankField(enumClass, "enumConstantDirectory");
        ReflectionUtils9.blankField(enumClass, "enumConstants");
    }
}

