/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.object.pattern;

import com.boydti.fawe.Fawe;
import com.boydti.fawe.util.TextureUtil;
import com.google.common.base.Preconditions;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.function.pattern.AbstractPattern;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import com.sk89q.worldedit.world.block.BlockType;
import java.io.IOException;
import java.io.ObjectInputStream;

public class ShadePattern
extends AbstractPattern {
    private transient TextureUtil util;
    private final Extent extent;
    private final boolean darken;

    public ShadePattern(Extent extent, boolean darken, TextureUtil util) {
        Preconditions.checkNotNull((Object)extent);
        this.extent = extent;
        this.util = util;
        this.darken = darken;
    }

    @Override
    public BlockStateHolder apply(Vector position) {
        BlockType block = this.extent.getBlockType(position);
        return (this.darken ? this.util.getDarkerBlock(block) : this.util.getLighterBlock(block)).getDefaultState();
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.util = Fawe.get().getCachedTextureUtil(true, 0, 100);
    }
}

