/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.object.pattern;

import com.boydti.fawe.Fawe;
import com.boydti.fawe.object.DataAnglePattern;
import com.boydti.fawe.util.TextureHolder;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import com.sk89q.worldedit.world.block.BlockTypes;
import java.io.IOException;
import java.io.ObjectInputStream;

public class AngleColorPattern
extends DataAnglePattern {
    protected transient TextureHolder util;

    public AngleColorPattern(Extent extent, TextureHolder util, int distance) {
        super(extent, distance);
        this.util = util;
    }

    public int getColor(int color, int slope) {
        if (slope == 0) {
            return color;
        }
        double newFactor = 1.0 - Math.min(1.0, (double)slope * this.FACTOR);
        int newRed = (int)((double)(color >> 16 & 0xFF) * newFactor);
        int newGreen = (int)((double)(color >> 8 & 0xFF) * newFactor);
        int newBlue = (int)((double)(color >> 0 & 0xFF) * newFactor);
        return ((color >> 24 & 0xFF) << 24) + (newRed << 16) + (newGreen << 8) + (newBlue << 0);
    }

    @Override
    public BlockStateHolder apply(Vector position) {
        BlockState block = this.extent.getBlock(position);
        int slope = this.getSlope(block, position);
        if (slope == -1) {
            return block;
        }
        int color = this.util.getTextureUtil().getColor(block.getBlockType());
        if (color == 0) {
            return block;
        }
        int newColor = this.getColor(color, slope);
        return this.util.getTextureUtil().getNearestBlock(newColor).getDefaultState();
    }

    @Override
    public int getSlope(BlockStateHolder block, Vector vector) {
        int slope = super.getSlope(block, vector);
        if (slope != -1) {
            BlockState below;
            int x = vector.getBlockX();
            int y = vector.getBlockY();
            int z = vector.getBlockZ();
            int height = this.extent.getNearestSurfaceTerrainBlock(x, z, y, 0, this.maxY);
            if (height > 0 && !(below = this.extent.getLazyBlock(x, height - 1, z)).getBlockType().getMaterial().isMovementBlocker()) {
                return Integer.MAX_VALUE;
            }
        }
        return slope;
    }

    @Override
    public boolean apply(Extent extent, Vector setPosition, Vector getPosition) throws WorldEditException {
        BlockState block = extent.getBlock(getPosition);
        int slope = this.getSlope(block, getPosition);
        if (slope == -1) {
            return false;
        }
        int color = this.util.getTextureUtil().getColor(block.getBlockType());
        if (color == 0) {
            return false;
        }
        int newColor = this.getColor(color, slope);
        BlockTypes newBlock = this.util.getTextureUtil().getNearestBlock(newColor);
        if (newBlock == null) {
            return false;
        }
        return extent.setBlock(setPosition, newBlock.getDefaultState());
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.util = Fawe.get().getCachedTextureUtil(true, 0, 100);
    }
}

