/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.object.clipboard.remap;

import com.boydti.fawe.object.clipboard.remap.WikiScraper;
import com.google.common.io.Resources;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.sk89q.jnbt.CompoundTag;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.blocks.BaseBlock;
import com.sk89q.worldedit.blocks.BaseItem;
import com.sk89q.worldedit.extent.clipboard.Clipboard;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import com.sk89q.worldedit.world.item.ItemTypes;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ClipboardRemapper {
    private final RemapPlatform from;
    private WikiScraper scraper;
    private char[] remapCombined = new char[65536];
    private boolean[] remap = new boolean[65536];
    private boolean[] remapIds = new boolean[4096];
    private boolean[] remapAllIds = new boolean[4096];
    private boolean[] remapAnyIds = new boolean[4096];
    private boolean[] remapData = new boolean[16];

    public ClipboardRemapper() {
        this.from = null;
    }

    public synchronized WikiScraper loadItemMapping() throws IOException {
        WikiScraper tmp = this.scraper;
        if (tmp == null) {
            this.scraper = tmp = new WikiScraper();
        }
        return tmp;
    }

    public BaseItem remapItem(String name, int damage) {
        return new BaseItem(ItemTypes.AIR);
    }

    public Map.Entry<String, Integer> remapItem(int id, int data) {
        throw new UnsupportedOperationException("TODO");
    }

    public int remapEntityId(String id) {
        try {
            Map<String, Integer> mappings = this.loadItemMapping().scapeOrCache(WikiScraper.Wiki.ENTITY_MAPPINGS);
            id = id.replace("minecraft:", "");
            Integer legacyId = mappings.get(id);
            if (legacyId != null) {
                return legacyId;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return -1;
    }

    public String remapBlockEntityId(String id) {
        if (this.from == null) {
            return id;
        }
        switch (this.from) {
            case PE: {
                switch (id) {
                    case "EnchantTable": {
                        return "minecraft:enchanting_table";
                    }
                    case "Music": {
                        return "minecraft:noteblock";
                    }
                    case "Chest": {
                        return "minecraft:trapped_chest";
                    }
                    case "ChalkboardBlock": {
                        return "minecraft:chalk_board_block";
                    }
                    case "FallingSand": {
                        return "minecraft:falling_block";
                    }
                    case "FireworksRocketEntity": {
                        return "minecraft:fireworks_rocket";
                    }
                    case "LavaSlime": {
                        return "minecraft:magma_cube";
                    }
                    case "MinecartChest": {
                        return "minecraft:chest_minecart";
                    }
                    case "MinecartCommandBlock": {
                        return "minecraft:commandblock_minecart";
                    }
                    case "MinecartFurnace": {
                        return "minecraft:furnace_minecart";
                    }
                    case "MinecartHopper": {
                        return "minecraft:hopper_minecart";
                    }
                    case "MinecartRideable": {
                        return "minecraft:minecart";
                    }
                    case "MinecartSpawner": {
                        return "minecraft:spawner_minecart";
                    }
                    case "MinecartTNT": {
                        return "minecraft:tnt_minecart";
                    }
                    case "MushroomCow": {
                        return "minecraft:mooshroom";
                    }
                    case "Ocelot": {
                        return "minecraft:ocelot";
                    }
                    case "PigZombie": {
                        return "minecraft:zombie_pigman";
                    }
                    case "PrimedTnt": {
                        return "minecraft:tnt";
                    }
                    case "SnowMan": {
                        return "minecraft:snowman";
                    }
                    case "ThrownEgg": {
                        return "minecraft:egg";
                    }
                    case "ThrownEnderpearl": {
                        return "minecraft:ender_pearl";
                    }
                    case "ThrownExpBottle": {
                        return "minecraft:xp_bottle";
                    }
                    case "ThrownPotion": {
                        return "minecraft:potion";
                    }
                    case "WitherBoss": {
                        return "minecraft:wither";
                    }
                    case "XPOrb": {
                        return "minecraft:xp_orb";
                    }
                }
                StringBuilder result = new StringBuilder("minecraft:");
                for (int i = 0; i < result.length(); ++i) {
                    char c = id.charAt(i);
                    if (Character.isUpperCase(c)) {
                        c = Character.toLowerCase(c);
                        if (i != 0) {
                            result.append('_');
                        }
                    }
                    result.append(c);
                }
                id = result.toString();
                return id;
            }
            case PC: {
                switch (id) {
                    case "minecraft:enchanting_table": {
                        return "EnchantTable";
                    }
                    case "minecraft:noteblock": {
                        return "Music";
                    }
                    case "minecraft:trapped_chest": {
                        return "Chest";
                    }
                    case "minecraft:chalk_board_block": {
                        return "ChalkboardBlock";
                    }
                    case "minecraft:falling_block": {
                        return "FallingSand";
                    }
                    case "minecraft:fireworks_rocket": {
                        return "FireworksRocketEntity";
                    }
                    case "minecraft:magma_cube": {
                        return "LavaSlime";
                    }
                    case "minecraft:chest_minecart": {
                        return "MinecartChest";
                    }
                    case "minecraft:commandblock_minecart": {
                        return "MinecartCommandBlock";
                    }
                    case "minecraft:furnace_minecart": {
                        return "MinecartFurnace";
                    }
                    case "minecraft:hopper_minecart": {
                        return "MinecartHopper";
                    }
                    case "minecraft:minecart": {
                        return "MinecartRideable";
                    }
                    case "minecraft:spawner_minecart": {
                        return "MinecartSpawner";
                    }
                    case "minecraft:tnt_minecart": {
                        return "MinecartTNT";
                    }
                    case "minecraft:mooshroom": {
                        return "MushroomCow";
                    }
                    case "minecraft:ocelot": {
                        return "Ocelot";
                    }
                    case "minecraft:zombie_pigman": {
                        return "PigZombie";
                    }
                    case "minecraft:tnt": {
                        return "PrimedTnt";
                    }
                    case "minecraft:snowman": {
                        return "SnowMan";
                    }
                    case "minecraft:egg": {
                        return "ThrownEgg";
                    }
                    case "minecraft:ender_pearl": {
                        return "ThrownEnderpearl";
                    }
                    case "minecraft:xp_bottle": {
                        return "ThrownExpBottle";
                    }
                    case "minecraft:potion": {
                        return "ThrownPotion";
                    }
                    case "minecraft:wither": {
                        return "WitherBoss";
                    }
                    case "minecraft:xp_orb": {
                        return "XPOrb";
                    }
                }
                id = id.replace("minecraft:", "");
                CharSequence result = new StringBuilder();
                boolean toUpper = false;
                for (int i = 0; i < id.length(); ++i) {
                    char c = id.charAt(i);
                    if (i == 0) {
                        toUpper = true;
                    }
                    if (c == '_') {
                        toUpper = true;
                        continue;
                    }
                    ((StringBuilder)result).append(toUpper ? Character.toUpperCase(c) : c);
                    toUpper = false;
                }
                id = ((StringBuilder)result).toString();
                return id;
            }
        }
        return id;
    }

    private Map<String, List<Integer>> parse(File file) throws IOException {
        JsonParser parser = new JsonParser();
        JsonObject toParse = (JsonObject)parser.parse(Resources.toString((URL)file.toURL(), (Charset)Charset.defaultCharset()));
        HashMap<String, List<Integer>> map = new HashMap<String, List<Integer>>();
        return map;
    }

    private HashMap<BaseBlock, BaseBlock> getPEtoPCMappings() {
        int data;
        int data2;
        HashMap<BaseBlock, BaseBlock> mapPEtoPC = new HashMap<BaseBlock, BaseBlock>();
        mapPEtoPC.put(new BaseBlock(281, -1), new BaseBlock(25, -1));
        mapPEtoPC.put(new BaseBlock(95, -1), new BaseBlock(166, -1));
        mapPEtoPC.put(new BaseBlock(125, -1), new BaseBlock(158, -1));
        mapPEtoPC.put(new BaseBlock(126, -1), new BaseBlock(157, -1));
        mapPEtoPC.put(new BaseBlock(157, -1), new BaseBlock(125, -1));
        mapPEtoPC.put(new BaseBlock(158, -1), new BaseBlock(126, -1));
        mapPEtoPC.put(new BaseBlock(188, -1), new BaseBlock(210, -1));
        mapPEtoPC.put(new BaseBlock(189, -1), new BaseBlock(211, -1));
        mapPEtoPC.put(new BaseBlock(155, 4), new BaseBlock(155, 10));
        mapPEtoPC.put(new BaseBlock(155, 3), new BaseBlock(155, 6));
        mapPEtoPC.put(new BaseBlock(198, -1), new BaseBlock(208, -1));
        mapPEtoPC.put(new BaseBlock(207, -1), new BaseBlock(212, -1));
        mapPEtoPC.put(new BaseBlock(244, 2), new BaseBlock(207, 1));
        mapPEtoPC.put(new BaseBlock(244, 4), new BaseBlock(207, 2));
        mapPEtoPC.put(new BaseBlock(244, 7), new BaseBlock(207, 3));
        for (data2 = 3; data2 < 16; ++data2) {
            mapPEtoPC.putIfAbsent(new BaseBlock(244, data2), new BaseBlock(207, data2));
        }
        for (data2 = 0; data2 < 16; ++data2) {
            mapPEtoPC.put(new BaseBlock(218, data2), new BaseBlock(219 + data2, -1));
        }
        mapPEtoPC.put(new BaseBlock(220, -1), new BaseBlock(235, -1));
        mapPEtoPC.put(new BaseBlock(220, -1), new BaseBlock(235, -1));
        mapPEtoPC.put(new BaseBlock(221, -1), new BaseBlock(236, -1));
        mapPEtoPC.put(new BaseBlock(222, -1), new BaseBlock(237, -1));
        mapPEtoPC.put(new BaseBlock(223, -1), new BaseBlock(238, -1));
        mapPEtoPC.put(new BaseBlock(224, -1), new BaseBlock(239, -1));
        mapPEtoPC.put(new BaseBlock(225, -1), new BaseBlock(240, -1));
        mapPEtoPC.put(new BaseBlock(226, -1), new BaseBlock(241, -1));
        mapPEtoPC.put(new BaseBlock(227, -1), new BaseBlock(242, -1));
        mapPEtoPC.put(new BaseBlock(228, -1), new BaseBlock(243, -1));
        mapPEtoPC.put(new BaseBlock(229, -1), new BaseBlock(244, -1));
        mapPEtoPC.put(new BaseBlock(231, -1), new BaseBlock(246, -1));
        mapPEtoPC.put(new BaseBlock(232, -1), new BaseBlock(247, -1));
        mapPEtoPC.put(new BaseBlock(233, -1), new BaseBlock(248, -1));
        mapPEtoPC.put(new BaseBlock(234, -1), new BaseBlock(249, -1));
        for (int id = 220; id <= 235; ++id) {
            int pcId = id + 15;
            int peId = id == 230 ? 219 : id;
            mapPEtoPC.put(new BaseBlock(peId, 3), new BaseBlock(pcId, 0));
            mapPEtoPC.put(new BaseBlock(peId, 4), new BaseBlock(pcId, 1));
            mapPEtoPC.put(new BaseBlock(peId, 2), new BaseBlock(pcId, 2));
            mapPEtoPC.put(new BaseBlock(peId, 5), new BaseBlock(pcId, 3));
        }
        for (int id : new int[]{29, 33, 34}) {
            mapPEtoPC.put(new BaseBlock(id, 3), new BaseBlock(id, 2));
            mapPEtoPC.put(new BaseBlock(id, 2), new BaseBlock(id, 3));
            mapPEtoPC.put(new BaseBlock(id, 5), new BaseBlock(id, 4));
            mapPEtoPC.put(new BaseBlock(id, 4), new BaseBlock(id, 5));
        }
        mapPEtoPC.put(new BaseBlock(250, -1), new BaseBlock(36, -1));
        mapPEtoPC.put(new BaseBlock(236, -1), new BaseBlock(251, -1));
        mapPEtoPC.put(new BaseBlock(237, -1), new BaseBlock(252, -1));
        mapPEtoPC.put(new BaseBlock(240, -1), new BaseBlock(199, -1));
        mapPEtoPC.put(new BaseBlock(241, -1), new BaseBlock(95, -1));
        mapPEtoPC.put(new BaseBlock(243, 0), new BaseBlock(3, 2));
        mapPEtoPC.put(new BaseBlock(251, -1), new BaseBlock(218, -1));
        mapPEtoPC.put(new BaseBlock(168, 2), new BaseBlock(168, 1));
        mapPEtoPC.put(new BaseBlock(168, 1), new BaseBlock(168, 2));
        mapPEtoPC.put(new BaseBlock(44, 7), new BaseBlock(44, 6));
        mapPEtoPC.put(new BaseBlock(44, 6), new BaseBlock(44, 7));
        mapPEtoPC.put(new BaseBlock(44, 15), new BaseBlock(44, 14));
        mapPEtoPC.put(new BaseBlock(44, 14), new BaseBlock(44, 15));
        mapPEtoPC.put(new BaseBlock(43, 7), new BaseBlock(43, 6));
        mapPEtoPC.put(new BaseBlock(43, 6), new BaseBlock(43, 7));
        mapPEtoPC.put(new BaseBlock(36, -1), new BaseBlock(34, 1));
        mapPEtoPC.put(new BaseBlock(85, 1), new BaseBlock(188, -1));
        mapPEtoPC.put(new BaseBlock(85, 2), new BaseBlock(189, -1));
        mapPEtoPC.put(new BaseBlock(85, 3), new BaseBlock(190, -1));
        mapPEtoPC.put(new BaseBlock(85, 4), new BaseBlock(192, -1));
        mapPEtoPC.put(new BaseBlock(85, 5), new BaseBlock(191, -1));
        mapPEtoPC.put(new BaseBlock(202, -1), new BaseBlock(203, 2));
        mapPEtoPC.put(new BaseBlock(201, 2), new BaseBlock(202, 0));
        mapPEtoPC.put(new BaseBlock(201, 10), new BaseBlock(202, 8));
        mapPEtoPC.put(new BaseBlock(201, 6), new BaseBlock(202, 4));
        mapPEtoPC.put(new BaseBlock(181, 1), new BaseBlock(204, -1));
        for (int data3 = 0; data3 < 16; ++data3) {
            mapPEtoPC.put(new BaseBlock(208, data3), new BaseBlock(198, data3));
        }
        mapPEtoPC.put(new BaseBlock(208, 4), new BaseBlock(198, 5));
        mapPEtoPC.put(new BaseBlock(208, 2), new BaseBlock(198, 3));
        mapPEtoPC.put(new BaseBlock(208, 5), new BaseBlock(198, 4));
        mapPEtoPC.put(new BaseBlock(208, 3), new BaseBlock(198, 2));
        for (int id : new int[]{77, 143}) {
            mapPEtoPC.put(new BaseBlock(id, 4), new BaseBlock(id, 2));
            mapPEtoPC.put(new BaseBlock(id, 1), new BaseBlock(id, 5));
            mapPEtoPC.put(new BaseBlock(id, 2), new BaseBlock(id, 4));
            mapPEtoPC.put(new BaseBlock(id, 5), new BaseBlock(id, 1));
            mapPEtoPC.put(new BaseBlock(id, 13), new BaseBlock(id, 9));
            mapPEtoPC.put(new BaseBlock(id, 12), new BaseBlock(id, 10));
            mapPEtoPC.put(new BaseBlock(id, 10), new BaseBlock(id, 12));
            mapPEtoPC.put(new BaseBlock(id, 9), new BaseBlock(id, 13));
        }
        for (data = 4; data < 8; ++data) {
            mapPEtoPC.put(new BaseBlock(18, data + 4), new BaseBlock(18, data));
        }
        for (data = 4; data < 8; ++data) {
            mapPEtoPC.put(new BaseBlock(18, data + 8), new BaseBlock(161, data));
        }
        for (int id : new int[]{96, 167}) {
            int data4;
            mapPEtoPC.put(new BaseBlock(id, 2), new BaseBlock(id, 0));
            mapPEtoPC.put(new BaseBlock(id, 3), new BaseBlock(id, 1));
            mapPEtoPC.put(new BaseBlock(id, 6), new BaseBlock(id, 8));
            mapPEtoPC.put(new BaseBlock(id, 7), new BaseBlock(id, 9));
            for (data4 = 0; data4 < 4; ++data4) {
                mapPEtoPC.putIfAbsent(new BaseBlock(id, data4), new BaseBlock(id, 3 - data4));
            }
            for (data4 = 4; data4 < 12; ++data4) {
                mapPEtoPC.putIfAbsent(new BaseBlock(id, data4), new BaseBlock(id, 15 - data4));
            }
            for (data4 = 12; data4 < 16; ++data4) {
                mapPEtoPC.putIfAbsent(new BaseBlock(id, data4), new BaseBlock(id, 27 - data4));
            }
        }
        return mapPEtoPC;
    }

    public ClipboardRemapper(RemapPlatform fromPlatform, RemapPlatform toPlatform) {
        if (fromPlatform == toPlatform) {
            this.from = null;
            return;
        }
        HashMap<BaseBlock, BaseBlock> mapPEtoPC = this.getPEtoPCMappings();
        for (Map.Entry<BaseBlock, BaseBlock> entry : mapPEtoPC.entrySet()) {
            BaseBlock from = entry.getKey();
            BaseBlock to = entry.getValue();
            if (fromPlatform == RemapPlatform.PE) {
                this.add(from, to);
                continue;
            }
            this.add(to, from);
        }
        switch (fromPlatform) {
            case PE: {
                int data;
                for (data = 0; data < 8; ++data) {
                    this.add(new BaseBlock(182, 1), new BaseBlock(205, data));
                }
                for (data = 8; data < 16; ++data) {
                    this.add(new BaseBlock(182, 9), new BaseBlock(205, data));
                }
                for (data = 0; data < 8; ++data) {
                    this.add(new BaseBlock(182, 0), new BaseBlock(182, data));
                }
                for (data = 8; data < 16; ++data) {
                    this.add(new BaseBlock(182, 8), new BaseBlock(182, data));
                }
                break;
            }
            case PC: {
                int data;
                this.add(new BaseBlock(202, -1), new BaseBlock(201, -1));
                this.add(new BaseBlock(204, -1), new BaseBlock(201, -1));
                for (data = 0; data < 8; ++data) {
                    this.add(new BaseBlock(205, data), new BaseBlock(182, 1));
                }
                for (data = 8; data < 16; ++data) {
                    this.add(new BaseBlock(205, data), new BaseBlock(182, 9));
                }
                for (data = 0; data < 8; ++data) {
                    this.add(new BaseBlock(182, data), new BaseBlock(182, 0));
                }
                for (data = 8; data < 16; ++data) {
                    this.add(new BaseBlock(182, data), new BaseBlock(182, 8));
                }
                for (int id : new int[]{29, 33, 34}) {
                    for (int data2 = 8; data2 < 16; ++data2) {
                        this.add(new BaseBlock(id, data2), this.remap(new BaseBlock(id, data2 - 8)));
                    }
                }
                break;
            }
        }
        this.from = fromPlatform;
    }

    public void addBoth(BaseBlock from, BaseBlock to) {
        this.add(from, to);
        this.add(to, from);
    }

    public void apply(Clipboard clipboard) throws WorldEditException {
    }

    public boolean hasRemapData(int data) {
        return this.remapData[data];
    }

    public boolean hasRemapId(int id) {
        return this.remapAnyIds[id];
    }

    public boolean hasRemap(int id) {
        return this.remapIds[id];
    }

    public int remapId(int id) {
        if (this.remapAllIds[id]) {
            return this.remapCombined[id << 4] >> 4;
        }
        return id;
    }

    public void add(BlockStateHolder from, BlockStateHolder to) {
    }

    public BlockStateHolder remap(BlockStateHolder block) {
        return block;
    }

    public void remap(CompoundTag tag) {
    }

    public static enum RemapPlatform {
        PE,
        PC;


        public RemapPlatform opposite() {
            return this == PE ? PC : PE;
        }
    }
}

