/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.object.clipboard;

import com.boydti.fawe.object.PseudoRandom;
import com.boydti.fawe.object.clipboard.DiskOptimizedClipboard;
import com.boydti.fawe.object.clipboard.EmptyClipboard;
import com.boydti.fawe.object.clipboard.FaweClipboard;
import com.boydti.fawe.object.clipboard.URIClipboardHolder;
import com.google.common.base.Preconditions;
import com.sk89q.worldedit.extent.clipboard.BlockArrayClipboard;
import com.sk89q.worldedit.extent.clipboard.Clipboard;
import com.sk89q.worldedit.session.ClipboardHolder;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;

public class MultiClipboardHolder
extends URIClipboardHolder {
    private final List<URIClipboardHolder> holders = new ArrayList<URIClipboardHolder>();
    private Clipboard[] cached;

    public MultiClipboardHolder() {
        this(URI.create(""));
    }

    public MultiClipboardHolder(URI uri) {
        super(uri, EmptyClipboard.INSTANCE);
    }

    public MultiClipboardHolder(URI uri, URIClipboardHolder ... addHolders) {
        this(uri);
        for (URIClipboardHolder h : addHolders) {
            this.add(h);
        }
    }

    public MultiClipboardHolder(Clipboard clipboard) {
        super(URI.create(""), EmptyClipboard.INSTANCE);
        FaweClipboard fc;
        URI uri = URI.create("");
        if (clipboard instanceof BlockArrayClipboard && (fc = ((BlockArrayClipboard)clipboard).IMP) instanceof DiskOptimizedClipboard) {
            uri = ((DiskOptimizedClipboard)fc).getFile().toURI();
        }
        this.add(uri, clipboard);
    }

    public void remove(URI uri) {
        this.cached = null;
        if (this.getUri().equals(uri)) {
            for (ClipboardHolder clipboardHolder : this.holders) {
                clipboardHolder.close();
            }
            this.holders.clear();
            return;
        }
        for (int i = this.holders.size() - 1; i >= 0; --i) {
            URIClipboardHolder uRIClipboardHolder = this.holders.get(i);
            if (!uRIClipboardHolder.contains(uri)) continue;
            if (uRIClipboardHolder instanceof MultiClipboardHolder) {
                ((MultiClipboardHolder)uRIClipboardHolder).remove(uri);
                continue;
            }
            this.holders.remove(i).close();
        }
    }

    @Override
    public URI getURI(Clipboard clipboard) {
        for (ClipboardHolder holder : this.getHolders()) {
            URIClipboardHolder uriHolder;
            URI uri;
            if (!(holder instanceof URIClipboardHolder) || (uri = (uriHolder = (URIClipboardHolder)holder).getURI(clipboard)) == null) continue;
            return uri;
        }
        return null;
    }

    public void add(URIClipboardHolder holder) {
        this.add((ClipboardHolder)holder);
    }

    @Override
    public boolean contains(Clipboard clipboard) {
        for (ClipboardHolder clipboardHolder : this.holders) {
            if (!clipboardHolder.contains(clipboard)) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    public void add(ClipboardHolder holder) {
        Preconditions.checkNotNull((Object)holder);
        if (holder instanceof URIClipboardHolder) {
            this.holders.add((URIClipboardHolder)holder);
        } else {
            URI uri = URI.create(UUID.randomUUID().toString());
            if (!this.contains(uri)) {
                this.holders.add(new URIClipboardHolder(uri, holder.getClipboard()));
            }
        }
        this.cached = null;
    }

    public void add(URI uri, Clipboard clip) {
        Preconditions.checkNotNull((Object)clip);
        Preconditions.checkNotNull((Object)uri);
        this.add(new URIClipboardHolder(uri, clip));
    }

    @Override
    public List<Clipboard> getClipboards() {
        ArrayList<Clipboard> all = new ArrayList<Clipboard>();
        for (ClipboardHolder clipboardHolder : this.holders) {
            all.addAll(clipboardHolder.getClipboards());
        }
        return all;
    }

    @Override
    public List<ClipboardHolder> getHolders() {
        ArrayList<ClipboardHolder> holders = new ArrayList<ClipboardHolder>();
        for (ClipboardHolder clipboardHolder : this.holders) {
            holders.addAll(clipboardHolder.getHolders());
        }
        return holders;
    }

    @Override
    public boolean contains(URI uri) {
        if (this.getUri().equals(uri)) {
            return true;
        }
        for (URIClipboardHolder uch : this.holders) {
            if (!uch.contains(uri)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Clipboard getClipboard() {
        Clipboard[] available = this.cached;
        if (available == null) {
            this.cached = available = this.getClipboards().toArray(new Clipboard[0]);
        }
        switch (available.length) {
            case 0: {
                return EmptyClipboard.INSTANCE;
            }
            case 1: {
                return available[0];
            }
        }
        int index = PseudoRandom.random.nextInt(available.length);
        return available[index];
    }

    @Override
    public Set<URI> getURIs() {
        HashSet<URI> set = new HashSet<URI>();
        for (ClipboardHolder holder : this.getHolders()) {
            URI uri;
            if (!(holder instanceof URIClipboardHolder) || (uri = ((URIClipboardHolder)holder).getUri()).toString().isEmpty()) continue;
            set.add(uri);
        }
        return set;
    }

    @Override
    public void close() {
        this.cached = null;
        for (ClipboardHolder clipboardHolder : this.holders) {
            clipboardHolder.close();
        }
    }
}

