/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.object.changeset;

import com.boydti.fawe.Fawe;
import com.boydti.fawe.object.FaweQueue;
import com.boydti.fawe.object.HasFaweQueue;
import com.boydti.fawe.object.RegionWrapper;
import com.boydti.fawe.util.ExtentTraverser;
import com.boydti.fawe.util.MainUtil;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.history.UndoContext;
import com.sk89q.worldedit.history.change.Change;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;

public class MutableAnvilChange
implements Change {
    private Path source;
    private Path destDir;
    private FaweQueue queue;
    private boolean checkedQueue;

    public void setSource(Path source) {
        this.source = source;
    }

    @Override
    public void undo(UndoContext context) throws WorldEditException {
        if (this.queue != null) {
            this.perform(this.queue);
        }
        if (!this.checkedQueue) {
            this.checkedQueue = true;
            Extent extent = context.getExtent();
            ExtentTraverser<HasFaweQueue> found = new ExtentTraverser<Extent>(extent).find(HasFaweQueue.class);
            if (found != null) {
                this.queue = found.get().getQueue();
                this.destDir = this.queue.getSaveFolder().toPath();
                this.perform(this.queue);
            } else {
                Fawe.debug("FAWE does not support: " + extent + " for " + this.getClass() + " (bug Empire92)");
            }
        }
    }

    public void perform(FaweQueue queue) {
        final Path dest = this.destDir.resolve(this.source.getFileName());
        try {
            Files.move(this.source, dest, StandardCopyOption.ATOMIC_MOVE);
        }
        catch (IOException ignore) {
            int[] coords = MainUtil.regionNameToCoords(this.source.toString());
            queue.setMCA(coords[0], coords[1], RegionWrapper.GLOBAL(), new Runnable(){

                @Override
                public void run() {
                    try {
                        Files.move(MutableAnvilChange.this.source, dest, StandardCopyOption.ATOMIC_MOVE);
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                }
            }, false, true);
        }
    }

    @Override
    public void redo(UndoContext context) throws WorldEditException {
        throw new UnsupportedOperationException("Redo not supported");
    }
}

