/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.object.changeset;

import com.boydti.fawe.Fawe;
import com.boydti.fawe.config.Settings;
import com.boydti.fawe.database.DBHandler;
import com.boydti.fawe.database.RollbackDatabase;
import com.boydti.fawe.object.FaweInputStream;
import com.boydti.fawe.object.FaweOutputStream;
import com.boydti.fawe.object.FawePlayer;
import com.boydti.fawe.object.IntegerPair;
import com.boydti.fawe.object.RegionWrapper;
import com.boydti.fawe.object.changeset.FaweStreamChangeSet;
import com.boydti.fawe.util.MainUtil;
import com.sk89q.jnbt.NBTInputStream;
import com.sk89q.jnbt.NBTOutputStream;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.world.World;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Map;
import java.util.UUID;

public class DiskStorageHistory
extends FaweStreamChangeSet {
    private UUID uuid;
    private File bdFile;
    private File bioFile;
    private File nbtfFile;
    private File nbttFile;
    private File entfFile;
    private File enttFile;
    private FaweOutputStream osBD;
    private FaweOutputStream osBIO;
    private NBTOutputStream osNBTF;
    private NBTOutputStream osNBTT;
    private NBTOutputStream osENTCF;
    private NBTOutputStream osENTCT;
    private int index;

    public DiskStorageHistory(World world, UUID uuid) {
        super(world);
        this.init(uuid, Fawe.imp().getWorldName(world));
    }

    public DiskStorageHistory(String world, UUID uuid) {
        super(world);
        this.init(uuid, world);
    }

    private void init(UUID uuid, String worldName) {
        File folder = MainUtil.getFile(Fawe.imp().getDirectory(), Settings.IMP.PATHS.HISTORY + File.separator + worldName + File.separator + uuid);
        int max = MainUtil.getMaxFileId(folder);
        this.init(uuid, max);
    }

    public DiskStorageHistory(String world, UUID uuid, int index) {
        super(world);
        this.init(uuid, index);
    }

    public DiskStorageHistory(World world, UUID uuid, int index) {
        super(world);
        this.init(uuid, index);
    }

    public DiskStorageHistory(File folder, World world, UUID uuid, int i) {
        super(world);
        this.uuid = uuid;
        this.index = i;
        this.initFiles(folder);
    }

    public DiskStorageHistory(File folder, String world, UUID uuid, int i) {
        super(world);
        this.uuid = uuid;
        this.index = i;
        this.initFiles(folder);
    }

    private void initFiles(File folder) {
        this.nbtfFile = new File(folder, this.index + ".nbtf");
        this.nbttFile = new File(folder, this.index + ".nbtt");
        this.entfFile = new File(folder, this.index + ".entf");
        this.enttFile = new File(folder, this.index + ".entt");
        this.bdFile = new File(folder, this.index + ".bd");
        this.bioFile = new File(folder, this.index + ".bio");
    }

    private void init(UUID uuid, int i) {
        this.uuid = uuid;
        this.index = i;
        File folder = MainUtil.getFile(Fawe.imp().getDirectory(), Settings.IMP.PATHS.HISTORY + File.separator + Fawe.imp().getWorldName(this.getWorld()) + File.separator + uuid);
        this.initFiles(folder);
    }

    @Override
    public void delete() {
        Fawe.debug("Deleting history: " + Fawe.imp().getWorldName(this.getWorld()) + "/" + this.uuid + "/" + this.index);
        this.deleteFiles();
        if (Settings.IMP.HISTORY.USE_DATABASE) {
            RollbackDatabase db = DBHandler.IMP.getDatabase(this.getWorld());
            db.delete(this.uuid, this.index);
        }
    }

    public void deleteFiles() {
        this.bdFile.delete();
        this.nbtfFile.delete();
        this.nbttFile.delete();
        this.entfFile.delete();
        this.enttFile.delete();
    }

    public void undo(FawePlayer fp, Region[] regions) {
        EditSession session = this.toEditSession(fp, regions);
        session.undo(session);
        this.deleteFiles();
    }

    public void undo(FawePlayer fp) {
        this.undo(fp, null);
    }

    public void redo(FawePlayer fp, Region[] regions) {
        EditSession session = this.toEditSession(fp, regions);
        session.redo(session);
    }

    public void redo(FawePlayer fp) {
        this.undo(fp, null);
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public File getBDFile() {
        return this.bdFile;
    }

    public int getIndex() {
        return this.index;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean flush() {
        super.flush();
        DiskStorageHistory diskStorageHistory = this;
        synchronized (diskStorageHistory) {
            boolean flushed = this.osBD != null || this.osBIO != null || this.osNBTF != null || this.osNBTT != null && this.osENTCF != null || this.osENTCT != null;
            try {
                if (this.osBD != null) {
                    this.osBD.flush();
                }
                if (this.osBIO != null) {
                    this.osBIO.flush();
                }
                if (this.osNBTF != null) {
                    this.osNBTF.flush();
                }
                if (this.osNBTT != null) {
                    this.osNBTT.flush();
                }
                if (this.osENTCF != null) {
                    this.osENTCF.flush();
                }
                if (this.osENTCT != null) {
                    this.osENTCT.flush();
                }
            }
            catch (Exception e) {
                MainUtil.handleError(e);
            }
            return flushed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean close() {
        super.close();
        DiskStorageHistory diskStorageHistory = this;
        synchronized (diskStorageHistory) {
            boolean flushed = this.osBD != null || this.osBIO != null || this.osNBTF != null || this.osNBTT != null && this.osENTCF != null || this.osENTCT != null;
            try {
                if (this.osBD != null) {
                    this.osBD.close();
                    this.osBD = null;
                }
                if (this.osBIO != null) {
                    this.osBIO.close();
                    this.osBIO = null;
                }
                if (this.osNBTF != null) {
                    this.osNBTF.close();
                    this.osNBTF = null;
                }
                if (this.osNBTT != null) {
                    this.osNBTT.close();
                    this.osNBTT = null;
                }
                if (this.osENTCF != null) {
                    this.osENTCF.close();
                    this.osENTCF = null;
                }
                if (this.osENTCT != null) {
                    this.osENTCT.close();
                    this.osENTCT = null;
                }
            }
            catch (Exception e) {
                MainUtil.handleError(e);
            }
            return flushed;
        }
    }

    @Override
    public int getCompressedSize() {
        return this.bdFile.exists() ? (int)this.bdFile.length() : 0;
    }

    @Override
    public long getSizeInMemory() {
        return 80L;
    }

    @Override
    public long getSizeOnDisk() {
        int total = 0;
        if (this.bdFile.exists()) {
            total = (int)((long)total + this.bdFile.length());
        }
        if (this.bioFile.exists()) {
            total = (int)((long)total + this.bioFile.length());
        }
        if (this.nbtfFile.exists()) {
            total = (int)((long)total + this.entfFile.length());
        }
        if (this.nbttFile.exists()) {
            total = (int)((long)total + this.entfFile.length());
        }
        if (this.entfFile.exists()) {
            total = (int)((long)total + this.entfFile.length());
        }
        if (this.enttFile.exists()) {
            total = (int)((long)total + this.entfFile.length());
        }
        return total;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FaweOutputStream getBlockOS(int x, int y, int z) throws IOException {
        if (this.osBD != null) {
            return this.osBD;
        }
        DiskStorageHistory diskStorageHistory = this;
        synchronized (diskStorageHistory) {
            this.bdFile.getParentFile().mkdirs();
            this.bdFile.createNewFile();
            this.osBD = this.getCompressedOS(new FileOutputStream(this.bdFile));
            this.writeHeader(this.osBD, x, y, z);
            return this.osBD;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FaweOutputStream getBiomeOS() throws IOException {
        if (this.osBIO != null) {
            return this.osBIO;
        }
        DiskStorageHistory diskStorageHistory = this;
        synchronized (diskStorageHistory) {
            this.bioFile.getParentFile().mkdirs();
            this.bioFile.createNewFile();
            this.osBIO = this.getCompressedOS(new FileOutputStream(this.bioFile));
            return this.osBIO;
        }
    }

    @Override
    public NBTOutputStream getEntityCreateOS() throws IOException {
        if (this.osENTCT != null) {
            return this.osENTCT;
        }
        this.enttFile.getParentFile().mkdirs();
        this.enttFile.createNewFile();
        this.osENTCT = new NBTOutputStream(this.getCompressedOS(new FileOutputStream(this.enttFile)));
        return this.osENTCT;
    }

    @Override
    public NBTOutputStream getEntityRemoveOS() throws IOException {
        if (this.osENTCF != null) {
            return this.osENTCF;
        }
        this.entfFile.getParentFile().mkdirs();
        this.entfFile.createNewFile();
        this.osENTCF = new NBTOutputStream(this.getCompressedOS(new FileOutputStream(this.entfFile)));
        return this.osENTCF;
    }

    @Override
    public NBTOutputStream getTileCreateOS() throws IOException {
        if (this.osNBTT != null) {
            return this.osNBTT;
        }
        this.nbttFile.getParentFile().mkdirs();
        this.nbttFile.createNewFile();
        this.osNBTT = new NBTOutputStream(this.getCompressedOS(new FileOutputStream(this.nbttFile)));
        return this.osNBTT;
    }

    @Override
    public NBTOutputStream getTileRemoveOS() throws IOException {
        if (this.osNBTF != null) {
            return this.osNBTF;
        }
        this.nbtfFile.getParentFile().mkdirs();
        this.nbtfFile.createNewFile();
        this.osNBTF = new NBTOutputStream(this.getCompressedOS(new FileOutputStream(this.nbtfFile)));
        return this.osNBTF;
    }

    @Override
    public FaweInputStream getBlockIS() throws IOException {
        if (!this.bdFile.exists()) {
            return null;
        }
        FaweInputStream is = MainUtil.getCompressedIS(new FileInputStream(this.bdFile));
        this.readHeader(is);
        return is;
    }

    @Override
    public FaweInputStream getBiomeIS() throws IOException {
        if (!this.bioFile.exists()) {
            return null;
        }
        FaweInputStream is = MainUtil.getCompressedIS(new FileInputStream(this.bioFile));
        return is;
    }

    @Override
    public NBTInputStream getEntityCreateIS() throws IOException {
        if (!this.enttFile.exists()) {
            return null;
        }
        return new NBTInputStream(MainUtil.getCompressedIS(new FileInputStream(this.enttFile)));
    }

    @Override
    public NBTInputStream getEntityRemoveIS() throws IOException {
        if (!this.entfFile.exists()) {
            return null;
        }
        return new NBTInputStream(MainUtil.getCompressedIS(new FileInputStream(this.entfFile)));
    }

    @Override
    public NBTInputStream getTileCreateIS() throws IOException {
        if (!this.nbttFile.exists()) {
            return null;
        }
        return new NBTInputStream(MainUtil.getCompressedIS(new FileInputStream(this.nbttFile)));
    }

    @Override
    public NBTInputStream getTileRemoveIS() throws IOException {
        if (!this.nbtfFile.exists()) {
            return null;
        }
        return new NBTInputStream(MainUtil.getCompressedIS(new FileInputStream(this.nbtfFile)));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DiskStorageSummary summarize(RegionWrapper requiredRegion, boolean shallow) {
        if (!this.bdFile.exists()) return null;
        int ox = this.getOriginX();
        int oz = this.getOriginZ();
        if (!(ox == 0 && oz == 0 || requiredRegion.isIn(ox, oz))) {
            return new DiskStorageSummary(ox, oz);
        }
        try (FileInputStream fis = new FileInputStream(this.bdFile);){
            FaweInputStream gis = MainUtil.getCompressedIS(fis);
            gis.skipFully(1);
            ox = (gis.read() << 24) + (gis.read() << 16) + (gis.read() << 8) + (gis.read() << 0);
            oz = (gis.read() << 24) + (gis.read() << 16) + (gis.read() << 8) + (gis.read() << 0);
            this.setOrigin(ox, oz);
            DiskStorageSummary summary = new DiskStorageSummary(ox, oz);
            if (!requiredRegion.isIn(ox, oz)) {
                fis.close();
                gis.close();
                DiskStorageSummary diskStorageSummary = summary;
                return diskStorageSummary;
            }
            byte[] buffer = new byte[4];
            int i = 0;
            int amount = (Settings.IMP.HISTORY.BUFFER_SIZE - 9) / 9;
            while (!shallow && ++i < amount) {
                if (gis.read(buffer) == -1) {
                    fis.close();
                    gis.close();
                    DiskStorageSummary diskStorageSummary = summary;
                    return diskStorageSummary;
                }
                int x = (buffer[0] & 0xFF) + (buffer[1] << 8) + ox;
                int z = (buffer[2] & 0xFF) + (buffer[3] << 8) + oz;
                int from = gis.readVarInt();
                int to = gis.readVarInt();
                summary.add(x, z, to);
            }
            DiskStorageSummary diskStorageSummary = summary;
            return diskStorageSummary;
        }
        catch (IOException e) {
            MainUtil.handleError(e);
        }
        return null;
    }

    public IntegerPair readHeader() {
        int ox = this.getOriginX();
        int oz = this.getOriginZ();
        if (ox == 0 && oz == 0 && this.bdFile.exists()) {
            try (FileInputStream fis = new FileInputStream(this.bdFile);){
                FaweInputStream gis = MainUtil.getCompressedIS(fis);
                gis.skipFully(1);
                ox = (gis.read() << 24) + (gis.read() << 16) + (gis.read() << 8) + (gis.read() << 0);
                oz = (gis.read() << 24) + (gis.read() << 16) + (gis.read() << 8) + (gis.read() << 0);
                this.setOrigin(ox, oz);
                fis.close();
                gis.close();
            }
            catch (IOException e) {
                MainUtil.handleError(e);
            }
        }
        return new IntegerPair(ox, oz);
    }

    public static class DiskStorageSummary {
        private final int z;
        private final int x;
        public int[] blocks = new int[256];
        public int minX;
        public int minZ;
        public int maxX;
        public int maxZ;

        public DiskStorageSummary(int x, int z) {
            this.x = x;
            this.z = z;
            this.minX = x;
            this.maxX = x;
            this.minZ = z;
            this.maxZ = z;
        }

        public void add(int x, int z, int id) {
            int n = id;
            this.blocks[n] = this.blocks[n] + 1;
            if (x < this.minX) {
                this.minX = x;
            } else if (x > this.maxX) {
                this.maxX = x;
            }
            if (z < this.minZ) {
                this.minZ = z;
            } else if (z > this.maxZ) {
                this.maxZ = z;
            }
        }

        public Map<Integer, Integer> getBlocks() {
            Int2ObjectOpenHashMap<Integer> map = new Int2ObjectOpenHashMap<Integer>();
            for (int i = 0; i < this.blocks.length; ++i) {
                if (this.blocks[i] == 0) continue;
                map.put(i, (Integer)this.blocks[i]);
            }
            return map;
        }

        public Map<Integer, Double> getPercents() {
            Map<Integer, Integer> map = this.getBlocks();
            int count = this.getSize();
            Int2ObjectOpenHashMap<Double> newMap = new Int2ObjectOpenHashMap<Double>();
            for (Map.Entry<Integer, Integer> entry : map.entrySet()) {
                int id = entry.getKey();
                int changes = entry.getValue();
                double percent = (double)((long)changes * 1000L / (long)count) / 10.0;
                newMap.put(id, (Double)percent);
            }
            return newMap;
        }

        public int getSize() {
            int count = 0;
            for (int i = 0; i < this.blocks.length; ++i) {
                count += this.blocks[i];
            }
            return count;
        }
    }
}

