/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.object.brush.sweep;

import com.google.common.base.Preconditions;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.MaxChangedBlocksException;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.Vector2D;
import com.sk89q.worldedit.math.interpolation.Interpolation;
import java.util.ArrayList;
import java.util.List;

public abstract class Spline {
    private Vector2D direction = new Vector2D(1, 0);
    private final int nodeCount;
    protected EditSession editSession;
    private Interpolation interpolation;
    private List<Section> sections;
    private double splineLength;

    protected Spline(EditSession editSession, Interpolation interpolation) {
        this(editSession, interpolation, -1);
    }

    protected Spline(EditSession editSession, Interpolation interpolation, int nodeCount) {
        this.editSession = editSession;
        this.interpolation = interpolation;
        this.nodeCount = nodeCount;
        this.splineLength = interpolation.arcLength(0.0, 1.0);
        if (nodeCount > 2) {
            this.initSections();
        }
    }

    public void setDirection(Vector2D direction) {
        this.direction = direction;
    }

    public Vector2D getDirection() {
        return this.direction;
    }

    public int pastePosition(double position) throws MaxChangedBlocksException {
        Preconditions.checkArgument((position >= 0.0 ? 1 : 0) != 0);
        Preconditions.checkArgument((position <= 1.0 ? 1 : 0) != 0);
        if (this.nodeCount > 2) {
            return this.pastePositionDirect(this.translatePosition(position));
        }
        return this.pastePositionDirect(position);
    }

    public int pastePositionDirect(double position) throws MaxChangedBlocksException {
        Preconditions.checkArgument((position >= 0.0 ? 1 : 0) != 0);
        Preconditions.checkArgument((position <= 1.0 ? 1 : 0) != 0);
        Vector target = this.interpolation.getPosition(position);
        Vector offset = target.subtract(target.round());
        target = target.subtract(offset);
        Vector deriv = this.interpolation.get1stDerivative(position);
        Vector2D deriv2D = new Vector2D(deriv.getX(), deriv.getZ()).normalize();
        double angle = Math.toDegrees(Math.atan2(this.direction.getZ(), this.direction.getX()) - Math.atan2(deriv2D.getZ(), deriv2D.getX()));
        return this.pasteBlocks(target, offset, angle);
    }

    protected abstract int pasteBlocks(Vector var1, Vector var2, double var3) throws MaxChangedBlocksException;

    private void initSections() {
        int sectionCount = this.nodeCount - 1;
        this.sections = new ArrayList<Section>(sectionCount);
        double sectionLength = 1.0 / (double)sectionCount;
        double position = 0.0;
        for (int i = 0; i < sectionCount; ++i) {
            double length = i == sectionCount - 1 ? this.interpolation.arcLength((double)i * sectionLength, 1.0) / this.splineLength : this.interpolation.arcLength((double)i * sectionLength, (double)(i + 1) * sectionLength) / this.splineLength;
            this.sections.add(new Section((double)i * sectionLength, sectionLength, position, length));
            position += length;
        }
    }

    private double translatePosition(double flexPosition) {
        Section previousSection = this.sections.get(0);
        for (int i = 1; i < this.sections.size(); ++i) {
            Section section = this.sections.get(i);
            if (flexPosition < section.flexStart) break;
            previousSection = section;
        }
        double flexOffset = flexPosition - previousSection.flexStart;
        double uniOffset = flexOffset / previousSection.flexLength * previousSection.uniLength;
        return previousSection.uniStart + uniOffset;
    }

    private class Section {
        final double uniStart;
        final double uniLength;
        final double flexStart;
        final double flexLength;

        Section(double uniStart, double uniLength, double flexStart, double flexLength) {
            this.uniStart = uniStart;
            this.uniLength = uniLength;
            this.flexStart = flexStart;
            this.flexLength = flexLength;
        }
    }
}

