/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.object.brush;

import com.boydti.fawe.object.FaweQueue;
import com.boydti.fawe.object.collection.BlockVectorSet;
import com.boydti.fawe.object.mask.AdjacentAnyMask;
import com.boydti.fawe.object.mask.RadiusMask;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.MaxChangedBlocksException;
import com.sk89q.worldedit.MutableBlockVector;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.command.tool.brush.Brush;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.function.mask.BlockTypeMask;
import com.sk89q.worldedit.function.mask.SolidBlockMask;
import com.sk89q.worldedit.function.operation.Operations;
import com.sk89q.worldedit.function.pattern.Pattern;
import com.sk89q.worldedit.function.visitor.BreadthFirstSearch;
import com.sk89q.worldedit.function.visitor.RecursiveVisitor;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import com.sk89q.worldedit.world.block.BlockTypes;
import java.util.Arrays;

public class LayerBrush
implements Brush {
    private final BlockStateHolder[] layers;
    private RecursiveVisitor visitor;
    private MutableBlockVector mutable = new MutableBlockVector();

    public LayerBrush(BlockStateHolder[] layers) {
        this.layers = layers;
    }

    @Override
    public void build(EditSession editSession, Vector position, Pattern ignore, double size) throws MaxChangedBlocksException {
        FaweQueue queue = editSession.getQueue();
        AdjacentAnyMask adjacent = new AdjacentAnyMask(new BlockTypeMask((Extent)editSession, BlockTypes.AIR, BlockTypes.CAVE_AIR, BlockTypes.VOID_AIR));
        SolidBlockMask solid = new SolidBlockMask(editSession);
        RadiusMask radius = new RadiusMask(0, (int)size);
        this.visitor = new RecursiveVisitor(vector -> solid.test(vector) && radius.test(vector) && adjacent.test(vector), function -> true);
        this.visitor.visit(position);
        this.visitor.setDirections(Arrays.asList(BreadthFirstSearch.DIAGONAL_DIRECTIONS));
        Operations.completeBlindly(this.visitor);
        BlockVectorSet visited = this.visitor.getVisited();
        BlockStateHolder firstPattern = this.layers[0];
        this.visitor = new RecursiveVisitor(pos -> {
            int depth = this.visitor.getDepth() + 1;
            if (depth > 1) {
                boolean found = false;
                int previous = this.layers[depth - 1].getInternalId();
                int previous2 = this.layers[depth - 2].getInternalId();
                for (Vector dir : BreadthFirstSearch.DEFAULT_DIRECTIONS) {
                    this.mutable.setComponents(pos.getBlockX() + dir.getBlockX(), pos.getBlockY() + dir.getBlockY(), pos.getBlockZ() + dir.getBlockZ());
                    if (!this.visitor.isVisited(this.mutable) || queue.getCachedCombinedId4Data(this.mutable.getBlockX(), this.mutable.getBlockY(), this.mutable.getBlockZ()) != previous) continue;
                    this.mutable.setComponents(pos.getBlockX() + dir.getBlockX() * 2, pos.getBlockY() + dir.getBlockY() * 2, pos.getBlockZ() + dir.getBlockZ() * 2);
                    if (this.visitor.isVisited(this.mutable) && queue.getCachedCombinedId4Data(this.mutable.getBlockX(), this.mutable.getBlockY(), this.mutable.getBlockZ()) == previous2) {
                        found = true;
                        break;
                    }
                    return false;
                }
                if (!found) {
                    return false;
                }
            }
            return !adjacent.test(pos);
        }, pos -> {
            int depth = this.visitor.getDepth();
            BlockStateHolder currentPattern = this.layers[depth];
            return editSession.setBlock(pos, currentPattern);
        }, this.layers.length - 1, editSession);
        for (Vector pos2 : visited) {
            this.visitor.visit(pos2);
        }
        Operations.completeBlindly(this.visitor);
        this.visitor = null;
    }
}

