/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.object.brush;

import com.boydti.fawe.Fawe;
import com.boydti.fawe.object.brush.scroll.ScrollAction;
import com.boydti.fawe.object.extent.ResettableExtent;
import com.google.common.base.Preconditions;
import com.sk89q.minecraft.util.commands.CommandException;
import com.sk89q.minecraft.util.commands.CommandLocals;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.command.tool.BrushTool;
import com.sk89q.worldedit.command.tool.brush.Brush;
import com.sk89q.worldedit.entity.Player;
import com.sk89q.worldedit.extension.input.InputParseException;
import com.sk89q.worldedit.extension.input.ParserContext;
import com.sk89q.worldedit.extension.platform.Actor;
import com.sk89q.worldedit.extension.platform.CommandManager;
import com.sk89q.worldedit.function.mask.Mask;
import com.sk89q.worldedit.function.pattern.Pattern;
import com.sk89q.worldedit.internal.expression.Expression;
import com.sk89q.worldedit.internal.expression.ExpressionException;
import com.sk89q.worldedit.internal.expression.runtime.Constant;
import com.sk89q.worldedit.internal.expression.runtime.EvaluationException;
import com.sk89q.worldedit.util.command.CommandCallable;
import com.sk89q.worldedit.util.command.Dispatcher;
import com.sk89q.worldedit.util.command.ProcessedCallable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class BrushSettings {
    private final Map<SettingType, Object> constructor = new ConcurrentHashMap<SettingType, Object>();
    private Brush brush = null;
    private Mask mask = null;
    private Mask sourceMask = null;
    private ResettableExtent transform = null;
    private Pattern material;
    private Expression size = new Expression(1.0);
    private Set<String> permissions = new HashSet<String>();
    private ScrollAction scrollAction;
    private String lastWorld;

    public BrushSettings() {
        this.constructor.put(SettingType.PERMISSIONS, this.permissions);
    }

    public static BrushSettings get(BrushTool tool, Player player, LocalSession session, Map<String, Object> settings) throws CommandException, InputParseException {
        String actionArgs;
        ScrollAction action;
        Mask mask;
        String maskArgs;
        Dispatcher dispatcher = CommandManager.getInstance().getDispatcher();
        Dispatcher brushDispatcher = (Dispatcher)dispatcher.get("brush").getCallable();
        if (brushDispatcher == null) {
            return null;
        }
        String constructor = (String)settings.get(SettingType.BRUSH.name());
        if (constructor == null) {
            return new BrushSettings();
        }
        String[] split = constructor.split(" ");
        CommandCallable sphereCommand = ((ProcessedCallable)brushDispatcher.get(split[0]).getCallable()).getParent();
        CommandLocals locals = new CommandLocals();
        locals.put(Actor.class, player);
        String args = constructor.replaceAll(split[0] + "[ ]?", "");
        String[] parentArgs = new String[]{"brush", split[0]};
        BrushSettings bs = (BrushSettings)sphereCommand.call(args, locals, parentArgs);
        bs.constructor.put(SettingType.BRUSH, constructor);
        if (settings.containsKey(SettingType.PERMISSIONS.name())) {
            bs.permissions.addAll((Collection)settings.get(SettingType.PERMISSIONS.name()));
        }
        if (settings.containsKey(SettingType.SIZE.name())) {
            try {
                bs.size = Expression.compile((String)settings.getOrDefault(SettingType.SIZE.name(), -1), new String[0]);
                bs.size.optimize();
            }
            catch (ExpressionException e) {
                throw new RuntimeException(e);
            }
        }
        ParserContext parserContext = new ParserContext();
        parserContext.setActor(player);
        parserContext.setWorld(player.getWorld());
        parserContext.setSession(session);
        if (settings.containsKey(SettingType.MASK.name())) {
            maskArgs = (String)settings.get(SettingType.MASK.name());
            mask = (Mask)WorldEdit.getInstance().getMaskFactory().parseFromInput(maskArgs, parserContext);
            bs.setMask(mask);
            bs.constructor.put(SettingType.MASK, maskArgs);
        }
        if (settings.containsKey(SettingType.SOURCE_MASK.name())) {
            maskArgs = (String)settings.get(SettingType.SOURCE_MASK.name());
            mask = (Mask)WorldEdit.getInstance().getMaskFactory().parseFromInput(maskArgs, parserContext);
            bs.setSourceMask(mask);
            bs.constructor.put(SettingType.SOURCE_MASK, maskArgs);
        }
        if (settings.containsKey(SettingType.TRANSFORM.name())) {
            String transformArgs = (String)settings.get(SettingType.TRANSFORM.name());
            ResettableExtent extent = Fawe.get().getTransformParser().parseFromInput(transformArgs, parserContext);
            bs.setTransform(extent);
            bs.constructor.put(SettingType.TRANSFORM, transformArgs);
        }
        if (settings.containsKey(SettingType.FILL.name())) {
            String fillArgs = (String)settings.get(SettingType.FILL.name());
            Pattern pattern = (Pattern)WorldEdit.getInstance().getPatternFactory().parseFromInput(fillArgs, parserContext);
            bs.setFill(pattern);
            bs.constructor.put(SettingType.FILL, fillArgs);
        }
        if (settings.containsKey(SettingType.SCROLL_ACTION.name()) && (action = ScrollAction.fromArguments(tool, player, session, actionArgs = (String)settings.get(SettingType.SCROLL_ACTION.name()), false)) != null) {
            bs.setScrollAction(action);
            bs.constructor.put(SettingType.SCROLL_ACTION, actionArgs);
        }
        return bs;
    }

    public BrushSettings setBrush(Brush brush) {
        Brush tmp = this.brush;
        if (tmp != brush) {
            if (brush == null || tmp != null && tmp.getClass() != brush.getClass()) {
                this.clear();
            }
            this.brush = brush;
        }
        return this;
    }

    public BrushSettings clear() {
        this.brush = null;
        this.mask = null;
        this.sourceMask = null;
        this.transform = null;
        this.material = null;
        this.scrollAction = null;
        this.size = new Expression(1.0);
        this.permissions.clear();
        this.constructor.clear();
        return this;
    }

    public BrushSettings clearPerms() {
        this.permissions.clear();
        return this;
    }

    public BrushSettings addSetting(SettingType type, String args) {
        this.constructor.put(type, args);
        return this;
    }

    public Map<SettingType, Object> getSettings() {
        return this.constructor;
    }

    public BrushSettings setMask(Mask mask) {
        if (mask == null) {
            this.constructor.remove((Object)SettingType.MASK);
        }
        this.mask = mask;
        return this;
    }

    public BrushSettings setSourceMask(Mask mask) {
        if (mask == null) {
            this.constructor.remove((Object)SettingType.SOURCE_MASK);
        }
        this.sourceMask = mask;
        return this;
    }

    public BrushSettings setTransform(ResettableExtent transform) {
        if (transform == null) {
            this.constructor.remove((Object)SettingType.TRANSFORM);
        }
        this.transform = transform;
        return this;
    }

    public BrushSettings setFill(Pattern pattern) {
        if (pattern == null) {
            this.constructor.remove((Object)SettingType.FILL);
        }
        this.material = pattern;
        return this;
    }

    public BrushSettings setSize(Expression size) {
        Preconditions.checkNotNull((Object)size);
        this.size = size;
        if (size.getRoot() instanceof Constant && ((Constant)size.getRoot()).getValue() == -1.0) {
            this.constructor.remove((Object)SettingType.SIZE);
        } else {
            this.constructor.put(SettingType.SIZE, size.toString());
        }
        return this;
    }

    public BrushSettings setSize(double size) {
        return this.setSize(new Expression(size));
    }

    public BrushSettings setScrollAction(ScrollAction scrollAction) {
        if (scrollAction == null) {
            this.constructor.remove((Object)SettingType.SCROLL_ACTION);
        }
        this.scrollAction = scrollAction;
        return this;
    }

    public BrushSettings addPermission(String permission) {
        this.permissions.add(permission);
        return this;
    }

    public BrushSettings addPermissions(String ... perms) {
        for (String perm : perms) {
            this.permissions.add(perm);
        }
        return this;
    }

    public boolean setWorld(String world) {
        boolean result = false;
        if (this.lastWorld != null && !this.lastWorld.equalsIgnoreCase(world)) {
            result = true;
        }
        this.lastWorld = world;
        return result;
    }

    public Brush getBrush() {
        return this.brush;
    }

    public Mask getMask() {
        return this.mask;
    }

    public Mask getSourceMask() {
        return this.sourceMask;
    }

    public ResettableExtent getTransform() {
        return this.transform;
    }

    public Pattern getMaterial() {
        return this.material;
    }

    public double getSize() {
        try {
            return this.size.evaluate(new double[0]);
        }
        catch (EvaluationException e) {
            throw new RuntimeException(e);
        }
    }

    public Expression getSizeExpression() {
        return this.size;
    }

    public Set<String> getPermissions() {
        return Collections.unmodifiableSet(this.permissions);
    }

    public ScrollAction getScrollAction() {
        return this.scrollAction;
    }

    public boolean canUse(Actor actor) {
        Set<String> perms = this.getPermissions();
        for (String perm : perms) {
            if (!actor.hasPermission(perm)) continue;
            return true;
        }
        return perms.isEmpty();
    }

    public static enum SettingType {
        BRUSH,
        SIZE,
        MASK,
        SOURCE_MASK,
        TRANSFORM,
        FILL,
        PERMISSIONS,
        SCROLL_ACTION;

    }
}

