/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.object;

import com.boydti.fawe.Fawe;
import com.boydti.fawe.FaweAPI;
import com.boydti.fawe.command.CFICommands;
import com.boydti.fawe.config.BBC;
import com.boydti.fawe.config.Settings;
import com.boydti.fawe.object.FaweLimit;
import com.boydti.fawe.object.FaweLocation;
import com.boydti.fawe.object.FaweQueue;
import com.boydti.fawe.object.MaskedFaweQueue;
import com.boydti.fawe.object.Metadatable;
import com.boydti.fawe.object.RegionWrapper;
import com.boydti.fawe.object.brush.visualization.VirtualWorld;
import com.boydti.fawe.object.clipboard.DiskOptimizedClipboard;
import com.boydti.fawe.object.exception.FaweException;
import com.boydti.fawe.object.task.SimpleAsyncNotifyQueue;
import com.boydti.fawe.object.task.ThrowableSupplier;
import com.boydti.fawe.regions.FaweMaskManager;
import com.boydti.fawe.util.EditSessionBuilder;
import com.boydti.fawe.util.MainUtil;
import com.boydti.fawe.util.SetQueue;
import com.boydti.fawe.util.TaskManager;
import com.boydti.fawe.util.Updater;
import com.boydti.fawe.util.WEManager;
import com.boydti.fawe.wrappers.FakePlayer;
import com.boydti.fawe.wrappers.LocationMaskedPlayerWrapper;
import com.boydti.fawe.wrappers.PlayerWrapper;
import com.sk89q.minecraft.util.commands.CommandContext;
import com.sk89q.worldedit.BlockVector;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.EmptyClipboardException;
import com.sk89q.worldedit.IncompleteRegionException;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.entity.Player;
import com.sk89q.worldedit.event.platform.CommandEvent;
import com.sk89q.worldedit.extension.platform.Actor;
import com.sk89q.worldedit.extension.platform.Capability;
import com.sk89q.worldedit.extension.platform.CommandManager;
import com.sk89q.worldedit.extension.platform.PlatformManager;
import com.sk89q.worldedit.extension.platform.PlayerProxy;
import com.sk89q.worldedit.extent.clipboard.BlockArrayClipboard;
import com.sk89q.worldedit.regions.ConvexPolyhedralRegion;
import com.sk89q.worldedit.regions.CylinderRegion;
import com.sk89q.worldedit.regions.Polygonal2DRegion;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.regions.RegionOperationException;
import com.sk89q.worldedit.regions.RegionSelector;
import com.sk89q.worldedit.regions.selector.ConvexPolyhedralRegionSelector;
import com.sk89q.worldedit.regions.selector.CuboidRegionSelector;
import com.sk89q.worldedit.regions.selector.CylinderRegionSelector;
import com.sk89q.worldedit.regions.selector.Polygonal2DRegionSelector;
import com.sk89q.worldedit.session.ClipboardHolder;
import com.sk89q.worldedit.world.World;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;

public abstract class FawePlayer<T>
extends Metadatable {
    public final T parent;
    private LocalSession session;
    private AtomicInteger runningCount = new AtomicInteger();
    private SimpleAsyncNotifyQueue asyncNotifyQueue = new SimpleAsyncNotifyQueue((t, e) -> {
        while (e.getCause() != null) {
            e = e.getCause();
        }
        if (e instanceof WorldEditException) {
            this.sendMessage(BBC.getPrefix() + e.getLocalizedMessage());
        } else {
            FaweException fe = FaweException.get(e);
            if (fe != null) {
                this.sendMessage(fe.getMessage());
            } else {
                e.printStackTrace();
            }
        }
    });
    private Player cachedWorldEditPlayer;

    public static <V> FawePlayer<V> wrap(Object obj) {
        Actor actor;
        if (obj == null || obj instanceof String && obj.equals("*")) {
            return FakePlayer.getConsole().toFawePlayer();
        }
        if (obj instanceof FawePlayer) {
            return (FawePlayer)obj;
        }
        if (obj instanceof FakePlayer) {
            return ((FakePlayer)obj).toFawePlayer();
        }
        if (obj instanceof Player) {
            actor = LocationMaskedPlayerWrapper.unwrap((Player)obj);
            if (obj.getClass().getSimpleName().equals("PlayerProxy")) {
                try {
                    Field fieldBasePlayer = actor.getClass().getDeclaredField("basePlayer");
                    fieldBasePlayer.setAccessible(true);
                    Player player = (Player)fieldBasePlayer.get(actor);
                    FawePlayer<V> result = FawePlayer.wrap(player);
                    return result == null ? FawePlayer.wrap(player.getName()) : result;
                }
                catch (Throwable e) {
                    MainUtil.handleError(e);
                    return Fawe.imp().wrap(actor.getName());
                }
            }
            if (obj instanceof PlayerWrapper) {
                return FawePlayer.wrap(((PlayerWrapper)obj).getParent());
            }
            try {
                Field fieldPlayer = actor.getClass().getDeclaredField("player");
                fieldPlayer.setAccessible(true);
                return FawePlayer.wrap(fieldPlayer.get(actor));
            }
            catch (Throwable fieldPlayer) {
                // empty catch block
            }
        }
        if (obj instanceof Actor) {
            actor = (Actor)obj;
            FawePlayer existing = Fawe.get().getCachedPlayer(actor.getName());
            if (existing != null) {
                return existing;
            }
            FakePlayer fake = new FakePlayer(actor.getName(), actor.getUniqueId(), actor);
            return fake.toFawePlayer();
        }
        if (obj != null && obj.getClass().getName().contains("CraftPlayer") && !Fawe.imp().getPlatform().equals("bukkit")) {
            try {
                Method methodGetHandle = obj.getClass().getDeclaredMethod("getHandle", new Class[0]);
                obj = methodGetHandle.invoke(obj, new Object[0]);
            }
            catch (Throwable e) {
                e.printStackTrace();
                return null;
            }
        }
        return Fawe.imp().wrap(obj);
    }

    @Deprecated
    public FawePlayer(T parent) {
        Updater updater;
        this.parent = parent;
        Fawe.get().register(this);
        if (Settings.IMP.CLIPBOARD.USE_DISK) {
            this.loadClipboardFromDisk();
        }
        if ((updater = Fawe.get().getUpdater()) != null && updater.hasPending(this)) {
            TaskManager.IMP.async(() -> updater.confirmUpdate(this));
        }
    }

    public int cancel(boolean close) {
        Collection<FaweQueue> queues = SetQueue.IMP.getAllQueues();
        int cancelled = 0;
        this.clearActions();
        for (FaweQueue queue : queues) {
            Collection<EditSession> sessions = queue.getEditSessions();
            for (EditSession session : sessions) {
                FawePlayer currentPlayer = session.getPlayer();
                if (currentPlayer != this || !session.cancel()) continue;
                ++cancelled;
            }
        }
        VirtualWorld world = this.getSession().getVirtualWorld();
        if (world != null) {
            if (close) {
                try {
                    world.close(false);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else {
                world.clear();
            }
        }
        return cancelled;
    }

    private void setConfirmTask(final @Nullable Runnable task, final CommandContext context, String command) {
        if (task != null) {
            Runnable newTask = new Runnable(){

                @Override
                public void run() {
                    CommandManager.getInstance().handleCommandTask(new ThrowableSupplier<Throwable>(){

                        @Override
                        public Object get() throws Throwable {
                            task.run();
                            return null;
                        }
                    }, context.getLocals());
                }
            };
            this.setMeta("cmdConfirm", newTask);
        } else {
            this.setMeta("cmdConfirm", new CommandEvent(this.getPlayer(), command));
        }
    }

    public void checkConfirmation(@Nullable Runnable task, String command, int times, int limit, CommandContext context) throws RegionOperationException {
        if (command != null && !this.getMeta("cmdConfirmRunning", false).booleanValue() && times > limit) {
            this.setConfirmTask(task, context, command);
            String volume = "<unspecified>";
            throw new RegionOperationException(BBC.WORLDEDIT_CANCEL_REASON_CONFIRM.f(0, times, command, volume));
        }
        if (task != null) {
            task.run();
        }
    }

    public void checkConfirmationRadius(@Nullable Runnable task, String command, int radius, CommandContext context) throws RegionOperationException {
        if (command != null && !this.getMeta("cmdConfirmRunning", false).booleanValue() && radius > 0 && radius > 448) {
            this.setConfirmTask(task, context, command);
            long volume = (long)(Math.PI * ((double)radius * (double)radius));
            throw new RegionOperationException(BBC.WORLDEDIT_CANCEL_REASON_CONFIRM.f(0, radius, command, NumberFormat.getNumberInstance().format(volume)));
        }
        if (task != null) {
            task.run();
        }
    }

    public void checkConfirmationStack(@Nullable Runnable task, String command, Region region, int times, CommandContext context) throws RegionOperationException {
        if (command != null && !this.getMeta("cmdConfirmRunning", false).booleanValue() && region != null) {
            BlockVector min = region.getMinimumPoint().toBlockVector();
            BlockVector max = region.getMaximumPoint().toBlockVector();
            long area = (long)((max.getX() - min.getX()) * (max.getZ() - min.getZ() + 1.0)) * (long)times;
            if (area > 524288L) {
                this.setConfirmTask(task, context, command);
                long volume = (long)max.subtract((Vector)min).add(Vector.ONE).volume() * (long)times;
                throw new RegionOperationException(BBC.WORLDEDIT_CANCEL_REASON_CONFIRM.f(min, max, command, NumberFormat.getNumberInstance().format(volume)));
            }
        }
        if (task != null) {
            task.run();
        }
    }

    public void checkConfirmationRegion(@Nullable Runnable task, String command, Region region, CommandContext context) throws RegionOperationException {
        if (command != null && !this.getMeta("cmdConfirmRunning", false).booleanValue() && region != null) {
            BlockVector min = region.getMinimumPoint().toBlockVector();
            BlockVector max = region.getMaximumPoint().toBlockVector();
            long area = (long)((max.getX() - min.getX()) * (max.getZ() - min.getZ() + 1.0));
            if (area > 524288L) {
                this.setConfirmTask(task, context, command);
                long volume = (long)max.subtract((Vector)min).add(Vector.ONE).volume();
                throw new RegionOperationException(BBC.WORLDEDIT_CANCEL_REASON_CONFIRM.f(min, max, command, NumberFormat.getNumberInstance().format(volume)));
            }
        }
        if (task != null) {
            task.run();
        }
    }

    public synchronized boolean confirm() {
        Runnable confirm = (Runnable)this.deleteMeta("cmdConfirm");
        if (!(confirm instanceof Runnable)) {
            return false;
        }
        this.queueAction(() -> {
            this.setMeta("cmdConfirmRunning", true);
            try {
                confirm.run();
            }
            finally {
                this.setMeta("cmdConfirmRunning", false);
            }
        });
        return true;
    }

    public void checkAllowedRegion(Region wrappedSelection) {
        Region[] allowed = WEManager.IMP.getMask(this, FaweMaskManager.MaskType.OWNER);
        HashSet<Region> allowedSet = new HashSet<Region>(Arrays.asList(allowed));
        if (allowed.length == 0) {
            throw new FaweException(BBC.WORLDEDIT_CANCEL_REASON_NO_REGION);
        }
        if (!WEManager.IMP.regionContains(wrappedSelection, allowedSet)) {
            throw new FaweException(BBC.WORLDEDIT_CANCEL_REASON_OUTSIDE_REGION);
        }
    }

    public boolean toggle(String perm) {
        if (this.hasPermission(perm)) {
            this.setPermission(perm, false);
            return false;
        }
        this.setPermission(perm, true);
        return true;
    }

    public void queueAction(Runnable run) {
        this.runAction(run, false, true);
    }

    public void clearActions() {
        this.asyncNotifyQueue.clear();
    }

    public boolean runAsyncIfFree(Runnable r) {
        return this.runAction(r, true, true);
    }

    public boolean runIfFree(Runnable r) {
        return this.runAction(r, true, false);
    }

    public boolean runAction(Runnable ifFree, boolean checkFree, boolean async) {
        if (checkFree && this.runningCount.get() != 0) {
            return false;
        }
        Runnable wrapped = () -> {
            try {
                this.runningCount.addAndGet(1);
                ifFree.run();
            }
            finally {
                this.runningCount.decrementAndGet();
            }
        };
        if (async) {
            this.asyncNotifyQueue.queue(wrapped);
        } else {
            TaskManager.IMP.taskNow(wrapped, false);
        }
        return true;
    }

    public boolean checkAction() {
        long time = this.getMeta("faweActionTick", Long.MIN_VALUE);
        long tick = Fawe.get().getTimer().getTick();
        this.setMeta("faweActionTick", tick);
        return tick > time;
    }

    public void loadClipboardFromDisk() {
        block6: {
            File file = MainUtil.getFile(Fawe.imp().getDirectory(), Settings.IMP.PATHS.CLIPBOARD + File.separator + this.getUUID() + ".bd");
            try {
                if (!file.exists() || file.length() <= 5L) break block6;
                DiskOptimizedClipboard doc = new DiskOptimizedClipboard(file);
                Player player = this.toWorldEditPlayer();
                LocalSession session = this.getSession();
                try {
                    if (session.getClipboard() != null) {
                        return;
                    }
                }
                catch (EmptyClipboardException emptyClipboardException) {
                    // empty catch block
                }
                if (player != null && session != null) {
                    BlockArrayClipboard clip = doc.toClipboard();
                    ClipboardHolder holder = new ClipboardHolder(clip);
                    this.getSession().setClipboard(holder);
                }
            }
            catch (Exception ignore) {
                Fawe.debug("====== INVALID CLIPBOARD ======");
                MainUtil.handleError(ignore, false);
                Fawe.debug("===============---=============");
                Fawe.debug("This shouldn't result in any failure");
                Fawe.debug("File: " + file.getName() + " (len:" + file.length() + ")");
                Fawe.debug("===============---=============");
            }
        }
    }

    public World getWorld() {
        return FaweAPI.getWorld(this.getLocation().world);
    }

    public FaweQueue getFaweQueue(boolean autoQueue) {
        return this.getFaweQueue(true, autoQueue);
    }

    public FaweQueue getFaweQueue(boolean fast, boolean autoQueue) {
        CFICommands.CFISettings settings = (CFICommands.CFISettings)this.getMeta("CFISettings");
        if (settings != null && settings.hasGenerator()) {
            return settings.getGenerator();
        }
        return SetQueue.IMP.getNewQueue(this.getWorld(), true, autoQueue);
    }

    public FaweQueue getMaskedFaweQueue(boolean autoQueue) {
        FaweQueue queue = this.getFaweQueue(autoQueue);
        Region[] allowedRegions = this.getCurrentRegions();
        if (allowedRegions.length == 1 && allowedRegions[0].isGlobal()) {
            return queue;
        }
        return new MaskedFaweQueue(queue, allowedRegions);
    }

    public void loadSessionsFromDisk(World world) {
        if (world == null) {
            return;
        }
        this.getSession().loadSessionHistoryFromDisk(this.getUUID(), world);
    }

    public abstract void sendTitle(String var1, String var2);

    public abstract void resetTitle();

    public FaweLimit getLimit() {
        return Settings.IMP.getLimit(this);
    }

    public abstract String getName();

    public abstract UUID getUUID();

    public boolean isSneaking() {
        return false;
    }

    public abstract boolean hasPermission(String var1);

    public abstract void setPermission(String var1, boolean var2);

    public abstract void sendMessage(String var1);

    public abstract void executeCommand(String var1);

    public abstract FaweLocation getLocation();

    public abstract Player toWorldEditPlayer();

    public Player getPlayer() {
        if (this.cachedWorldEditPlayer == null) {
            this.cachedWorldEditPlayer = this.toWorldEditPlayer();
        }
        return this.cachedWorldEditPlayer;
    }

    public Region getSelection() {
        try {
            return this.getSession().getSelection(this.getPlayer().getWorld());
        }
        catch (IncompleteRegionException e) {
            return null;
        }
    }

    public LocalSession getSession() {
        return this.session != null || this.getPlayer() == null || Fawe.get() == null ? this.session : (this.session = Fawe.get().getWorldEdit().getSessionManager().get(this.getPlayer()));
    }

    @Deprecated
    public Region[] getCurrentRegions() {
        return WEManager.IMP.getMask(this);
    }

    @Deprecated
    public Region[] getCurrentRegions(FaweMaskManager.MaskType type) {
        return WEManager.IMP.getMask(this, type);
    }

    @Deprecated
    public void setSelection(RegionWrapper region) {
        Player player = this.getPlayer();
        Vector top = region.getMaximumPoint();
        top.mutY(this.getWorld().getMaxY());
        CuboidRegionSelector selector = new CuboidRegionSelector(player.getWorld(), region.getMinimumPoint(), top);
        this.getSession().setRegionSelector(player.getWorld(), selector);
    }

    public void setSelection(Region region) {
        RegionSelector selector;
        switch (region.getClass().getName()) {
            case "ConvexPolyhedralRegion": {
                selector = new ConvexPolyhedralRegionSelector((ConvexPolyhedralRegion)region);
                break;
            }
            case "CylinderRegion": {
                selector = new CylinderRegionSelector((CylinderRegion)region);
                break;
            }
            case "Polygonal2DRegion": {
                selector = new Polygonal2DRegionSelector((Polygonal2DRegion)region);
                break;
            }
            default: {
                selector = new CuboidRegionSelector(null, region.getMinimumPoint(), region.getMaximumPoint());
            }
        }
        selector.setWorld(region.getWorld());
        Player player = this.getPlayer();
        this.getSession().setRegionSelector(player.getWorld(), selector);
    }

    public void setSelection(RegionSelector selector) {
        this.getSession().setRegionSelector(this.toWorldEditPlayer().getWorld(), selector);
    }

    public Region getLargestRegion() {
        int area = 0;
        Region max = null;
        for (Region region : this.getCurrentRegions()) {
            int tmp = region.getArea();
            if (tmp <= area) continue;
            area = tmp;
            max = region;
        }
        return max;
    }

    public String toString() {
        return this.getName();
    }

    public boolean hasWorldEditBypass() {
        return this.hasPermission("fawe.bypass");
    }

    public void unregister() {
        this.cancel(true);
        if (Settings.IMP.HISTORY.DELETE_ON_LOGOUT) {
            this.session = this.getSession();
            WorldEdit.getInstance().getSessionManager().remove(this.toWorldEditPlayer());
            this.session.setClipboard(null);
            this.session.clearHistory();
            this.session.unregisterTools(this.getPlayer());
        }
        Fawe.get().unregister(this.getName());
    }

    public EditSession getNewEditSession() {
        return new EditSessionBuilder(this.getWorld()).player(this).build();
    }

    public void setVirtualWorld(VirtualWorld world) {
        this.getSession().setVirtualWorld(world);
    }

    public World getWorldForEditing() {
        VirtualWorld virtual = this.getSession().getVirtualWorld();
        if (virtual != null) {
            return virtual;
        }
        return WorldEdit.getInstance().getPlatformManager().getWorldForEditing(this.getWorld());
    }

    public PlayerProxy createProxy() {
        Player cuiActor;
        Player player = this.getPlayer();
        World world = this.getWorldForEditing();
        PlatformManager platformManager = WorldEdit.getInstance().getPlatformManager();
        Player permActor = platformManager.queryCapability(Capability.PERMISSIONS).matchPlayer(player);
        if (permActor == null) {
            permActor = player;
        }
        if ((cuiActor = platformManager.queryCapability(Capability.WORLDEDIT_CUI).matchPlayer(player)) == null) {
            cuiActor = player;
        }
        PlayerProxy proxy = new PlayerProxy(player, permActor, cuiActor, world);
        if (world instanceof VirtualWorld) {
            proxy.setOffset(Vector.ZERO.subtract(((VirtualWorld)world).getOrigin()));
        }
        return proxy;
    }

    public Map<EditSession, SetQueue.QueueStage> getTrackedSessions(SetQueue.QueueStage requiredStage) {
        FawePlayer currentPlayer;
        Collection<EditSession> sessions;
        ConcurrentHashMap<EditSession, SetQueue.QueueStage> map = new ConcurrentHashMap<EditSession, SetQueue.QueueStage>(8, 0.9f, 1);
        if (requiredStage == null || requiredStage == SetQueue.QueueStage.ACTIVE) {
            for (FaweQueue queue : SetQueue.IMP.getActiveQueues()) {
                sessions = queue.getEditSessions();
                for (EditSession session : sessions) {
                    currentPlayer = session.getPlayer();
                    if (currentPlayer != this) continue;
                    map.put(session, SetQueue.QueueStage.ACTIVE);
                }
            }
        }
        if (requiredStage == null || requiredStage == SetQueue.QueueStage.INACTIVE) {
            for (FaweQueue queue : SetQueue.IMP.getInactiveQueues()) {
                sessions = queue.getEditSessions();
                for (EditSession session : sessions) {
                    currentPlayer = session.getPlayer();
                    if (currentPlayer != this) continue;
                    map.put(session, SetQueue.QueueStage.INACTIVE);
                }
            }
        }
        return map;
    }

    public static final class METADATA_KEYS {
        public static final String ANVIL_CLIPBOARD = "anvil-clipboard";
        public static final String ROLLBACK = "rollback";
    }
}

