/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.logging.rollback;

import com.boydti.fawe.database.DBHandler;
import com.boydti.fawe.database.RollbackDatabase;
import com.boydti.fawe.object.changeset.DiskStorageHistory;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.world.World;
import java.io.IOException;
import java.io.OutputStream;
import java.util.UUID;

public class RollbackOptimizedHistory
extends DiskStorageHistory {
    private long time = System.currentTimeMillis();
    private int minX;
    private int maxX;
    private int minY;
    private int maxY;
    private int minZ;
    private int maxZ;

    public RollbackOptimizedHistory(World world, UUID uuid, int index) {
        super(world, uuid, index);
    }

    public RollbackOptimizedHistory(World world, UUID uuid) {
        super(world, uuid);
    }

    public RollbackOptimizedHistory(String world, UUID uuid, int index) {
        super(world, uuid, index);
    }

    public RollbackOptimizedHistory(String world, UUID uuid) {
        super(world, uuid);
    }

    public long getTime() {
        return this.time;
    }

    public int getMinX() {
        return this.minX;
    }

    public int getMaxX() {
        return this.maxX;
    }

    public int getMinY() {
        return this.minY;
    }

    public int getMaxY() {
        return this.maxY;
    }

    public int getMinZ() {
        return this.minZ;
    }

    public int getMaxZ() {
        return this.maxZ;
    }

    public void setDimensions(Vector pos1, Vector pos2) {
        this.minX = pos1.getBlockX();
        this.minY = pos1.getBlockY();
        this.minZ = pos1.getBlockZ();
        this.maxX = pos2.getBlockX();
        this.maxY = pos2.getBlockY();
        this.maxZ = pos2.getBlockZ();
    }

    public void setTime(long time) {
        this.time = time;
    }

    @Override
    public boolean close() {
        if (super.close()) {
            RollbackDatabase db = DBHandler.IMP.getDatabase(this.getWorld());
            if (db != null) {
                db.logEdit(this);
            }
            return true;
        }
        return false;
    }

    @Override
    public void add(int x, int y, int z, int combinedFrom, int combinedTo) {
        super.add(x, y, z, combinedFrom, combinedTo);
        if (x < this.minX) {
            this.minX = x;
        } else if (x > this.maxX) {
            this.maxX = x;
        }
        if (y < this.minY) {
            this.minY = y;
        } else if (y > this.maxY) {
            this.maxY = y;
        }
        if (z < this.minZ) {
            this.minZ = z;
        } else if (z > this.maxZ) {
            this.maxZ = z;
        }
    }

    @Override
    public void writeHeader(OutputStream os, int x, int y, int z) throws IOException {
        this.minX = x;
        this.maxX = x;
        this.minY = y;
        this.maxY = y;
        this.minZ = z;
        this.maxZ = z;
        super.writeHeader(os, x, y, z);
    }
}

