/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.jnbt;

import com.boydti.fawe.Fawe;
import com.boydti.fawe.config.Settings;
import com.boydti.fawe.jnbt.NBTStreamer;
import com.boydti.fawe.object.FaweInputStream;
import com.boydti.fawe.object.FaweOutputStream;
import com.boydti.fawe.object.clipboard.CPUOptimizedClipboard;
import com.boydti.fawe.object.clipboard.DiskOptimizedClipboard;
import com.boydti.fawe.object.clipboard.FaweClipboard;
import com.boydti.fawe.object.clipboard.MemoryOptimizedClipboard;
import com.boydti.fawe.object.io.FastByteArrayOutputStream;
import com.boydti.fawe.object.io.FastByteArraysInputStream;
import com.sk89q.jnbt.CompoundTag;
import com.sk89q.jnbt.ListTag;
import com.sk89q.jnbt.NBTInputStream;
import com.sk89q.jnbt.StringTag;
import com.sk89q.worldedit.BlockVector;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.blocks.BlockMaterial;
import com.sk89q.worldedit.entity.BaseEntity;
import com.sk89q.worldedit.extent.clipboard.BlockArrayClipboard;
import com.sk89q.worldedit.extent.clipboard.Clipboard;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.registry.state.PropertyKey;
import com.sk89q.worldedit.util.Direction;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import com.sk89q.worldedit.world.block.BlockTypeSwitch;
import com.sk89q.worldedit.world.block.BlockTypeSwitchBuilder;
import com.sk89q.worldedit.world.block.BlockTypes;
import com.sk89q.worldedit.world.entity.EntityType;
import com.sk89q.worldedit.world.entity.EntityTypes;
import com.sk89q.worldedit.world.registry.LegacyMapper;
import java.io.IOException;
import java.util.UUID;
import java.util.function.BiConsumer;
import net.jpountz.lz4.LZ4BlockInputStream;
import net.jpountz.lz4.LZ4BlockOutputStream;

public class SchematicStreamer
extends NBTStreamer {
    private final UUID uuid;
    private FastByteArrayOutputStream idOut = new FastByteArrayOutputStream();
    private FastByteArrayOutputStream dataOut = new FastByteArrayOutputStream();
    private FastByteArrayOutputStream addOut;
    private FaweOutputStream ids;
    private FaweOutputStream datas;
    private FaweOutputStream adds;
    private BlockTypeSwitch<Boolean> fullCube = new BlockTypeSwitchBuilder<Boolean>(false).add(type -> {
        BlockMaterial mat = type.getMaterial();
        return mat.isFullCube() && !mat.isFragileWhenPushed() && mat.getLightValue() == 0 && mat.isOpaque() && mat.isSolid() && !mat.isTranslucent();
    }, (Boolean)true).build();
    private int height;
    private int width;
    private int length;
    private int originX;
    private int originY;
    private int originZ;
    private int offsetX;
    private int offsetY;
    private int offsetZ;
    private BlockArrayClipboard clipboard;
    private FaweClipboard fc;

    public SchematicStreamer(NBTInputStream stream, UUID uuid) {
        super(stream);
        this.uuid = uuid;
        this.clipboard = new BlockArrayClipboard((Region)new CuboidRegion(new Vector(0, 0, 0), new Vector(0, 0, 0)), this.fc);
    }

    public void addBlockReaders() throws IOException {
        NBTStreamer.NBTStreamReader<Integer, Integer> idInit = new NBTStreamer.NBTStreamReader<Integer, Integer>(){

            @Override
            public void accept(Integer length, Integer type) {
                SchematicStreamer.this.setupClipboard(length);
                SchematicStreamer.this.ids = new FaweOutputStream(new LZ4BlockOutputStream(SchematicStreamer.this.idOut));
            }
        };
        NBTStreamer.NBTStreamReader<Integer, Integer> dataInit = new NBTStreamer.NBTStreamReader<Integer, Integer>(){

            @Override
            public void accept(Integer length, Integer type) {
                SchematicStreamer.this.setupClipboard(length);
                SchematicStreamer.this.datas = new FaweOutputStream(new LZ4BlockOutputStream(SchematicStreamer.this.dataOut));
            }
        };
        NBTStreamer.NBTStreamReader<Integer, Integer> addInit = new NBTStreamer.NBTStreamReader<Integer, Integer>(){

            @Override
            public void accept(Integer length, Integer type) {
                SchematicStreamer.this.setupClipboard(length * 2);
                SchematicStreamer.this.addOut = new FastByteArrayOutputStream();
                SchematicStreamer.this.adds = new FaweOutputStream(new LZ4BlockOutputStream(SchematicStreamer.this.addOut));
            }
        };
        this.addReader("Schematic.Blocks.?", idInit);
        this.addReader("Schematic.Data.?", dataInit);
        this.addReader("Schematic.AddBlocks.?", addInit);
        this.addReader("Schematic.Blocks.#", new NBTStreamer.ByteReader(){

            @Override
            public void run(int index, int value) {
                try {
                    SchematicStreamer.this.ids.write(value);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        });
        this.addReader("Schematic.Data.#", new NBTStreamer.ByteReader(){

            @Override
            public void run(int index, int value) {
                try {
                    SchematicStreamer.this.datas.write(value);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        });
        this.addReader("Schematic.AddBlocks.#", new NBTStreamer.ByteReader(){

            @Override
            public void run(int index, int value) {
                if (value != 0) {
                    int first = value & 0xF;
                    int second = (value & 0xF0) >> 4;
                    int gIndex = index << 1;
                    try {
                        if (first != 0) {
                            SchematicStreamer.this.adds.write(first);
                        }
                        if (second != 0) {
                            SchematicStreamer.this.adds.write(second);
                        }
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        });
        NBTStreamer.ByteReader biomeReader = new NBTStreamer.ByteReader(){

            @Override
            public void run(int index, int value) {
                SchematicStreamer.this.fc.setBiome(index, value);
            }
        };
        NBTStreamer.NBTStreamReader<Integer, Integer> initializer23 = new NBTStreamer.NBTStreamReader<Integer, Integer>(){

            @Override
            public void accept(Integer value1, Integer value2) {
                if (SchematicStreamer.this.fc == null) {
                    SchematicStreamer.this.setupClipboard(SchematicStreamer.this.length * SchematicStreamer.this.width * SchematicStreamer.this.height);
                }
            }
        };
        this.addReader("Schematic.AWEBiomes.?", initializer23);
        this.addReader("Schematic.Biomes.?", initializer23);
        this.addReader("Schematic.AWEBiomes.#", biomeReader);
        this.addReader("Schematic.Biomes.#", biomeReader);
        this.addReader("Schematic.TileEntities.#", new BiConsumer<Integer, CompoundTag>(){

            @Override
            public void accept(Integer index, CompoundTag value) {
                if (SchematicStreamer.this.fc == null) {
                    SchematicStreamer.this.setupClipboard(0);
                }
                int x = value.getInt("x");
                int y = value.getInt("y");
                int z = value.getInt("z");
                SchematicStreamer.this.fc.setTile(x, y, z, value);
            }
        });
        this.addReader("Schematic.Entities.#", new BiConsumer<Integer, CompoundTag>(){

            @Override
            public void accept(Integer index, CompoundTag compound) {
                String id;
                if (SchematicStreamer.this.fc == null) {
                    SchematicStreamer.this.setupClipboard(0);
                }
                if ((id = compound.getString("id")).isEmpty()) {
                    return;
                }
                ListTag positionTag = compound.getListTag("Pos");
                ListTag directionTag = compound.getListTag("Rotation");
                EntityType type = EntityTypes.parse(id);
                if (type != null) {
                    compound.getValue().put("Id", new StringTag(type.getId()));
                    BaseEntity state = new BaseEntity(type, compound);
                    SchematicStreamer.this.fc.createEntity(SchematicStreamer.this.clipboard, positionTag.asDouble(0), positionTag.asDouble(1), positionTag.asDouble(2), (float)directionTag.asDouble(0), (float)directionTag.asDouble(1), state);
                } else {
                    Fawe.debug("Invalid entity: " + id);
                }
            }
        });
    }

    @Override
    public void readFully() throws IOException {
        super.readFully();
        if (this.ids != null) {
            this.ids.close();
        }
        if (this.datas != null) {
            this.datas.close();
        }
        if (this.adds != null) {
            this.adds.close();
        }
        FaweInputStream idIn = new FaweInputStream(new LZ4BlockInputStream(new FastByteArraysInputStream(this.idOut.toByteArrays())));
        FaweInputStream dataIn = new FaweInputStream(new LZ4BlockInputStream(new FastByteArraysInputStream(this.dataOut.toByteArrays())));
        LegacyMapper remap = LegacyMapper.getInstance();
        Vector dimensions = this.fc.getDimensions();
        int length = dimensions.getBlockX() * dimensions.getBlockY() * dimensions.getBlockZ();
        if (this.adds == null) {
            for (int i = 0; i < length; ++i) {
                this.fc.setBlock(i, remap.getBlockFromLegacyCombinedId(((idIn.read() & 0xFF) << 4) + (dataIn.read() & 0xF)));
            }
        } else {
            FaweInputStream addIn = new FaweInputStream(new LZ4BlockInputStream(new FastByteArraysInputStream(this.dataOut.toByteArrays())));
            for (int i = 0; i < length; ++i) {
                this.fc.setBlock(i, remap.getBlockFromLegacyCombinedId(((addIn.read() & 0xFF) << 8) + ((idIn.read() & 0xFF) << 4) + (dataIn.read() & 0xF)));
            }
            addIn.close();
        }
        idIn.close();
        dataIn.close();
    }

    private void fixStates() {
        this.fc.forEach(new FaweClipboard.BlockReader(){

            @Override
            public void run(int x, int y, int z, BlockState block) {
                BlockTypes type = block.getBlockType();
                switch (type) {
                    case ACACIA_STAIRS: 
                    case BIRCH_STAIRS: 
                    case BRICK_STAIRS: 
                    case COBBLESTONE_STAIRS: 
                    case DARK_OAK_STAIRS: 
                    case DARK_PRISMARINE_STAIRS: 
                    case JUNGLE_STAIRS: 
                    case NETHER_BRICK_STAIRS: 
                    case OAK_STAIRS: 
                    case PRISMARINE_BRICK_STAIRS: 
                    case PRISMARINE_STAIRS: 
                    case PURPUR_STAIRS: 
                    case QUARTZ_STAIRS: 
                    case RED_SANDSTONE_STAIRS: 
                    case SANDSTONE_STAIRS: 
                    case SPRUCE_STAIRS: 
                    case STONE_BRICK_STAIRS: {
                        BlockState backwardsBlock;
                        BlockTypes backwardsType;
                        Object half = block.getState(PropertyKey.HALF);
                        Direction facing = (Direction)((Object)block.getState(PropertyKey.FACING));
                        BlockVector forward = facing.toBlockVector();
                        Direction left = facing.getLeft();
                        Direction right = facing.getRight();
                        BlockState forwardBlock = SchematicStreamer.this.fc.getBlock(x + forward.getBlockX(), y + forward.getBlockY(), z + forward.getBlockZ());
                        BlockTypes forwardType = forwardBlock.getBlockType();
                        if (forwardType.hasProperty(PropertyKey.SHAPE) && forwardType.hasProperty(PropertyKey.FACING)) {
                            Direction forwardFacing = (Direction)((Object)forwardBlock.getState(PropertyKey.FACING));
                            if (forwardFacing == left) {
                                BlockState rightBlock = SchematicStreamer.this.fc.getBlock(x + right.getBlockX(), y + right.getBlockY(), z + right.getBlockZ());
                                BlockTypes rightType = rightBlock.getBlockType();
                                if (!rightType.hasProperty(PropertyKey.SHAPE) || rightBlock.getState(PropertyKey.FACING) != facing) {
                                    SchematicStreamer.this.fc.setBlock(x, y, z, block.with(PropertyKey.SHAPE, (Object)"inner_left"));
                                }
                                return;
                            }
                            if (forwardFacing == right) {
                                BlockState leftBlock = SchematicStreamer.this.fc.getBlock(x + left.getBlockX(), y + left.getBlockY(), z + left.getBlockZ());
                                BlockTypes leftType = leftBlock.getBlockType();
                                if (!leftType.hasProperty(PropertyKey.SHAPE) || leftBlock.getState(PropertyKey.FACING) != facing) {
                                    SchematicStreamer.this.fc.setBlock(x, y, z, block.with(PropertyKey.SHAPE, (Object)"inner_right"));
                                }
                                return;
                            }
                        }
                        if (!(backwardsType = (backwardsBlock = SchematicStreamer.this.fc.getBlock(x - forward.getBlockX(), y - forward.getBlockY(), z - forward.getBlockZ())).getBlockType()).hasProperty(PropertyKey.SHAPE) || !backwardsType.hasProperty(PropertyKey.FACING)) break;
                        Direction backwardsFacing = (Direction)((Object)backwardsBlock.getState(PropertyKey.FACING));
                        if (backwardsFacing == left) {
                            BlockState rightBlock = SchematicStreamer.this.fc.getBlock(x + right.getBlockX(), y + right.getBlockY(), z + right.getBlockZ());
                            BlockTypes rightType = rightBlock.getBlockType();
                            if (!rightType.hasProperty(PropertyKey.SHAPE) || rightBlock.getState(PropertyKey.FACING) != facing) {
                                SchematicStreamer.this.fc.setBlock(x, y, z, block.with(PropertyKey.SHAPE, (Object)"outer_left"));
                            }
                            return;
                        }
                        if (backwardsFacing != right) break;
                        BlockState leftBlock = SchematicStreamer.this.fc.getBlock(x + left.getBlockX(), y + left.getBlockY(), z + left.getBlockZ());
                        BlockTypes leftType = leftBlock.getBlockType();
                        if (!leftType.hasProperty(PropertyKey.SHAPE) || leftBlock.getState(PropertyKey.FACING) != facing) {
                            SchematicStreamer.this.fc.setBlock(x, y, z, block.with(PropertyKey.SHAPE, (Object)"outer_right"));
                        }
                        return;
                    }
                    default: {
                        int ew;
                        int ns;
                        int group = SchematicStreamer.this.group(type);
                        if (group == -1) {
                            return;
                        }
                        BlockStateHolder<BlockState> set = block;
                        if (set.getState(PropertyKey.NORTH) == Boolean.FALSE && SchematicStreamer.this.merge(group, x, y, z - 1)) {
                            set = set.with(PropertyKey.NORTH, Boolean.valueOf(true));
                        }
                        if (set.getState(PropertyKey.EAST) == Boolean.FALSE && SchematicStreamer.this.merge(group, x + 1, y, z)) {
                            set = set.with(PropertyKey.EAST, Boolean.valueOf(true));
                        }
                        if (set.getState(PropertyKey.SOUTH) == Boolean.FALSE && SchematicStreamer.this.merge(group, x, y, z + 1)) {
                            set = set.with(PropertyKey.SOUTH, Boolean.valueOf(true));
                        }
                        if (set.getState(PropertyKey.WEST) == Boolean.FALSE && SchematicStreamer.this.merge(group, x - 1, y, z)) {
                            set = set.with(PropertyKey.WEST, Boolean.valueOf(true));
                        }
                        if (group == 2 && (Math.abs((ns = ((Boolean)set.getState(PropertyKey.NORTH) != false ? 1 : 0) + ((Boolean)set.getState(PropertyKey.SOUTH) != false ? 1 : 0)) - (ew = ((Boolean)set.getState(PropertyKey.EAST) != false ? 1 : 0) + ((Boolean)set.getState(PropertyKey.WEST) != false ? 1 : 0))) != 2 || SchematicStreamer.this.fc.getBlock(x, y + 1, z).getBlockType().getMaterial().isSolid())) {
                            set = set.with(PropertyKey.UP, Boolean.valueOf(true));
                        }
                        if (set == block) break;
                        SchematicStreamer.this.fc.setBlock(x, y, z, set);
                    }
                }
            }
        }, false);
    }

    private boolean merge(int group, int x, int y, int z) {
        BlockState block = this.fc.getBlock(x, y, z);
        BlockTypes type = block.getBlockType();
        return this.group(type) == group || this.fullCube.apply(type) != false;
    }

    private int group(BlockTypes type) {
        switch (type) {
            case ACACIA_FENCE: 
            case BIRCH_FENCE: 
            case DARK_OAK_FENCE: 
            case JUNGLE_FENCE: 
            case OAK_FENCE: 
            case SPRUCE_FENCE: {
                return 0;
            }
            case NETHER_BRICK_FENCE: {
                return 1;
            }
            case COBBLESTONE_WALL: 
            case MOSSY_COBBLESTONE_WALL: {
                return 2;
            }
            case IRON_BARS: 
            case BLACK_STAINED_GLASS_PANE: 
            case BLUE_STAINED_GLASS_PANE: 
            case BROWN_MUSHROOM_BLOCK: 
            case BROWN_STAINED_GLASS_PANE: 
            case CYAN_STAINED_GLASS_PANE: 
            case GLASS_PANE: 
            case GRAY_STAINED_GLASS_PANE: 
            case GREEN_STAINED_GLASS_PANE: 
            case LIGHT_BLUE_STAINED_GLASS_PANE: 
            case LIGHT_GRAY_STAINED_GLASS_PANE: 
            case LIME_STAINED_GLASS_PANE: 
            case MAGENTA_STAINED_GLASS_PANE: 
            case ORANGE_STAINED_GLASS_PANE: 
            case PINK_STAINED_GLASS_PANE: 
            case PURPLE_STAINED_GLASS_PANE: 
            case RED_STAINED_GLASS_PANE: 
            case WHITE_STAINED_GLASS_PANE: 
            case YELLOW_STAINED_GLASS_PANE: {
                return 3;
            }
        }
        return -1;
    }

    public void addDimensionReaders() {
        this.addReader("Schematic.Height", new BiConsumer<Integer, Short>(){

            @Override
            public void accept(Integer index, Short value) {
                SchematicStreamer.this.height = value.shortValue();
            }
        });
        this.addReader("Schematic.Width", new BiConsumer<Integer, Short>(){

            @Override
            public void accept(Integer index, Short value) {
                SchematicStreamer.this.width = value.shortValue();
            }
        });
        this.addReader("Schematic.Length", new BiConsumer<Integer, Short>(){

            @Override
            public void accept(Integer index, Short value) {
                SchematicStreamer.this.length = value.shortValue();
            }
        });
        this.addReader("Schematic.WEOriginX", new BiConsumer<Integer, Integer>(){

            @Override
            public void accept(Integer index, Integer value) {
                SchematicStreamer.this.originX = value;
            }
        });
        this.addReader("Schematic.WEOriginY", new BiConsumer<Integer, Integer>(){

            @Override
            public void accept(Integer index, Integer value) {
                SchematicStreamer.this.originY = value;
            }
        });
        this.addReader("Schematic.WEOriginZ", new BiConsumer<Integer, Integer>(){

            @Override
            public void accept(Integer index, Integer value) {
                SchematicStreamer.this.originZ = value;
            }
        });
        this.addReader("Schematic.WEOffsetX", new BiConsumer<Integer, Integer>(){

            @Override
            public void accept(Integer index, Integer value) {
                SchematicStreamer.this.offsetX = value;
            }
        });
        this.addReader("Schematic.WEOffsetY", new BiConsumer<Integer, Integer>(){

            @Override
            public void accept(Integer index, Integer value) {
                SchematicStreamer.this.offsetY = value;
            }
        });
        this.addReader("Schematic.WEOffsetZ", new BiConsumer<Integer, Integer>(){

            @Override
            public void accept(Integer index, Integer value) {
                SchematicStreamer.this.offsetZ = value;
            }
        });
    }

    private FaweClipboard setupClipboard(int size) {
        if (this.fc != null) {
            if (this.fc.getDimensions().getX() == 0.0) {
                this.fc.setDimensions(new Vector(size, 1, 1));
            }
            return this.fc;
        }
        if (Settings.IMP.CLIPBOARD.USE_DISK) {
            this.fc = new DiskOptimizedClipboard(size, 1, 1, this.uuid);
            return this.fc;
        }
        if (Settings.IMP.CLIPBOARD.COMPRESSION_LEVEL == 0) {
            this.fc = new CPUOptimizedClipboard(size, 1, 1);
            return this.fc;
        }
        this.fc = new MemoryOptimizedClipboard(size, 1, 1);
        return this.fc;
    }

    public Vector getOrigin() {
        return new Vector(this.originX, this.originY, this.originZ);
    }

    public Vector getOffset() {
        return new Vector(this.offsetX, this.offsetY, this.offsetZ);
    }

    public Vector getDimensions() {
        return new Vector(this.width, this.height, this.length);
    }

    public void setClipboard(FaweClipboard clipboard) {
        this.fc = clipboard;
    }

    public Clipboard getClipboard() throws IOException {
        try {
            this.addDimensionReaders();
            this.addBlockReaders();
            this.readFully();
            Vector min = new Vector(this.originX, this.originY, this.originZ);
            Vector offset = new Vector(this.offsetX, this.offsetY, this.offsetZ);
            Vector origin = min.subtract(offset);
            Vector dimensions = new Vector(this.width, this.height, this.length);
            this.fc.setDimensions(dimensions);
            this.fixStates();
            CuboidRegion region = new CuboidRegion(min, min.add(this.width, this.height, this.length).subtract(Vector.ONE));
            this.clipboard.init(region, this.fc);
            this.clipboard.setOrigin(origin);
            return this.clipboard;
        }
        catch (Throwable e) {
            if (this.fc != null) {
                this.fc.close();
            }
            throw e;
        }
    }
}

