/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.config;

import com.boydti.fawe.configuration.ConfigurationSection;
import com.boydti.fawe.configuration.file.YamlConfiguration;
import com.sk89q.minecraft.util.commands.Command;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Commands {
    private static YamlConfiguration cmdConfig;
    private static File cmdFile;

    public static void load(File file) {
        cmdFile = file;
        try {
            if (!file.exists()) {
                file.getParentFile().mkdirs();
                file.createNewFile();
            }
            cmdConfig = YamlConfiguration.loadConfiguration(file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static Command fromArgs(final String[] aliases, final String usage, final String desc, final int min, Integer max, final String flags, final String help, final boolean queued) {
        final int finalMax = max == null ? -1 : max;
        return new Command(){

            @Override
            public Class<? extends Annotation> annotationType() {
                return Command.class;
            }

            @Override
            public String[] aliases() {
                return aliases;
            }

            @Override
            public String usage() {
                return usage;
            }

            @Override
            public String desc() {
                return desc;
            }

            @Override
            public int min() {
                return min;
            }

            @Override
            public int max() {
                return finalMax;
            }

            @Override
            public String flags() {
                return flags;
            }

            @Override
            public String help() {
                return help;
            }

            @Override
            public boolean anyFlags() {
                return !flags.isEmpty() && !flags.matches("[a-z]+");
            }

            @Override
            public boolean queued() {
                return queued;
            }
        };
    }

    public static Command translate(Class clazz, Command command) {
        if (cmdConfig == null || command instanceof TranslatedCommand) {
            return command;
        }
        return new TranslatedCommand(clazz.getSimpleName(), command);
    }

    public static String getAlias(Class clazz, String command) {
        if (cmdConfig == null) {
            return command;
        }
        List<String> aliases = cmdConfig.getStringList(clazz + "." + command + ".aliases");
        if (aliases == null) {
            aliases = cmdConfig.getStringList(command + ".aliases");
        }
        return aliases == null || aliases.isEmpty() ? command : aliases.get(0);
    }

    public static class TranslatedCommand
    implements Command {
        private final String[] aliases;
        private final String usage;
        private final String desc;
        private final String help;
        private final Command command;

        public TranslatedCommand(String clazz, Command command) {
            String id = command.aliases()[0];
            ConfigurationSection commands = cmdConfig.contains(clazz + "." + id) || !cmdConfig.contains(id) ? cmdConfig.getConfigurationSection(clazz + "." + id) : cmdConfig.getConfigurationSection(id);
            boolean set = false;
            if (commands == null) {
                commands = cmdConfig.createSection(clazz + "." + id);
                set = commands != null;
            }
            HashMap<String, Object> options = new HashMap<String, Object>();
            options.put("aliases", new ArrayList<String>(Arrays.asList(command.aliases())));
            options.put("usage", command.usage());
            options.put("desc", command.desc());
            options.put("help", command.help());
            for (Map.Entry entry : options.entrySet()) {
                String key = (String)entry.getKey();
                if (commands.contains(key)) continue;
                commands.set(key, entry.getValue());
                set = true;
            }
            if (set) {
                try {
                    cmdConfig.save(cmdFile);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            this.aliases = commands.getStringList("aliases").toArray(new String[0]);
            this.usage = commands.getString("usage");
            this.desc = commands.getString("desc");
            this.help = commands.getString("help");
            this.command = command;
        }

        @Override
        public Class<? extends Annotation> annotationType() {
            return this.command.annotationType();
        }

        @Override
        public String[] aliases() {
            return this.aliases;
        }

        @Override
        public String usage() {
            return this.usage;
        }

        @Override
        public String desc() {
            return this.desc;
        }

        @Override
        public int min() {
            return this.command.min();
        }

        @Override
        public int max() {
            return this.command.max();
        }

        @Override
        public String flags() {
            return this.command.flags();
        }

        @Override
        public String help() {
            return this.help;
        }

        @Override
        public boolean anyFlags() {
            return this.command.anyFlags();
        }

        @Override
        public boolean queued() {
            return this.command.queued();
        }
    }
}

