/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.bukkit.v0;

import com.boydti.fawe.bukkit.util.BukkitReflectionUtils;
import com.boydti.fawe.bukkit.v0.BukkitChunk_All;
import com.boydti.fawe.bukkit.v0.BukkitQueue_0;
import com.boydti.fawe.bukkit.v0.PaperChunkCallback;
import com.boydti.fawe.config.Settings;
import com.boydti.fawe.example.NullRelighter;
import com.boydti.fawe.example.Relighter;
import com.boydti.fawe.object.FaweChunk;
import com.boydti.fawe.object.FaweQueue;
import com.boydti.fawe.object.RegionWrapper;
import com.boydti.fawe.object.RunnableVal;
import com.boydti.fawe.util.MathMan;
import com.boydti.fawe.util.ReflectionUtils;
import com.boydti.fawe.util.SetQueue;
import com.boydti.fawe.util.TaskManager;
import com.google.common.collect.MapMaker;
import com.sk89q.jnbt.CompoundTag;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.world.World;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockTypes;
import java.io.File;
import java.io.RandomAccessFile;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayDeque;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.bukkit.Chunk;
import org.bukkit.ChunkSnapshot;
import org.bukkit.Location;
import org.bukkit.block.Biome;
import org.bukkit.block.data.BlockData;

public class BukkitQueue_All
extends BukkitQueue_0<ChunkSnapshot, ChunkSnapshot, ChunkSnapshot> {
    private ConcurrentMap<Long, ChunkSnapshot> chunkCache = new MapMaker().weakValues().makeMap();
    private static Class<?> classRegionFileCache;
    private static Class<?> classRegionFile;
    private static Class<?> classCraftChunk;
    private static Class<?> classCraftWorld;
    private static Class<?> classNMSChunk;
    private static Class<?> classNMSWorld;
    private static Class<?> classChunkProviderServer;
    private static Class<?> classIChunkLoader;
    private static Class<?> classChunkRegionLoader;
    private static Class<?> classIChunkProvider;
    private static Method methodGetHandleChunk;
    private static Method methodGetHandleWorld;
    private static Method methodFlush;
    private static Method methodNeedsSaving;
    private static Field fieldChunkProvider;
    private static Field fieldChunkLoader;
    private static Field fieldRegionMap;
    private static Field fieldRegionRAF;
    private int skip;
    private Field fieldNeighbors;
    private Method chunkGetHandle;

    public BukkitQueue_All(World world) {
        super(world);
        Settings.IMP.QUEUE.PARALLEL_THREADS = 1;
    }

    public BukkitQueue_All(String world) {
        super(world);
        Settings.IMP.QUEUE.PARALLEL_THREADS = 1;
    }

    @Override
    public boolean queueChunkLoad(int cx, int cz, final RunnableVal<ChunkSnapshot> operation) {
        if (PAPER) {
            try {
                new PaperChunkCallback(this.getImpWorld(), cx, cz){

                    @Override
                    public void onLoad(Chunk chunk) {
                        try {
                            ChunkSnapshot snapshot = BukkitQueue_All.this.tryGetSnasphot(chunk);
                            operation.run(snapshot);
                        }
                        catch (Throwable e) {
                            BukkitQueue_0.PAPER = false;
                        }
                    }
                };
                return true;
            }
            catch (Throwable ignore) {
                PAPER = false;
            }
        }
        return super.queueChunkLoad(cx, cz);
    }

    @Override
    public Relighter getRelighter() {
        return NullRelighter.INSTANCE;
    }

    @Override
    public boolean setMCA(final int mcaX, final int mcaZ, RegionWrapper allowed, final Runnable whileLocked, final boolean saveChunks, final boolean load) {
        if (classRegionFileCache == null) {
            return super.setMCA(mcaX, mcaZ, allowed, whileLocked, saveChunks, load);
        }
        TaskManager.IMP.sync(new RunnableVal<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run(Boolean value) {
                long start;
                long last = start = System.currentTimeMillis();
                Class clazz = classRegionFileCache;
                synchronized (clazz) {
                    try {
                        File file;
                        Map regionMap;
                        Object regionFile;
                        final org.bukkit.World world = (org.bukkit.World)BukkitQueue_All.this.getWorld();
                        boolean autoSave = world.isAutoSave();
                        if (world.getKeepSpawnInMemory()) {
                            world.setKeepSpawnInMemory(false);
                        }
                        ArrayDeque<Chunk> unloaded = null;
                        if (load) {
                            int bcx = mcaX << 5;
                            int bcz = mcaZ << 5;
                            int tcx = bcx + 31;
                            int tcz = bcz + 31;
                            for (Chunk chunk : world.getLoadedChunks()) {
                                int cx = chunk.getX();
                                int cz = chunk.getZ();
                                if (cx < bcx || cx > tcx || cz < bcz || cz > tcz) continue;
                                Object nmsChunk = methodGetHandleChunk.invoke((Object)chunk, new Object[0]);
                                boolean mustSave = saveChunks && (Boolean)methodNeedsSaving.invoke(nmsChunk, false) != false;
                                chunk.unload(mustSave, false);
                                if (unloaded == null) {
                                    unloaded = new ArrayDeque<Chunk>();
                                }
                                unloaded.add(chunk);
                            }
                        } else {
                            world.save();
                        }
                        Object nmsWorld = methodGetHandleWorld.invoke((Object)world, new Object[0]);
                        Object chunkProviderServer = fieldChunkProvider.get(nmsWorld);
                        Object chunkRegionLoader = fieldChunkLoader.get(chunkProviderServer);
                        while (((Boolean)methodFlush.invoke(chunkRegionLoader, new Object[0])).booleanValue()) {
                        }
                        if (unloaded != null && (regionFile = (regionMap = (Map)fieldRegionMap.get(null)).remove(file = new File(world.getWorldFolder(), "region" + File.separator + "r." + mcaX + "." + mcaZ + ".mca"))) != null) {
                            RandomAccessFile raf = (RandomAccessFile)fieldRegionRAF.get(regionFile);
                            raf.close();
                        }
                        whileLocked.run();
                        if (load && unloaded != null) {
                            final ArrayDeque<Chunk> finalUnloaded = unloaded;
                            TaskManager.IMP.async(new Runnable(){

                                @Override
                                public void run() {
                                    for (Chunk chunk : finalUnloaded) {
                                        int cz;
                                        int cx = chunk.getX();
                                        if (world.isChunkLoaded(cx, cz = chunk.getZ())) continue;
                                        SetQueue.IMP.addTask(() -> {
                                            world.loadChunk(chunk.getX(), chunk.getZ(), false);
                                            world.refreshChunk(chunk.getX(), chunk.getZ());
                                        });
                                    }
                                }
                            });
                        }
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                }
            }
        });
        return true;
    }

    @Override
    public void setHeightMap(FaweChunk chunk, byte[] heightMap) {
    }

    @Override
    public void setSkyLight(ChunkSnapshot chunk, int x, int y, int z, int value) {
    }

    @Override
    public void setBlockLight(ChunkSnapshot chunk, int x, int y, int z, int value) {
    }

    @Override
    public int getCombinedId4Data(ChunkSnapshot chunk, int x, int y, int z) {
        if (chunk.isSectionEmpty(y >> 4)) {
            return BlockTypes.AIR.getInternalId();
        }
        BlockData blockData = chunk.getBlockData(x & 0xF, y, z & 0xF);
        return BukkitAdapter.adapt(blockData).getInternalId();
    }

    @Override
    public int getBiome(ChunkSnapshot chunkSnapshot, int x, int z) {
        Biome biome = chunkSnapshot.getBiome(x & 0xF, z & 0xF);
        return BukkitQueue_All.getAdapter().getBiomeId(biome);
    }

    @Override
    public ChunkSnapshot getSections(ChunkSnapshot chunkSnapshot) {
        return chunkSnapshot;
    }

    @Override
    public ChunkSnapshot getCachedChunk(org.bukkit.World world, int cx, int cz) {
        long pair = MathMan.pairInt(cx, cz);
        ChunkSnapshot cached = (ChunkSnapshot)this.chunkCache.get(pair);
        if (cached != null) {
            return cached;
        }
        if (world.isChunkLoaded(cx, cz)) {
            Long originalKeep = (Long)keepLoaded.get(pair);
            keepLoaded.put(pair, Long.MAX_VALUE);
            if (world.isChunkLoaded(cx, cz)) {
                Chunk chunk = world.getChunkAt(cx, cz);
                ChunkSnapshot snapshot = this.getAndCacheChunk(chunk);
                if (originalKeep != null) {
                    keepLoaded.put(pair, originalKeep);
                } else {
                    keepLoaded.remove(pair);
                }
                return snapshot;
            }
            keepLoaded.remove(pair);
            return null;
        }
        return null;
    }

    @Override
    public int getEmmittedLight(ChunkSnapshot chunk, int x, int y, int z) {
        return chunk.getBlockEmittedLight(x & 0xF, y, z & 0xF);
    }

    @Override
    public int getSkyLight(ChunkSnapshot chunk, int x, int y, int z) {
        return chunk.getBlockSkyLight(x & 0xF, y, z & 0xF);
    }

    @Override
    public int getLight(ChunkSnapshot chunk, int x, int y, int z) {
        return Math.max(chunk.getBlockEmittedLight(x &= 0xF, y, z &= 0xF), chunk.getBlockSkyLight(x, y, z));
    }

    @Override
    public ChunkSnapshot loadChunk(org.bukkit.World world, int x, int z, boolean generate) {
        Chunk chunk = world.getChunkAt(x, z);
        chunk.load(generate);
        return chunk.isLoaded() ? this.getAndCacheChunk(chunk) : null;
    }

    private ChunkSnapshot tryGetSnasphot(Chunk chunk) {
        try {
            return chunk.getChunkSnapshot(false, true, false);
        }
        catch (Throwable ignore) {
            Throwable cause = ignore;
            while (cause.getCause() != null) {
                cause = cause.getCause();
            }
            if (cause instanceof IllegalStateException) {
                return null;
            }
            throw ignore;
        }
    }

    private ChunkSnapshot getAndCacheChunk(Chunk chunk) {
        ChunkSnapshot snapshot = this.tryGetSnasphot(chunk);
        if (snapshot == null && (snapshot = this.tryGetSnasphot(chunk)) == null && (snapshot = TaskManager.IMP.sync(() -> this.tryGetSnasphot(chunk))) == null) {
            snapshot = chunk.getChunkSnapshot(false, true, false);
        }
        this.chunkCache.put(MathMan.pairInt(chunk.getX(), chunk.getZ()), snapshot);
        return snapshot;
    }

    @Override
    public ChunkSnapshot getCachedSections(org.bukkit.World impWorld, int cx, int cz) {
        return this.getCachedChunk(impWorld, cx, cz);
    }

    @Override
    public CompoundTag getTileEntity(ChunkSnapshot chunk, int x, int y, int z) {
        if (BukkitQueue_All.getAdapter() == null) {
            return null;
        }
        Location loc = new Location((org.bukkit.World)this.getWorld(), (double)x, (double)y, (double)z);
        BlockState block = BukkitQueue_All.getAdapter().getBlock(loc);
        return block.getNbtData();
    }

    @Override
    public FaweChunk getFaweChunk(int x, int z) {
        return new BukkitChunk_All(this, x, z);
    }

    @Override
    public boolean supports(FaweQueue.Capability capability) {
        switch (capability) {
            case CHANGE_TASKS: {
                return BukkitQueue_All.getAdapter() != null;
            }
        }
        return super.supports(capability);
    }

    @Override
    public void startSet(boolean parallel) {
        super.startSet(true);
    }

    protected Object[] disableLighting(Chunk chunk) {
        try {
            if (this.chunkGetHandle == null) {
                this.chunkGetHandle = chunk.getClass().getDeclaredMethod("getHandle", new Class[0]);
                this.chunkGetHandle.setAccessible(true);
            }
            Object nmsChunk = this.chunkGetHandle.invoke((Object)chunk, new Object[0]);
            if (this.fieldNeighbors == null) {
                this.fieldNeighbors = nmsChunk.getClass().getDeclaredField("neighbors");
                this.fieldNeighbors.setAccessible(true);
            }
            Object value = this.fieldNeighbors.get(nmsChunk);
            this.fieldNeighbors.set(nmsChunk, 0);
            return new Object[]{nmsChunk, value};
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    protected void disableLighting(Object[] disableResult) {
        if (disableResult != null) {
            try {
                this.fieldNeighbors.set(disableResult[0], 0);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }

    protected void resetLighting(Object[] disableResult) {
        if (disableResult != null) {
            try {
                this.fieldNeighbors.set(disableResult[0], disableResult[1]);
            }
            catch (Throwable ignore) {
                ignore.printStackTrace();
            }
        }
    }

    protected void enableLighting(Object[] disableResult) {
        if (disableResult != null) {
            try {
                this.fieldNeighbors.set(disableResult[0], 473536);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    @Override
    public void endSet(boolean parallel) {
        super.endSet(true);
    }

    static {
        try {
            BukkitReflectionUtils.init();
            classRegionFileCache = BukkitReflectionUtils.getNmsClass("RegionFileCache");
            classRegionFile = BukkitReflectionUtils.getNmsClass("RegionFile");
            classCraftChunk = BukkitReflectionUtils.getCbClass("CraftChunk");
            classNMSChunk = BukkitReflectionUtils.getNmsClass("Chunk");
            classCraftWorld = BukkitReflectionUtils.getCbClass("CraftWorld");
            classNMSWorld = BukkitReflectionUtils.getNmsClass("World");
            classChunkProviderServer = BukkitReflectionUtils.getNmsClass("ChunkProviderServer");
            classIChunkProvider = BukkitReflectionUtils.getNmsClass("IChunkProvider");
            classIChunkLoader = BukkitReflectionUtils.getNmsClass("IChunkLoader");
            classChunkRegionLoader = BukkitReflectionUtils.getNmsClass("ChunkRegionLoader");
            methodGetHandleChunk = ReflectionUtils.setAccessible(classCraftChunk.getDeclaredMethod("getHandle", new Class[0]));
            methodGetHandleWorld = ReflectionUtils.setAccessible(classCraftWorld.getDeclaredMethod("getHandle", new Class[0]));
            methodFlush = ReflectionUtils.findMethod(classChunkRegionLoader, Boolean.TYPE, new Class[0]);
            methodNeedsSaving = ReflectionUtils.findMethod(classNMSChunk, Boolean.TYPE, Boolean.TYPE);
            fieldChunkProvider = ReflectionUtils.findField(classNMSWorld, classIChunkProvider);
            fieldChunkLoader = ReflectionUtils.findField(classChunkProviderServer, classIChunkLoader);
            fieldRegionMap = ReflectionUtils.findField(classRegionFileCache, Map.class);
            fieldRegionRAF = ReflectionUtils.findField(classRegionFile, RandomAccessFile.class);
        }
        catch (Throwable ignore) {
            ignore.printStackTrace();
        }
    }
}

