/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.bukkit.regions;

import com.boydti.fawe.bukkit.regions.BukkitMask;
import com.boydti.fawe.bukkit.regions.BukkitMaskManager;
import com.boydti.fawe.bukkit.wrapper.AsyncBlock;
import com.boydti.fawe.bukkit.wrapper.AsyncWorld;
import com.boydti.fawe.object.FawePlayer;
import com.boydti.fawe.object.queue.NullFaweQueue;
import com.boydti.fawe.regions.FaweMask;
import com.boydti.fawe.regions.FaweMaskManager;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.world.block.BlockTypes;
import java.util.ArrayList;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventException;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.RegisteredListener;

public class FreeBuildRegion
extends BukkitMaskManager {
    private final ArrayList<RegisteredListener> listeners = new ArrayList();

    public FreeBuildRegion() {
        super("freebuild");
        RegisteredListener[] listeners;
        for (RegisteredListener listener : listeners = BlockBreakEvent.getHandlerList().getRegisteredListeners()) {
            if (listener.getPriority() == EventPriority.MONITOR || !listener.isIgnoringCancelled()) continue;
            this.listeners.add(listener);
        }
    }

    @Override
    public boolean isExclusive() {
        return true;
    }

    @Override
    public FaweMask getMask(FawePlayer<Player> player, FaweMaskManager.MaskType type) {
        Vector vec1;
        if (type != FaweMaskManager.MaskType.MEMBER) {
            return null;
        }
        ArrayList<RegisteredListener> currRegList = new ArrayList<RegisteredListener>();
        for (RegisteredListener listener : this.listeners) {
            String name = listener.getPlugin().getName();
            if (!player.hasPermission("fawe.freebuild." + name.toLowerCase())) continue;
            currRegList.add(listener);
        }
        if (currRegList.isEmpty()) {
            return null;
        }
        final RegisteredListener[] listeners = currRegList.toArray(new RegisteredListener[currRegList.size()]);
        final World bukkitWorld = ((Player)player.parent).getWorld();
        AsyncWorld asyncWorld = AsyncWorld.wrap(bukkitWorld);
        final Vector vec2 = vec1 = new Vector(0, 0, 0);
        Location pos1 = BukkitAdapter.adapt(bukkitWorld, vec1);
        Location pos2 = BukkitAdapter.adapt(bukkitWorld, vec2);
        final AsyncBlock block = new AsyncBlock(asyncWorld, new NullFaweQueue(asyncWorld.getWorldName(), BlockTypes.STONE.getDefaultState()), 0, 0, 0);
        final BlockBreakEvent event = new BlockBreakEvent((Block)block, (Player)player.parent);
        return new BukkitMask(pos1, pos2){

            @Override
            public String getName() {
                return "freebuild-global";
            }

            @Override
            public boolean isValid(FawePlayer player, FaweMaskManager.MaskType type) {
                return bukkitWorld == ((Player)player.parent).getWorld() && type == FaweMaskManager.MaskType.MEMBER;
            }

            @Override
            public Region getRegion() {
                return new CuboidRegion(vec1, vec2){
                    private int lastX;
                    private int lastZ;
                    private boolean lastResult;
                    {
                        this.lastX = Integer.MIN_VALUE;
                        this.lastZ = Integer.MIN_VALUE;
                    }

                    @Override
                    public boolean contains(int x, int z) {
                        return this.contains(x, 127, z);
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public boolean contains(int x, int y, int z) {
                        if (x == this.lastX && z == this.lastZ) {
                            return this.lastResult;
                        }
                        this.lastX = x;
                        this.lastZ = z;
                        event.setCancelled(false);
                        block.setPosition(x, y, z);
                        try {
                            PluginManager pluginManager = Bukkit.getPluginManager();
                            synchronized (pluginManager) {
                                for (RegisteredListener listener : listeners) {
                                    listener.callEvent((Event)event);
                                }
                            }
                        }
                        catch (EventException e) {
                            throw new RuntimeException(e);
                        }
                        this.lastResult = !event.isCancelled();
                        return this.lastResult;
                    }
                };
            }
        };
    }
}

