/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.util.command.fluent;

import com.boydti.fawe.config.Commands;
import com.sk89q.minecraft.util.commands.Command;
import com.sk89q.worldedit.util.command.CallableProcessor;
import com.sk89q.worldedit.util.command.CommandCallable;
import com.sk89q.worldedit.util.command.Dispatcher;
import com.sk89q.worldedit.util.command.SimpleDispatcher;
import com.sk89q.worldedit.util.command.fluent.CommandGraph;
import com.sk89q.worldedit.util.command.parametric.ParametricBuilder;
import javax.annotation.Nullable;

public class DispatcherNode {
    private final CommandGraph graph;
    private final DispatcherNode parent;
    private final SimpleDispatcher dispatcher;

    public DispatcherNode(CommandGraph graph, DispatcherNode parent, SimpleDispatcher dispatcher) {
        this.graph = graph;
        this.parent = parent;
        this.dispatcher = dispatcher;
    }

    public DispatcherNode describeAs(String description) {
        this.dispatcher.getDescription().setDescription(description);
        return this;
    }

    public DispatcherNode register(CommandCallable callable, String ... alias) {
        this.dispatcher.registerCommand(callable, alias);
        return this;
    }

    public DispatcherNode registerMethods(Object object) {
        return this.registerMethods(object, null);
    }

    public DispatcherNode registerMethods(Object object, @Nullable CallableProcessor processor) {
        ParametricBuilder builder = this.graph.getBuilder();
        if (builder == null) {
            throw new RuntimeException("No ParametricBuilder set");
        }
        builder.registerMethodsAsCommands(this.getDispatcher(), object, processor);
        return this;
    }

    public DispatcherNode registerSubMethods(Object object) {
        return this.registerSubMethods(object, null);
    }

    public DispatcherNode registerSubMethods(Object object, @Nullable CallableProcessor processor) {
        Class<?> clazz = object.getClass();
        return this.groupAndDescribe(clazz).registerMethods(object, processor).parent();
    }

    public DispatcherNode groupAndDescribe(Class clazz) {
        Command cmd = clazz.getAnnotation(Command.class);
        if (cmd == null) {
            throw new RuntimeException("This class does not have any command annotations");
        }
        cmd = Commands.translate(clazz, cmd);
        DispatcherNode res = this.group(cmd.aliases());
        if (cmd.desc() != null && !cmd.desc().isEmpty()) {
            res = res.describeAs(cmd.desc());
        }
        return res;
    }

    public DispatcherNode group(String ... alias) {
        SimpleDispatcher command = new SimpleDispatcher();
        this.getDispatcher().registerCommand(command, alias);
        DispatcherNode res = new DispatcherNode(this.graph, this, command);
        return res;
    }

    public DispatcherNode parent() {
        if (this.parent != null) {
            return this.parent;
        }
        throw new RuntimeException("This node does not have a parent");
    }

    public CommandGraph graph() {
        return this.graph;
    }

    public Dispatcher getDispatcher() {
        return this.dispatcher;
    }
}

