/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.util;

import com.sk89q.worldedit.BlockVector;
import com.sk89q.worldedit.Vector;
import java.util.HashMap;
import javax.annotation.Nullable;

public enum Direction {
    NORTH(new Vector(0, 0, -1), Flag.CARDINAL, 3, 1),
    EAST(new Vector(1, 0, 0), Flag.CARDINAL, 0, 2),
    SOUTH(new Vector(0, 0, 1), Flag.CARDINAL, 1, 3),
    WEST(new Vector(-1, 0, 0), Flag.CARDINAL, 2, 0),
    UP(new Vector(0, 1, 0), Flag.UPRIGHT, -1, -1),
    DOWN(new Vector(0, -1, 0), Flag.UPRIGHT, -1, -1),
    NORTHEAST(new Vector(1, 0, -1), Flag.ORDINAL, 7, 8),
    NORTHWEST(new Vector(-1, 0, -1), Flag.ORDINAL, 9, 6),
    SOUTHEAST(new Vector(1, 0, 1), Flag.ORDINAL, 6, 9),
    SOUTHWEST(new Vector(-1, 0, 1), Flag.ORDINAL, 8, 7),
    WEST_NORTHWEST(new Vector(-Math.cos(0.39269908169872414), 0.0, -Math.sin(0.39269908169872414)), Flag.SECONDARY_ORDINAL, 9, 6),
    WEST_SOUTHWEST(new Vector(-Math.cos(0.39269908169872414), 0.0, Math.sin(0.39269908169872414)), Flag.SECONDARY_ORDINAL, 8, 7),
    NORTH_NORTHWEST(new Vector(-Math.sin(0.39269908169872414), 0.0, -Math.cos(0.39269908169872414)), Flag.SECONDARY_ORDINAL, 9, 6),
    NORTH_NORTHEAST(new Vector(Math.sin(0.39269908169872414), 0.0, -Math.cos(0.39269908169872414)), Flag.SECONDARY_ORDINAL, 7, 8),
    EAST_NORTHEAST(new Vector(Math.cos(0.39269908169872414), 0.0, -Math.sin(0.39269908169872414)), Flag.SECONDARY_ORDINAL, 7, 8),
    EAST_SOUTHEAST(new Vector(Math.cos(0.39269908169872414), 0.0, Math.sin(0.39269908169872414)), Flag.SECONDARY_ORDINAL, 6, 9),
    SOUTH_SOUTHEAST(new Vector(Math.sin(0.39269908169872414), 0.0, Math.cos(0.39269908169872414)), Flag.SECONDARY_ORDINAL, 6, 9),
    SOUTH_SOUTHWEST(new Vector(-Math.sin(0.39269908169872414), 0.0, Math.cos(0.39269908169872414)), Flag.SECONDARY_ORDINAL, 8, 7);

    private final Vector direction;
    private final BlockVector blockVector;
    private final int flags;
    private final int left;
    private final int right;
    private static HashMap<String, Direction> map;
    public static final Direction[] values;
    public static final Direction[] cardinal;

    private Direction(Vector vector, int flags, int left, int right) {
        this.direction = vector.normalize();
        this.blockVector = new BlockVector(Math.signum(vector.getX()), Math.signum(vector.getY()), Math.signum(vector.getZ()));
        this.flags = flags;
        this.left = left;
        this.right = right;
    }

    public static Direction get(CharSequence sequence) {
        return map.get(sequence);
    }

    public Direction getLeft() {
        return this.left != -1 ? values[this.left] : null;
    }

    public Direction getRight() {
        return this.right != -1 ? values[this.right] : null;
    }

    public double getX() {
        return this.direction.getX();
    }

    public double getY() {
        return this.direction.getY();
    }

    public double getZ() {
        return this.direction.getZ();
    }

    public int getBlockX() {
        return this.blockVector.getBlockX();
    }

    public int getBlockY() {
        return this.blockVector.getBlockY();
    }

    public int getBlockZ() {
        return this.blockVector.getBlockZ();
    }

    public boolean isCardinal() {
        return (this.flags & Flag.CARDINAL) > 0;
    }

    public boolean isOrdinal() {
        return (this.flags & Flag.ORDINAL) > 0;
    }

    public boolean isSecondaryOrdinal() {
        return (this.flags & Flag.SECONDARY_ORDINAL) > 0;
    }

    public boolean isUpright() {
        return (this.flags & Flag.UPRIGHT) > 0;
    }

    public Vector toVector() {
        return this.direction;
    }

    public BlockVector toBlockVector() {
        return this.blockVector;
    }

    public String toString() {
        return this.name().toLowerCase();
    }

    @Nullable
    public static Direction findClosest(Vector vector, int flags) {
        if ((flags & Flag.UPRIGHT) == 0) {
            vector = vector.setY(0);
        }
        vector = vector.normalize();
        Direction closest = null;
        double closestDot = -2.0;
        for (Direction direction : Direction.values()) {
            double dot;
            if ((~flags & direction.flags) > 0 || !((dot = direction.toVector().dot(vector)) >= closestDot)) continue;
            closest = direction;
            closestDot = dot;
        }
        return closest;
    }

    static {
        map = new HashMap();
        values = Direction.values();
        cardinal = new Direction[]{NORTH, EAST, SOUTH, WEST};
        for (Direction dir : Direction.values()) {
            map.put(dir.name(), dir);
            map.put(dir.name().toLowerCase(), dir);
        }
    }

    public static final class Flag {
        public static int CARDINAL = 1;
        public static int ORDINAL = 2;
        public static int SECONDARY_ORDINAL = 4;
        public static int UPRIGHT = 8;
        public static int ALL = CARDINAL | ORDINAL | SECONDARY_ORDINAL | UPRIGHT;

        private Flag() {
        }
    }
}

