/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.registry;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;

public class Registry<V>
implements Iterable<V> {
    private final Map<String, V> map = new HashMap<String, V>();
    private final String name;

    public Registry(String name) {
        this.name = name;
    }

    @Nullable
    public V get(String key) {
        Preconditions.checkState((boolean)key.equals(key.toLowerCase()), (Object)"key must be lowercase");
        return this.map.get(key);
    }

    public V register(String key, V value) {
        Objects.requireNonNull(key, "key");
        Objects.requireNonNull(value, "value");
        Preconditions.checkState((boolean)key.equals(key.toLowerCase()), (Object)"key must be lowercase");
        Preconditions.checkState((!this.map.containsKey(key) ? 1 : 0) != 0, (String)"key '%s' already has an associated %s", (Object)key, (Object)this.name);
        this.map.put(key, value);
        return value;
    }

    public Set<String> keySet() {
        return Collections.unmodifiableSet(this.map.keySet());
    }

    public Collection<V> values() {
        return Collections.unmodifiableCollection(this.map.values());
    }

    @Override
    public Iterator<V> iterator() {
        return this.map.values().iterator();
    }
}

