/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.math.transform;

import com.sk89q.worldedit.MutableBlockVector;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.math.transform.Transform;

public class RoundedTransform
implements Transform {
    private final Transform transform;
    private MutableBlockVector mutable = new MutableBlockVector();

    public RoundedTransform(Transform transform) {
        this.transform = transform;
    }

    @Override
    public boolean isIdentity() {
        return this.transform.isIdentity();
    }

    @Override
    public Vector apply(Vector input) {
        Vector val = this.transform.apply(input);
        this.mutable.mutX((int)Math.floor(val.getX() + 0.5));
        this.mutable.mutY((int)Math.floor(val.getY() + 0.5));
        this.mutable.mutZ((int)Math.floor(val.getZ() + 0.5));
        return this.mutable;
    }

    @Override
    public RoundedTransform inverse() {
        return new RoundedTransform(this.transform.inverse());
    }

    @Override
    public RoundedTransform combine(Transform other) {
        return new RoundedTransform(this.transform.combine(other));
    }

    public Transform getTransform() {
        return this.transform;
    }
}

