/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.function.pattern;

import com.google.common.base.Preconditions;
import com.sk89q.worldedit.MutableBlockVector;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.extent.clipboard.Clipboard;
import com.sk89q.worldedit.function.pattern.AbstractPattern;
import com.sk89q.worldedit.world.block.BlockStateHolder;

public class ClipboardPattern
extends AbstractPattern {
    private final Clipboard clipboard;
    private final int sx;
    private final int sy;
    private final int sz;
    private final Vector min;
    private MutableBlockVector mutable = new MutableBlockVector();

    public ClipboardPattern(Clipboard clipboard) {
        Preconditions.checkNotNull((Object)clipboard);
        this.clipboard = clipboard;
        Vector size = clipboard.getMaximumPoint().subtract(clipboard.getMinimumPoint()).add(1, 1, 1);
        this.sx = size.getBlockX();
        this.sy = size.getBlockY();
        this.sz = size.getBlockZ();
        this.min = clipboard.getMinimumPoint();
    }

    @Override
    public BlockStateHolder apply(Vector position) {
        int xp = position.getBlockX() % this.sx;
        int yp = position.getBlockY() % this.sy;
        int zp = position.getBlockZ() % this.sz;
        if (xp < 0) {
            xp += this.sx;
        }
        if (yp < 0) {
            yp += this.sy;
        }
        if (zp < 0) {
            zp += this.sz;
        }
        this.mutable.mutX(this.min.getX() + (double)xp);
        this.mutable.mutY(this.min.getY() + (double)yp);
        this.mutable.mutZ(this.min.getZ() + (double)zp);
        return this.clipboard.getBlock(this.mutable);
    }
}

