/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.extent.world;

import com.google.common.base.Preconditions;
import com.sk89q.worldedit.MutableBlockVector;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.extent.AbstractDelegateExtent;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.world.World;
import com.sk89q.worldedit.world.block.BlockStateHolder;

public class SurvivalModeExtent
extends AbstractDelegateExtent {
    private final World world;
    private boolean toolUse = false;

    public SurvivalModeExtent(Extent extent, World world) {
        super(extent);
        Preconditions.checkNotNull((Object)world);
        this.world = world;
    }

    public boolean hasToolUse() {
        return this.toolUse;
    }

    public void setToolUse(boolean toolUse) {
        this.toolUse = toolUse;
    }

    @Override
    public boolean setBlock(Vector location, BlockStateHolder block) throws WorldEditException {
        if (this.toolUse && block.getBlockType().getMaterial().isAir()) {
            this.world.simulateBlockMine(location);
            return true;
        }
        return super.setBlock(location, block);
    }

    @Override
    public boolean setBlock(int x, int y, int z, BlockStateHolder block) throws WorldEditException {
        if (this.toolUse && block.getBlockType().getMaterial().isAir()) {
            this.world.simulateBlockMine(MutableBlockVector.get(x, y, z));
            return true;
        }
        return super.setBlock(x, y, z, block);
    }
}

