/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.extent.cache;

import com.sk89q.worldedit.BlockVector;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.extent.AbstractDelegateExtent;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.world.block.BlockState;

public class LastAccessExtentCache
extends AbstractDelegateExtent {
    private CachedBlock lastBlock;

    public LastAccessExtentCache(Extent extent) {
        super(extent);
    }

    @Override
    public BlockState getBlock(Vector position) {
        BlockVector blockVector = position.toBlockVector();
        CachedBlock lastBlock = this.lastBlock;
        if (lastBlock != null && lastBlock.position.equals(blockVector)) {
            return lastBlock.block;
        }
        BlockState block = super.getBlock(position);
        this.lastBlock = new CachedBlock(blockVector, block);
        return block;
    }

    private static class CachedBlock {
        private final BlockVector position;
        private final BlockState block;

        private CachedBlock(BlockVector position, BlockState block) {
            this.position = position;
            this.block = block;
        }
    }
}

